/*
 * Decompiled with CFR 0.152.
 */
package minechem.integration.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.Internal;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.config.ServerInfo;
import mezz.jei.startup.StackHelper;
import mezz.jei.transfer.BasicRecipeTransferInfo;
import mezz.jei.util.Log;
import mezz.jei.util.Translator;
import minechem.container.ContainerSynthesis;
import minechem.init.ModNetworking;
import minechem.integration.jei.PacketSynthesisRecipeTransfer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SynthesisTransferHandler
implements IRecipeTransferHandler<ContainerSynthesis> {
    private final StackHelper stackHelper = Internal.getStackHelper();
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final SynthesisRecipeTransferInfo transferHelper;

    public SynthesisTransferHandler(IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
        this.transferHelper = new SynthesisRecipeTransferInfo();
    }

    public Class<ContainerSynthesis> getContainerClass() {
        return ContainerSynthesis.class;
    }

    public IRecipeTransferError transferRecipe(ContainerSynthesis container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        ItemStack stack;
        if (!ServerInfo.isJeiOnServer()) {
            String tooltipMessage = Translator.translateToLocal((String)"jei.tooltip.error.recipe.transfer.no.server");
            return this.handlerHelper.createUserErrorWithTooltip(tooltipMessage);
        }
        if (!this.transferHelper.canHandle(container)) {
            return this.handlerHelper.createInternalError();
        }
        HashMap<Integer, Slot> inventorySlots = new HashMap<Integer, Slot>();
        for (Object slot : this.transferHelper.getInventorySlots(container)) {
            inventorySlots.put(((Slot)slot).field_75222_d, (Slot)slot);
        }
        HashMap<Integer, Slot> machineInputSlots = new HashMap<Integer, Slot>();
        for (Object slot : this.transferHelper.getRecipeSlots(container)) {
            machineInputSlots.put(((Slot)slot).field_75222_d, (Slot)slot);
        }
        HashMap<Integer, Slot> fakeCraftingSlots = new HashMap<Integer, Slot>();
        for (Slot slot : this.transferHelper.getGhostSlots(container)) {
            fakeCraftingSlots.put(slot.field_75222_d, slot);
        }
        int inputCount = 0;
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        for (IGuiIngredient ingredient : itemStackGroup.getGuiIngredients().values()) {
            if (!ingredient.isInput() || ingredient.getAllIngredients().isEmpty()) continue;
            ++inputCount;
        }
        if (inputCount > machineInputSlots.size()) {
            Log.get().error("Recipe Transfer helper {} does not work for container {}", ((Object)((Object)this.transferHelper)).getClass(), container.getClass());
            return this.handlerHelper.createInternalError();
        }
        HashMap<Integer, ItemStack> availableItemStacks = new HashMap<Integer, ItemStack>();
        int filledMachineInputCount = 0;
        int emptySlotCount = 0;
        for (Slot slot : machineInputSlots.values()) {
            stack = slot.func_75211_c();
            if (stack.func_190926_b()) continue;
            if (!slot.func_82869_a(player)) {
                Log.get().error("Recipe Transfer helper {} does not work for container {}. Player can't move item out of Crafting Slot number {}", ((Object)((Object)this.transferHelper)).getClass(), container.getClass(), (Object)slot.field_75222_d);
                return this.handlerHelper.createInternalError();
            }
            ++filledMachineInputCount;
            availableItemStacks.put(slot.field_75222_d, stack.func_77946_l());
        }
        for (Slot slot : inventorySlots.values()) {
            stack = slot.func_75211_c();
            if (!stack.func_190926_b()) {
                availableItemStacks.put(slot.field_75222_d, stack.func_77946_l());
                continue;
            }
            ++emptySlotCount;
        }
        if (filledMachineInputCount - inputCount > emptySlotCount) {
            String message = Translator.translateToLocal((String)"jei.tooltip.error.recipe.transfer.inventory.full");
            return this.handlerHelper.createUserErrorWithTooltip(message);
        }
        StackHelper.MatchingItemsResult matchingItemsResult = this.stackHelper.getMatchingItems(availableItemStacks, itemStackGroup.getGuiIngredients());
        if (matchingItemsResult.missingItems.size() > 0) {
            String message = Translator.translateToLocal((String)"jei.tooltip.error.recipe.transfer.missing");
            return this.handlerHelper.createUserErrorForSlots(message, (Collection)matchingItemsResult.missingItems);
        }
        ArrayList<Integer> machineInputSlotIndexes = new ArrayList<Integer>(machineInputSlots.keySet());
        Collections.sort(machineInputSlotIndexes);
        ArrayList<Integer> inventorySlotIndexes = new ArrayList<Integer>(inventorySlots.keySet());
        Collections.sort(inventorySlotIndexes);
        for (Map.Entry entry : matchingItemsResult.matchingItems.entrySet()) {
            int craftNumber = (Integer)entry.getKey();
            int slotNumber = (Integer)machineInputSlotIndexes.get(craftNumber);
            if (slotNumber >= 0 && slotNumber < container.field_75151_b.size()) continue;
            Log.get().error("Recipes Transfer Helper {} references slot {} outside of the inventory's size {}", ((Object)((Object)this.transferHelper)).getClass(), (Object)slotNumber, (Object)container.field_75151_b.size());
            return this.handlerHelper.createInternalError();
        }
        if (doTransfer) {
            PacketSynthesisRecipeTransfer packet = new PacketSynthesisRecipeTransfer(matchingItemsResult.matchingItems, machineInputSlotIndexes, inventorySlotIndexes, true, false);
            ModNetworking.INSTANCE.sendToServer((IMessage)packet);
        }
        return null;
    }

    public static class SynthesisRecipeTransferInfo
    extends BasicRecipeTransferInfo<ContainerSynthesis> {
        public SynthesisRecipeTransferInfo() {
            super(ContainerSynthesis.class, "minechem.synthesis", 12, 18, 30, 36);
        }

        public boolean canHandle(ContainerSynthesis container) {
            return true;
        }

        public List<Slot> getGhostSlots(ContainerSynthesis container) {
            ArrayList<Slot> slots = new ArrayList<Slot>();
            for (int i = 1; i < 10; ++i) {
                Slot slot = container.func_75139_a(i);
                slots.add(slot);
            }
            return slots;
        }
    }
}

