/*
 * Decompiled with CFR 0.152.
 */
package minechem.inventory;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;

public class InventoryBounded
implements IInventory {
    private final IInventory _inv;
    private final int[] _slots;

    public InventoryBounded(IInventory inv, int[] slots) {
        if (inv == null) {
            throw new IllegalArgumentException("inv: must not be null");
        }
        if (slots == null) {
            throw new IllegalArgumentException("slots: must not be null");
        }
        for (int i = 0; i < slots.length; ++i) {
            if (i >= 0 && i < inv.func_70302_i_()) continue;
            throw new IllegalArgumentException("slot: out of bounds");
        }
        this._inv = inv;
        this._slots = slots;
    }

    public NonNullList<ItemStack> copyInventoryToArray() {
        NonNullList itemstacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            ItemStack itemstack = this.func_70301_a(slot);
            if (!itemstack.func_190926_b()) {
                itemstacks.set(slot, (Object)itemstack.func_77946_l());
                continue;
            }
            itemstacks.set(slot, (Object)ItemStack.field_190927_a);
        }
        return itemstacks;
    }

    public NonNullList<ItemStack> copyInventoryToList() {
        NonNullList itemstacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (this.func_70301_a(slot).func_190926_b()) continue;
            itemstacks.set(slot, (Object)this.func_70301_a(slot).func_77946_l());
        }
        return itemstacks;
    }

    public void setInventoryStacks(NonNullList<ItemStack> itemstacks) {
        for (int slot = 0; slot < itemstacks.size(); ++slot) {
            this.func_70299_a(slot, (ItemStack)itemstacks.get(slot));
        }
    }

    public int func_70302_i_() {
        return this._slots.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this._inv.func_70301_a(this._slots[slot]);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this._inv.func_70298_a(this._slots[slot], amount);
    }

    @Nullable
    public ItemStack func_70304_b(int i) {
        return this._inv.func_70304_b(this._slots[i]);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this._inv.func_70299_a(this._slots[slot], stack);
    }

    public String func_70005_c_() {
        return this._inv.func_70005_c_();
    }

    public int func_70297_j_() {
        return this._inv.func_70297_j_();
    }

    public void func_70296_d() {
        this._inv.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this._inv.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        this._inv.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this._inv.func_174886_c(player);
    }

    public boolean func_145818_k_() {
        return this._inv.func_145818_k_();
    }

    public ITextComponent func_145748_c_() {
        return this._inv.func_145748_c_();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this._inv.func_94041_b(this._slots[i], itemstack);
    }

    public int func_174887_a_(int i) {
        return this._inv.func_174887_a_(i);
    }

    public void func_174885_b(int i, int i1) {
        this._inv.func_174885_b(i, i1);
    }

    public int func_174890_g() {
        return this._inv.func_174890_g();
    }

    public void func_174888_l() {
        this._inv.func_174888_l();
    }

    public boolean func_191420_l() {
        return this._inv.func_191420_l();
    }
}

