/*
 * Decompiled with CFR 0.152.
 */
package minechem.item;

import java.util.List;
import javax.annotation.Nullable;
import minechem.Minechem;
import minechem.init.ModCreativeTab;
import minechem.item.ItemBase;
import minechem.utils.MinechemUtil;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemChemistJournal
extends ItemBase {
    public static final String ITEMS_TAG_NAME = "discoveredItems";
    private static final String ACTIVE_ITEMSTACK_TAG = "activeItemStack";
    private static final String JOURNAL_OWNER_TAG = "owner";

    public ItemChemistJournal() {
        this.func_77655_b("chemist_journal");
        this.setRegistryName("minechem:chemist_journal");
        this.func_77637_a(ModCreativeTab.CREATIVE_TAB_ITEMS);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            player.openGui((Object)Minechem.INSTANCE, 1, world, player.field_70176_ah, player.field_70162_ai, player.field_70162_ai);
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
            }
            tagCompound.func_74778_a(JOURNAL_OWNER_TAG, player.func_145748_c_().func_150254_d());
            stack.func_77982_d(tagCompound);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        NBTTagCompound stackTag = stack.func_77978_p();
        if (stackTag != null) {
            NBTTagCompound activeTag = (NBTTagCompound)stackTag.func_74781_a(ACTIVE_ITEMSTACK_TAG);
            if (activeTag != null) {
                ItemStack activeItemStack = new ItemStack(activeTag);
                list.add(MinechemUtil.getLocalString("gui.journal.active") + ": " + activeItemStack.func_82833_r());
            }
            String owner = stackTag.func_74779_i(JOURNAL_OWNER_TAG);
            String ownerTag = MinechemUtil.getLocalString("minechem.owner.tag");
            if (ownerTag.isEmpty() || ownerTag.equals("minechem.owner.tag")) {
                list.add("Owner: " + owner);
            } else {
                list.add(ownerTag + ": " + owner);
            }
        }
    }

    public void setActiveStack(ItemStack itemstack, ItemStack journalStack) {
        NBTTagCompound journalTag = journalStack.func_77978_p();
        if (journalTag == null) {
            journalTag = new NBTTagCompound();
        }
        NBTTagCompound stackTag = itemstack.func_77955_b(new NBTTagCompound());
        journalTag.func_74782_a(ACTIVE_ITEMSTACK_TAG, (NBTBase)stackTag);
        journalStack.func_77982_d(journalTag);
    }

    public ItemStack getActiveStack(ItemStack journalStack) {
        NBTTagCompound stackTag;
        NBTTagCompound journalTag = journalStack.func_77978_p();
        if (journalTag != null && (stackTag = (NBTTagCompound)journalTag.func_74781_a(ACTIVE_ITEMSTACK_TAG)) != null) {
            return new ItemStack(stackTag);
        }
        return ItemStack.field_190927_a;
    }

    public List<ItemStack> getItemList(ItemStack journal) {
        NBTTagList taglist;
        NBTTagCompound tag = journal.func_77978_p();
        if (tag != null && (taglist = tag.func_150295_c(ITEMS_TAG_NAME, 10)) != null) {
            return MinechemUtil.readTagListToItemStackList(taglist);
        }
        return null;
    }

    public void addItemStackToJournal(ItemStack itemstack, ItemStack journal, World world) {
        NonNullList<ItemStack> itemArrayList;
        NBTTagList taglist;
        NBTTagCompound tagCompound = journal.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if ((taglist = tagCompound.func_150295_c(ITEMS_TAG_NAME, 10)) == null) {
            taglist = new NBTTagList();
        }
        if (!this.hasDiscovered(itemArrayList = MinechemUtil.readTagListToItemStackList(taglist), itemstack)) {
            taglist.func_74742_a((NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
            tagCompound.func_74782_a(ITEMS_TAG_NAME, (NBTBase)taglist);
            journal.func_77982_d(tagCompound);
        }
    }

    private boolean hasDiscovered(NonNullList<ItemStack> list, ItemStack itemstack) {
        for (ItemStack itemstack2 : list) {
            if (!itemstack.func_77969_a(itemstack2)) continue;
            return true;
        }
        return false;
    }
}

