/*
 * Decompiled with CFR 0.152.
 */
package minechem.item;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import minechem.block.tile.TileRadioactiveFluid;
import minechem.fluid.FluidElement;
import minechem.init.ModCreativeTab;
import minechem.init.ModFluids;
import minechem.init.ModItems;
import minechem.item.ItemBase;
import minechem.item.MinechemChemicalType;
import minechem.item.element.ElementEnum;
import minechem.item.molecule.MoleculeEnum;
import minechem.item.polytool.PolytoolHelper;
import minechem.radiation.RadiationEnum;
import minechem.utils.MinechemUtil;
import minechem.utils.RadiationUtil;
import minechem.utils.TickTimeUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.input.Keyboard;

public class ItemElement
extends ItemBase {
    public ItemElement() {
        this.func_77637_a(ModCreativeTab.CREATIVE_TAB_ELEMENTS);
        this.func_77655_b("item_element");
        this.setRegistryName("minechem:item_element");
        this.func_77627_a(true);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderer() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("minechem", "tube_empty"), "inventory"));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public static String getShortName(ItemStack itemstack) {
        int atomicNumber = itemstack.func_77952_i();
        return atomicNumber == 0 ? MinechemUtil.getLocalString("element.empty") : ElementEnum.getByID(atomicNumber).name();
    }

    public static String getLongName(ItemStack itemstack) {
        ElementEnum element;
        String longName;
        int atomicNumber = itemstack.func_77952_i();
        String string = longName = atomicNumber == 0 ? MinechemUtil.getLocalString("element.empty") : MinechemUtil.getLocalString(ElementEnum.getByID(atomicNumber).getUnlocalizedName(), true);
        if (longName.contains("Element.") && (element = ElementEnum.getByID(atomicNumber)) != null) {
            longName = element.getLongName();
        }
        return longName;
    }

    public static String getClassification(ItemStack itemstack) {
        int atomicNumber = itemstack.func_77952_i();
        return atomicNumber != 0 ? ElementEnum.getByID(atomicNumber).classification().descriptiveName() : MinechemUtil.getLocalString("element.empty");
    }

    public static String getRoomState(ItemStack itemstack) {
        int atomicNumber = itemstack.func_77952_i();
        return atomicNumber != 0 ? ElementEnum.getByID(atomicNumber).roomState().descriptiveName() : MinechemUtil.getLocalString("element.empty");
    }

    public static void attackEntityWithRadiationDamage(ItemStack itemstack, int damage, Entity entity) {
        entity.func_70097_a(DamageSource.field_76377_j, (float)damage);
    }

    public String func_77667_c(ItemStack itemStack) {
        return "minechem.itemElement." + ItemElement.getShortName(itemStack);
    }

    public String func_77653_i(ItemStack itemStack) {
        return ItemElement.getLongName(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<String> list, ITooltipFlag flagIn) {
        if (itemstack.func_77952_i() == 0) {
            return;
        }
        list.add("\u00a79" + ItemElement.getShortName(itemstack) + " (" + itemstack.func_77952_i() + ")");
        RadiationEnum radioactivity = RadiationUtil.getRadioactivity(itemstack);
        String radioactivityColor = radioactivity.getColour();
        String radioactiveName = MinechemUtil.getLocalString("element.property." + radioactivity.name(), true);
        String timeLeft = "";
        if (RadiationUtil.getRadioactivity(itemstack) != RadiationEnum.stable && itemstack.func_77978_p() != null) {
            long worldTime = world.func_82737_E();
            long ticks = RadiationUtil.getRadioactivity(itemstack).getLife() - (worldTime - itemstack.func_77978_p().func_74763_f("decayStart"));
            timeLeft = TickTimeUtil.getTimeFromTicks(ticks);
        }
        list.add(radioactivityColor + radioactiveName + (timeLeft.equals("") ? "" : " (" + timeLeft + ")"));
        list.add(ItemElement.getClassification(itemstack));
        list.add(ItemElement.getRoomState(itemstack));
        if (PolytoolHelper.getTypeFromElement(MinechemUtil.getElement(itemstack), 1.0f) != null) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                String polytoolDesc = PolytoolHelper.getTypeFromElement(MinechemUtil.getElement(itemstack), 1.0f).getDescription();
                String localizedDesc = I18n.func_135052_a((String)("polytool.description." + ItemElement.getShortName(itemstack)), (Object[])new Object[0]);
                if (!I18n.func_188566_a((String)("polytool.description." + ItemElement.getShortName(itemstack)))) {
                    localizedDesc = polytoolDesc;
                }
                list.add(TextFormatting.AQUA + localizedDesc);
            } else {
                list.add(TextFormatting.DARK_GREEN + MinechemUtil.getLocalString("polytool.information"));
            }
        }
    }

    public int func_77647_b(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this, 1, 0));
            for (int i = 1; i <= ElementEnum.heaviestMass; ++i) {
                if (ElementEnum.getByID(i) == null) continue;
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public static ItemStack createStackOf(ElementEnum element, int amount) {
        return new ItemStack((Item)ModItems.element, amount, element.atomicNumber());
    }

    public static RadiationUtil getRadiationInfo(ItemStack element, World world) {
        RadiationEnum radioactivity = RadiationUtil.getRadioactivity(element);
        if (radioactivity == RadiationEnum.stable) {
            return new RadiationUtil(element, radioactivity);
        }
        NBTTagCompound stackTag = element.func_77978_p();
        if (stackTag == null) {
            return ItemElement.initiateRadioactivity(element, world);
        }
        int dimensionID = stackTag.func_74762_e("dimensionID");
        long lastUpdate = stackTag.func_74763_f("lastUpdate");
        long decayStart = stackTag.func_74763_f("decayStart");
        RadiationUtil info = new RadiationUtil(element, decayStart, lastUpdate, dimensionID, radioactivity);
        return info;
    }

    public static RadiationUtil initiateRadioactivity(ItemStack element, World world) {
        RadiationEnum radioactivity = RadiationUtil.getRadioactivity(element);
        int dimensionID = world.field_73011_w.getDimension();
        long lastUpdate = world.func_82737_E();
        RadiationUtil info = new RadiationUtil(element, lastUpdate, lastUpdate, dimensionID, radioactivity);
        RadiationUtil.setRadiationInfo(info, element);
        return info;
    }

    public static RadiationUtil decay(ItemStack element, World world) {
        int atomicMass = element.func_77952_i();
        element.func_77964_b(atomicMass - 1);
        return ItemElement.initiateRadioactivity(element, world);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity te = world.func_175625_s(pos);
        boolean result = !world.field_72995_K;
        ItemStack stack = player.func_184586_b(hand);
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing) && !player.func_70093_af() && !(te instanceof IInventory)) {
            IFluidHandler cap = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
            if (stack.func_77952_i() != 0) {
                int filled = 0;
                FluidElement fluid = ModFluids.FLUID_ELEMENTS.get(MinechemUtil.getElement(stack));
                if (fluid == null) {
                    return super.onItemUseFirst(player, world, pos, facing, hitX, hitY, hitZ, hand);
                }
                filled = cap.fill(new FluidStack((Fluid)fluid, 125), false);
                if (filled > 0) {
                    if (result) {
                        cap.fill(new FluidStack((Fluid)ModFluids.FLUID_ELEMENTS.get(MinechemUtil.getElement(stack)), 125), true);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        MinechemUtil.incPlayerInventory(stack, -1, player, new ItemStack((Item)ModItems.element, 1, 0));
                    }
                    return result || stack.func_190916_E() <= 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
                }
            } else {
                FluidStack drained = null;
                Fluid fluid = MinechemUtil.getFluid(te);
                if (fluid != null) {
                    ElementEnum element = MinechemUtil.getElement(fluid);
                    if (element != null) {
                        drained = cap.drain(new FluidStack(fluid, 125), false);
                        if (drained != null && drained.amount > 0) {
                            if (result) {
                                cap.drain(new FluidStack(fluid, 125), true);
                            }
                            if (!player.field_71075_bZ.field_75098_d) {
                                MinechemUtil.incPlayerInventory(stack, -1, player, new ItemStack((Item)ModItems.element, 1, element.atomicNumber()));
                            }
                            return result ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
                        }
                    } else {
                        MoleculeEnum molecule = MinechemUtil.getMolecule(fluid);
                        if (fluid == FluidRegistry.WATER) {
                            molecule = MoleculeEnum.water;
                        }
                        if (molecule != null && (drained = cap.drain(new FluidStack(fluid, 125), false)) != null && drained.amount > 0) {
                            if (result) {
                                cap.drain(new FluidStack(fluid, 125), true);
                            }
                            if (!player.field_71075_bZ.field_75098_d) {
                                MinechemUtil.incPlayerInventory(stack, -1, player, new ItemStack((Item)ModItems.molecule, 1, molecule.id()));
                            }
                            return result ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
                        }
                    }
                }
            }
            return result ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        return super.onItemUseFirst(player, world, pos, facing, hitX, hitY, hitZ, hand);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        boolean flag = itemStack.func_77952_i() == 0;
        RayTraceResult rayTrace = this.func_77621_a(world, player, flag);
        if (rayTrace == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
        }
        if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            int blockX = rayTrace.func_178782_a().func_177958_n();
            int blockY = rayTrace.func_178782_a().func_177956_o();
            int blockZ = rayTrace.func_178782_a().func_177952_p();
            Block block = world.func_180495_p(rayTrace.func_178782_a()).func_177230_c();
            if (flag) {
                ItemStack stack;
                MinechemChemicalType chemical = MinechemUtil.getChemical(block);
                if (chemical != null && MinechemUtil.canDrain(world, block, blockX, blockY, blockZ) && !(stack = MinechemUtil.createItemStack(chemical, 1)).func_190926_b()) {
                    stack.func_190920_e(8);
                    TileEntity tile = world.func_175625_s(rayTrace.func_178782_a());
                    if (tile instanceof TileRadioactiveFluid && ((TileRadioactiveFluid)tile).info != null) {
                        RadiationUtil.setRadiationInfo(((TileRadioactiveFluid)tile).info, stack);
                    }
                    world.func_175698_g(rayTrace.func_178782_a());
                    world.func_175713_t(rayTrace.func_178782_a());
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)this.fillTube(itemStack, player, stack));
                }
            } else {
                EnumFacing dir = rayTrace.field_178784_b;
                blockX += dir.func_82601_c();
                blockY += dir.func_96559_d();
                blockZ += dir.func_82599_e();
                if (!player.func_175151_a(rayTrace.func_178782_a(), rayTrace.field_178784_b, itemStack)) {
                    return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)this.emptyTube(itemStack, player, world, blockX, blockY, blockZ));
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
    }

    private ItemStack fillTube(ItemStack itemStack, EntityPlayer player, ItemStack block) {
        if (player.field_71075_bZ.field_75098_d) {
            return itemStack;
        }
        MinechemUtil.incPlayerInventory(itemStack, -8, player, block);
        return itemStack;
    }

    private ItemStack emptyTube(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (!world.func_175623_d(pos) && !world.func_180495_p(pos).func_185904_a().func_76220_a()) {
            IBlockState state = world.func_180495_p(pos);
            state.func_177230_c().func_180657_a(world, player, pos, state, null, ItemStack.field_190927_a);
            state.func_177230_c().func_180663_b(world, pos, state);
            world.func_175698_g(pos);
        }
        if (world.func_175623_d(pos)) {
            RadiationUtil radioactivity = ItemElement.getRadiationInfo(itemStack, world);
            long worldtime = world.func_82737_E();
            long leftTime = radioactivity.radioactivity.getLife() - (worldtime - radioactivity.decayStarted);
            Fluid fluid = ModFluids.FLUID_ELEMENTS.get(MinechemUtil.getElement(itemStack));
            if (fluid == null) {
                return itemStack;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                if (itemStack.func_190916_E() >= 8) {
                    itemStack.func_190918_g(8);
                } else {
                    int needs = 8 - itemStack.func_190916_E();
                    Set<ItemStack> otherItemsStacks = MinechemUtil.findItemStacks((IInventory)player.field_71071_by, itemStack.func_77973_b(), itemStack.func_77952_i());
                    otherItemsStacks.remove(itemStack);
                    int free = 0;
                    for (ItemStack stack : otherItemsStacks) {
                        free += stack.func_190916_E();
                    }
                    if (free < needs) {
                        return itemStack;
                    }
                    itemStack.func_190920_e(0);
                    for (ItemStack stack : otherItemsStacks) {
                        RadiationUtil anotherRadiation = ItemElement.getRadiationInfo(stack, world);
                        long anotherLeft = anotherRadiation.radioactivity.getLife() - (worldtime - anotherRadiation.decayStarted);
                        if (anotherLeft < leftTime) {
                            radioactivity = anotherRadiation;
                            leftTime = anotherLeft;
                        }
                        if (stack.func_190916_E() >= needs) {
                            stack.func_190918_g(needs);
                            needs = 0;
                        } else {
                            needs -= stack.func_190916_E();
                            stack.func_190920_e(0);
                        }
                        if (stack.func_190916_E() <= 0) {
                            MinechemUtil.removeStackInInventory((IInventory)player.field_71071_by, stack);
                        }
                        if (needs != 0) continue;
                        break;
                    }
                }
                ItemStack empties = MinechemUtil.addItemToInventory((IInventory)player.field_71071_by, new ItemStack((Item)ModItems.element, 8, 0));
                MinechemUtil.throwItemStack(world, empties, x, y, z);
            }
            Block block = ModFluids.FLUID_ELEMENT_BLOCKS.get(fluid);
            world.func_180501_a(pos, block.func_176203_a(0), 3);
            TileEntity tile = world.func_175625_s(pos);
            if (radioactivity.isRadioactive() && tile instanceof TileRadioactiveFluid) {
                ((TileRadioactiveFluid)tile).info = radioactivity;
            }
        }
        return itemStack;
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        super.func_77622_d(itemStack, world, player);
        if (RadiationUtil.getRadioactivity(itemStack) != RadiationEnum.stable && itemStack.func_77978_p() == null) {
            RadiationUtil.setRadiationInfo(new RadiationUtil(itemStack, world.func_82737_E(), world.func_82737_E(), world.field_73011_w.getDimension(), RadiationUtil.getRadioactivity(itemStack)), itemStack);
        }
    }
}

