/*
 * Decompiled with CFR 0.152.
 */
package minechem.item;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import minechem.block.tile.TileRadioactiveFluid;
import minechem.init.ModConfig;
import minechem.init.ModCreativeTab;
import minechem.init.ModFluids;
import minechem.init.ModItems;
import minechem.init.ModRendering;
import minechem.item.ItemBase;
import minechem.item.ItemElement;
import minechem.item.MatterState;
import minechem.item.molecule.MoleculeEnum;
import minechem.potion.PharmacologyEffect;
import minechem.potion.PharmacologyEffectRegistry;
import minechem.radiation.RadiationEnum;
import minechem.utils.MinechemUtil;
import minechem.utils.RadiationUtil;
import minechem.utils.TickTimeUtil;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.input.Keyboard;

public class ItemMolecule
extends ItemBase {
    public ItemMolecule() {
        this.func_77637_a(ModCreativeTab.CREATIVE_TAB_ELEMENTS);
        this.func_77627_a(true);
        this.func_77655_b("molecule");
        this.setRegistryName("minechem:molecule");
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderer() {
        for (int i = 0; i < MoleculeEnum.molecules.values().size(); ++i) {
            MoleculeEnum molecule = MoleculeEnum.molecules.get(i);
            if (molecule == null) continue;
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)molecule.id(), (ModelResourceLocation)ModRendering.ITEM_MOLECULE_LOC);
        }
    }

    public IItemColor getColorHandler() {
        return (stack, tintIndex) -> {
            MoleculeEnum molecule = MinechemUtil.getMolecule(stack);
            if (molecule == null) {
                return -1;
            }
            int color = -1;
            if (tintIndex == 1) {
                color = molecule.getColor1();
            }
            if (tintIndex == 2) {
                color = molecule.getColor2();
            }
            return color;
        };
    }

    public String func_77653_i(ItemStack itemStack) {
        return MinechemUtil.getLocalString(MinechemUtil.getMolecule(itemStack).getUnlocalizedName(), true);
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return this.func_77658_a() + "." + MinechemUtil.getMolecule(par1ItemStack).name();
    }

    public String getFormulaWithSubscript(ItemStack itemstack) {
        String formula = MinechemUtil.getMolecule(itemstack).getFormula();
        return MinechemUtil.subscriptNumbers(formula);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<String> list, ITooltipFlag flagIn) {
        list.add("\u00a79" + this.getFormulaWithSubscript(itemstack));
        RadiationEnum radioactivity = RadiationUtil.getRadioactivity(itemstack);
        String radioactivityColor = radioactivity.getColour();
        String radioactiveName = MinechemUtil.getLocalString("element.property." + radioactivity.name(), true);
        String timeLeft = "";
        if (RadiationUtil.getRadioactivity(itemstack) != RadiationEnum.stable && itemstack.func_77978_p() != null) {
            long worldTime = world.func_82737_E();
            timeLeft = TickTimeUtil.getTimeFromTicks(RadiationUtil.getRadioactivity(itemstack).getLife() - (worldTime - itemstack.func_77978_p().func_74763_f("decayStart")));
        }
        list.add(radioactivityColor + radioactiveName + (timeLeft.equals("") ? "" : " (" + timeLeft + ")"));
        list.add(ItemMolecule.getRoomState(itemstack));
        MoleculeEnum molecule = MoleculeEnum.getById(itemstack.func_77952_i());
        if (PharmacologyEffectRegistry.hasEffect(molecule) && ModConfig.displayMoleculeEffects) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                for (PharmacologyEffect effect : PharmacologyEffectRegistry.getEffects(molecule)) {
                    if (effect.toString().isEmpty()) continue;
                    list.add(effect.getColour() + effect.toString());
                }
            } else {
                list.add(TextFormatting.DARK_GREEN + MinechemUtil.getLocalString("effect.information", true));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (MoleculeEnum molecule : MoleculeEnum.molecules.values()) {
                if (molecule == null) continue;
                list.add((Object)new ItemStack((Item)this, 1, molecule.id()));
            }
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EnumHand hand) {
        boolean result;
        TileEntity te = world.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        boolean bl = result = !world.field_72995_K;
        if (te != null && te instanceof IFluidHandler && !player.func_70093_af() && !(te instanceof IInventory)) {
            int filled = 0;
            FluidStack fluidStack = new FluidStack(FluidRegistry.WATER, 125);
            if (MinechemUtil.getMolecule(stack) != MoleculeEnum.water) {
                Fluid fluid = ModFluids.FLUID_MOLECULES.get(MinechemUtil.getMolecule(stack));
                if (fluid == null) {
                    return super.onItemUseFirst(player, world, pos, facing, hitX, hitY, hitZ, hand);
                }
                fluidStack = new FluidStack(fluid, 125);
            }
            if ((filled = ((IFluidHandler)te).fill(fluidStack, false)) > 0) {
                if (result) {
                    ((IFluidHandler)te).fill(fluidStack, true);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    MinechemUtil.incPlayerInventory(stack, -1, player, new ItemStack((Item)ModItems.element, 1, 0));
                }
                return result || stack.func_190916_E() <= 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
            return result ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        return super.onItemUseFirst(player, world, pos, facing, hitX, hitY, hitZ, hand);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        MatterState matterState = MoleculeEnum.molecules.get(stack.func_77952_i()).roomState();
        return matterState == MatterState.LIQUID ? EnumAction.DRINK : EnumAction.NONE;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 16;
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer) || MoleculeEnum.molecules.get(itemStack.func_77952_i()).roomState() != MatterState.LIQUID) {
            return itemStack;
        }
        EntityPlayer entityPlayer = (EntityPlayer)entity;
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
        if (world.field_72995_K) {
            // empty if block
        }
        MoleculeEnum molecule = MinechemUtil.getMolecule(itemStack);
        PharmacologyEffectRegistry.applyEffect(molecule, (EntityLivingBase)entityPlayer);
        world.func_184133_a(entityPlayer, entityPlayer.func_180425_c(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        return itemStack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        RayTraceResult rayTrace = this.func_77621_a(world, player, false);
        if (rayTrace == null || player.func_70093_af()) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
        }
        if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && ModConfig.vialPlacing) {
            int blockX = rayTrace.func_178782_a().func_177958_n();
            int blockY = rayTrace.func_178782_a().func_177956_o();
            int blockZ = rayTrace.func_178782_a().func_177952_p();
            EnumFacing dir = rayTrace.field_178784_b;
            blockX += dir.func_82601_c();
            blockY += dir.func_96559_d();
            blockZ += dir.func_82599_e();
            if (!player.func_175151_a(rayTrace.func_178782_a(), rayTrace.field_178784_b, itemStack)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)this.emptyTube(itemStack, player, world, blockX, blockY, blockZ));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
    }

    private ItemStack emptyTube(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (!world.func_175623_d(pos) && !world.func_180495_p(pos).func_185904_a().func_76220_a()) {
            IBlockState state = world.func_180495_p(pos);
            state.func_177230_c().func_180657_a(world, player, pos, state, null, ItemStack.field_190927_a);
            state.func_177230_c().func_180663_b(world, pos, state);
            world.func_175698_g(pos);
        }
        if (world.func_175623_d(pos)) {
            RadiationUtil radioactivity = ItemElement.getRadiationInfo(itemStack, world);
            long worldtime = world.func_82737_E();
            long leftTime = radioactivity.radioactivity.getLife() - (worldtime - radioactivity.decayStarted);
            MoleculeEnum molecule = MinechemUtil.getMolecule(itemStack);
            Fluid fluid = ModFluids.FLUID_MOLECULES.get(molecule);
            if (fluid == null) {
                return itemStack;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                if (itemStack.func_190916_E() >= 8) {
                    itemStack.func_190918_g(8);
                } else {
                    int needs = 8 - itemStack.func_190916_E();
                    Set<ItemStack> otherItemsStacks = MinechemUtil.findItemStacks((IInventory)player.field_71071_by, itemStack.func_77973_b(), itemStack.func_77952_i());
                    otherItemsStacks.remove(itemStack);
                    int free = 0;
                    for (ItemStack stack : otherItemsStacks) {
                        free += stack.func_190916_E();
                    }
                    if (free < needs) {
                        return itemStack;
                    }
                    itemStack.func_190920_e(0);
                    for (ItemStack stack : otherItemsStacks) {
                        RadiationUtil anotherRadiation = ItemElement.getRadiationInfo(stack, world);
                        long anotherLeft = anotherRadiation.radioactivity.getLife() - (worldtime - anotherRadiation.decayStarted);
                        if (anotherLeft < leftTime) {
                            radioactivity = anotherRadiation;
                            leftTime = anotherLeft;
                        }
                        if (stack.func_190916_E() >= needs) {
                            stack.func_190918_g(needs);
                            needs = 0;
                        } else {
                            needs -= stack.func_190916_E();
                            stack.func_190920_e(0);
                        }
                        if (stack.func_190916_E() <= 0) {
                            MinechemUtil.removeStackInInventory((IInventory)player.field_71071_by, stack);
                        }
                        if (needs != 0) continue;
                        break;
                    }
                }
                ItemStack empties = MinechemUtil.addItemToInventory((IInventory)player.field_71071_by, new ItemStack((Item)ModItems.element, 8, 0));
                MinechemUtil.throwItemStack(world, empties, x, y, z);
            }
            BlockDynamicLiquid block = Blocks.field_150358_i;
            if (MinechemUtil.getMolecule(itemStack) != MoleculeEnum.water) {
                block = ModFluids.FLUID_MOLECULE_BLOCKS.get(fluid);
            }
            world.func_180501_a(pos, block.func_176203_a(0), 3);
            TileEntity tile = world.func_175625_s(pos);
            if (radioactivity.isRadioactive() && tile instanceof TileRadioactiveFluid) {
                ((TileRadioactiveFluid)tile).info = radioactivity;
            }
        }
        return itemStack;
    }

    public static String getRoomState(ItemStack itemstack) {
        int id = itemstack.func_77952_i();
        return MoleculeEnum.molecules.get(id) == null ? "null" : MoleculeEnum.molecules.get(id).roomState().descriptiveName();
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        super.func_77622_d(itemStack, world, player);
        if (RadiationUtil.getRadioactivity(itemStack) != RadiationEnum.stable && itemStack.func_77978_p() == null) {
            RadiationUtil.setRadiationInfo(new RadiationUtil(itemStack, world.func_82737_E(), world.func_82737_E(), world.field_73011_w.getDimension(), RadiationUtil.getRadioactivity(itemStack)), itemStack);
        }
    }
}

