/*
 * Decompiled with CFR 0.152.
 */
package minechem.item;

import java.util.List;
import javax.annotation.Nullable;
import minechem.api.IRadiationShield;
import minechem.init.ModCreativeTab;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRadiationShieldArmor
extends ItemArmor
implements IRadiationShield {
    private float radiationShieldFactor;
    private String textureFile;

    public ItemRadiationShieldArmor(int id, int part, float radiationShieldFactor, String texture) {
        super(ItemArmor.ArmorMaterial.CHAIN, 2, EntityEquipmentSlot.values()[part]);
        this.radiationShieldFactor = radiationShieldFactor;
        this.func_77655_b("itemArmorRadiationShield");
        this.func_77637_a(ModCreativeTab.CREATIVE_TAB_ITEMS);
        this.textureFile = texture;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<String> list, ITooltipFlag flagIn) {
        int percentile = (int)(this.radiationShieldFactor * 100.0f);
        String info = String.format("%d%% Radiation Shielding", percentile);
        list.add(info);
    }

    @Override
    public float getRadiationReductionFactor(int baseDamage, ItemStack itemstack, EntityPlayer player) {
        itemstack.func_77972_a(baseDamage / 4, (EntityLivingBase)player);
        return this.radiationShieldFactor;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "textures/model/hazmatarmor.png";
    }
}

