/*
 * Decompiled with CFR 0.152.
 */
package minechem.item;

import minechem.item.IDescriptiveName;
import net.minecraft.client.resources.I18n;

public enum MatterState implements IDescriptiveName
{
    LIQUID("liquid", false, 1000, 8),
    SOLID("solid", false, 1200, 1),
    GAS("gaseous", true, 400, 8);

    private final boolean isGas;
    private final int viscosity;
    private final String descriptiveName;
    private final int quanta;

    private MatterState(String descriptiveName, boolean isGas, int viscosity, int quanta) {
        this.isGas = isGas;
        this.viscosity = viscosity;
        this.descriptiveName = descriptiveName;
        this.quanta = quanta;
    }

    public boolean isGas() {
        return this.isGas;
    }

    public int getViscosity() {
        return this.viscosity;
    }

    public int getQuanta() {
        return this.quanta;
    }

    public String stateName() {
        return this.descriptiveName;
    }

    @Override
    public String descriptiveName() {
        String localizedName = I18n.func_135052_a((String)("element.classification." + this.descriptiveName), (Object[])new Object[0]);
        if (!localizedName.isEmpty() || !localizedName.equals("element.classification." + this.descriptiveName)) {
            return localizedName;
        }
        return this.descriptiveName;
    }
}

