/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.molecule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import minechem.init.ModItems;
import minechem.item.MatterState;
import minechem.item.MinechemChemicalType;
import minechem.item.element.Element;
import minechem.item.element.ElementEnum;
import minechem.item.molecule.Molecule;
import minechem.potion.PotionChemical;
import minechem.radiation.RadiationEnum;
import minechem.recipe.RecipeDecomposer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MoleculeEnum
extends MinechemChemicalType {
    public static Map<Integer, MoleculeEnum> molecules = new LinkedHashMap<Integer, MoleculeEnum>();
    public static Map<String, MoleculeEnum> nameToMolecules = new HashMap<String, MoleculeEnum>();
    private static Map<MoleculeEnum, Integer> fuelBurnTimes = new HashMap<MoleculeEnum, Integer>();
    public static int baseMolecules = 172;
    public static final MoleculeEnum cellulose = MoleculeEnum.addMolecule("cellulose", 0, 0.0f, 1.0f, 0.0f, 0.0f, 0.25f, 0.0f, MatterState.SOLID, 65, new Element(ElementEnum.C, 6), new Element(ElementEnum.H, 10), new Element(ElementEnum.O, 5));
    public static final MoleculeEnum water = MoleculeEnum.addMolecule("water", 1, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, MatterState.LIQUID, new Element(ElementEnum.H, 2), new Element(ElementEnum.O));
    public static final MoleculeEnum carbonDioxide = MoleculeEnum.addMolecule("carbonDioxide", 2, 0.5f, 0.5f, 0.5f, 0.25f, 0.25f, 0.25f, MatterState.GAS, new Element(ElementEnum.C), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum nitrogenDioxide = MoleculeEnum.addMolecule("nitrogenDioxide", 3, 1.0f, 0.65f, 0.0f, 0.5f, 0.1412f, 0.1843f, MatterState.GAS, new Element(ElementEnum.N), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum toluene = MoleculeEnum.addMolecule("toluene", 4, 1.0f, 1.0f, 1.0f, 0.8f, 0.8f, 0.8f, MatterState.LIQUID, 2200, new Element(ElementEnum.C, 7), new Element(ElementEnum.H, 8));
    public static final MoleculeEnum potassiumNitrate = MoleculeEnum.addMolecule("potassiumNitrate", 5, 0.9f, 0.9f, 0.9f, 0.8f, 0.8f, 0.8f, MatterState.SOLID, new Element(ElementEnum.K), new Element(ElementEnum.N), new Element(ElementEnum.O, 3));
    public static final MoleculeEnum tnt = MoleculeEnum.addMolecule("tnt", 6, 1.0f, 1.0f, 0.0f, 1.0f, 0.65f, 0.0f, MatterState.SOLID, 4000, new Element(ElementEnum.C, 6), new Element(ElementEnum.H, 2), new Molecule(nitrogenDioxide, 3), new Molecule(toluene));
    public static final MoleculeEnum siliconDioxide = MoleculeEnum.addMolecule("siliconDioxide", 7, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, MatterState.SOLID, new Element(ElementEnum.Si), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum calcicPyroxene = MoleculeEnum.addMolecule("calcicPyroxene", 8, MatterState.SOLID, new Element(ElementEnum.Ca, 1), new Element(ElementEnum.Cr, 1), new Element(ElementEnum.Si, 2), new Element(ElementEnum.O, 6));
    public static final MoleculeEnum pyrite = MoleculeEnum.addMolecule("pyrite", 9, MatterState.SOLID, new Element(ElementEnum.Fe), new Element(ElementEnum.S, 2));
    public static final MoleculeEnum nepheline = MoleculeEnum.addMolecule("nepheline", 10, MatterState.SOLID, new Element(ElementEnum.Al), new Element(ElementEnum.Si), new Element(ElementEnum.O, 4));
    public static final MoleculeEnum sulfate = MoleculeEnum.addMolecule("sulfate", 11, MatterState.SOLID, new Element(ElementEnum.S), new Element(ElementEnum.O, 4));
    public static final MoleculeEnum noselite = MoleculeEnum.addMolecule("noselite", 12, MatterState.SOLID, new Element(ElementEnum.Na, 8), new Molecule(nepheline, 6), new Molecule(sulfate));
    public static final MoleculeEnum sodalite = MoleculeEnum.addMolecule("sodalite", 13, MatterState.SOLID, new Element(ElementEnum.Na, 8), new Molecule(nepheline, 6), new Element(ElementEnum.Cl, 2));
    public static final MoleculeEnum nitrate = MoleculeEnum.addMolecule("nitrate", 14, MatterState.SOLID, new Element(ElementEnum.N), new Element(ElementEnum.O, 3));
    public static final MoleculeEnum carbonate = MoleculeEnum.addMolecule("carbonate", 15, MatterState.SOLID, new Element(ElementEnum.C), new Element(ElementEnum.O, 3));
    public static final MoleculeEnum cyanide = MoleculeEnum.addMolecule("cyanide", 16, MatterState.LIQUID, new Element(ElementEnum.K), new Element(ElementEnum.C), new Element(ElementEnum.N));
    public static final MoleculeEnum phosphate = MoleculeEnum.addMolecule("phosphate", 17, MatterState.SOLID, new Element(ElementEnum.P), new Element(ElementEnum.O, 4));
    public static final MoleculeEnum acetate = MoleculeEnum.addMolecule("acetate", 18, MatterState.SOLID, new Element(ElementEnum.C, 2), new Element(ElementEnum.H, 3), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum chromate = MoleculeEnum.addMolecule("chromate", 19, MatterState.SOLID, new Element(ElementEnum.Cr), new Element(ElementEnum.O, 4));
    public static final MoleculeEnum hydroxide = MoleculeEnum.addMolecule("hydroxide", 20, MatterState.LIQUID, new Element(ElementEnum.O), new Element(ElementEnum.H));
    public static final MoleculeEnum ammonium = MoleculeEnum.addMolecule("ammonium", 21, MatterState.LIQUID, new Element(ElementEnum.N), new Element(ElementEnum.H, 4));
    public static final MoleculeEnum hydronium = MoleculeEnum.addMolecule("hydronium", 22, MatterState.LIQUID, new Element(ElementEnum.H, 3), new Element(ElementEnum.O));
    public static final MoleculeEnum peroxide = MoleculeEnum.addMolecule("peroxide", 23, MatterState.LIQUID, new Element(ElementEnum.O, 2));
    public static final MoleculeEnum calciumOxide = MoleculeEnum.addMolecule("calciumOxide", 24, MatterState.SOLID, new Element(ElementEnum.Ca), new Element(ElementEnum.O));
    public static final MoleculeEnum calciumCarbonate = MoleculeEnum.addMolecule("calciumCarbonate", 25, MatterState.SOLID, new Element(ElementEnum.Ca), new Molecule(carbonate));
    public static final MoleculeEnum magnesiumCarbonate = MoleculeEnum.addMolecule("magnesiumCarbonate", 26, MatterState.SOLID, new Element(ElementEnum.Mg), new Molecule(carbonate));
    public static final MoleculeEnum lazurite = MoleculeEnum.addMolecule("lazurite", 27, MatterState.SOLID, new Element(ElementEnum.Na, 8), new Molecule(nepheline), new Molecule(sulfate));
    public static final MoleculeEnum isoprene = MoleculeEnum.addMolecule("isoprene", 28, MatterState.SOLID, 1800, new Element(ElementEnum.C, 5), new Element(ElementEnum.H, 8));
    public static final MoleculeEnum butene = MoleculeEnum.addMolecule("butene", 29, MatterState.GAS, 1600, new Element(ElementEnum.C, 4), new Element(ElementEnum.H, 8));
    public static final MoleculeEnum polyisobutylene = MoleculeEnum.addMolecule("polyisobutylene", 30, MatterState.LIQUID, new Molecule(butene, 16), new Molecule(isoprene));
    public static final MoleculeEnum malicAcid = MoleculeEnum.addMolecule("malicAcid", 31, MatterState.SOLID, new Element(ElementEnum.C, 4), new Element(ElementEnum.H, 6), new Element(ElementEnum.O, 5));
    public static final MoleculeEnum vinylChloride = MoleculeEnum.addMolecule("vinylChloride", 32, MatterState.GAS, new Element(ElementEnum.C, 2), new Element(ElementEnum.H, 3), new Element(ElementEnum.Cl));
    public static final MoleculeEnum polyvinylChloride = MoleculeEnum.addMolecule("polyvinylChloride", 33, MatterState.SOLID, new Molecule(vinylChloride, 64));
    public static final MoleculeEnum methamphetamine = MoleculeEnum.addMolecule("methamphetamine", 34, MatterState.SOLID, new Element(ElementEnum.C, 10), new Element(ElementEnum.H, 15), new Element(ElementEnum.N));
    public static final MoleculeEnum psilocybin = MoleculeEnum.addMolecule("psilocybin", 35, MatterState.SOLID, new Element(ElementEnum.C, 12), new Element(ElementEnum.H, 17), new Element(ElementEnum.N, 2), new Element(ElementEnum.O, 4), new Element(ElementEnum.P));
    public static final MoleculeEnum iron3oxide = MoleculeEnum.addMolecule("iron3oxide", 36, MatterState.SOLID, new Element(ElementEnum.Fe, 2), new Element(ElementEnum.O, 3));
    public static final MoleculeEnum strontiumNitrate = MoleculeEnum.addMolecule("strontiumNitrate", 37, MatterState.SOLID, new Element(ElementEnum.Sr), new Molecule(nitrate, 2));
    public static final MoleculeEnum magnetite = MoleculeEnum.addMolecule("magnetite", 38, MatterState.SOLID, new Element(ElementEnum.Fe, 3), new Element(ElementEnum.O, 4));
    public static final MoleculeEnum magnesiumOxide = MoleculeEnum.addMolecule("magnesiumOxide", 39, MatterState.SOLID, new Element(ElementEnum.Mg), new Element(ElementEnum.O));
    public static final MoleculeEnum cucurbitacin = MoleculeEnum.addMolecule("cucurbitacin", 40, MatterState.SOLID, new Element(ElementEnum.C, 30), new Element(ElementEnum.H, 42), new Element(ElementEnum.O, 7));
    public static final MoleculeEnum asparticAcid = MoleculeEnum.addMolecule("asparticAcid", 41, MatterState.SOLID, new Element(ElementEnum.C, 4), new Element(ElementEnum.H, 7), new Element(ElementEnum.N), new Element(ElementEnum.O, 4));
    public static final MoleculeEnum hydroxylapatite = MoleculeEnum.addMolecule("hydroxylapatite", 42, MatterState.SOLID, new Element(ElementEnum.Ca, 5), new Molecule(phosphate, 3), new Element(ElementEnum.O), new Element(ElementEnum.H));
    public static final MoleculeEnum alinine = MoleculeEnum.addMolecule("alinine", 43, MatterState.SOLID, new Element(ElementEnum.C, 3), new Element(ElementEnum.H, 7), new Element(ElementEnum.N), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum glycine = MoleculeEnum.addMolecule("glycine", 44, MatterState.SOLID, new Element(ElementEnum.C, 2), new Element(ElementEnum.H, 5), new Element(ElementEnum.N), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum serine = MoleculeEnum.addMolecule("serine", 45, MatterState.SOLID, new Element(ElementEnum.C, 3), new Element(ElementEnum.H, 7), new Molecule(nitrate));
    public static final MoleculeEnum mescaline = MoleculeEnum.addMolecule("mescaline", 46, MatterState.SOLID, new Element(ElementEnum.C, 11), new Element(ElementEnum.H, 17), new Molecule(nitrate));
    public static final MoleculeEnum methyl = MoleculeEnum.addMolecule("methyl", 47, MatterState.LIQUID, new Element(ElementEnum.C), new Element(ElementEnum.H, 3));
    public static final MoleculeEnum methylene = MoleculeEnum.addMolecule("methylene", 48, MatterState.LIQUID, new Element(ElementEnum.C), new Element(ElementEnum.H, 2));
    public static final MoleculeEnum memethacrylate = MoleculeEnum.addMolecule("memethacrylate", 49, MatterState.LIQUID, 5700, new Molecule(methyl, 3), new Element(ElementEnum.C, 2), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum pmma = MoleculeEnum.addMolecule("pmma", 50, MatterState.SOLID, new Molecule(memethacrylate, 3));
    public static final MoleculeEnum redPigment = MoleculeEnum.addMolecule("redPigment", 51, 1.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, MatterState.SOLID, new Element(ElementEnum.Co), new Molecule(nitrate, 2));
    public static final MoleculeEnum orangePigment = MoleculeEnum.addMolecule("orangePigment", 52, MatterState.SOLID, new Element(ElementEnum.K, 2), new Element(ElementEnum.Cr, 2), new Element(ElementEnum.O, 7));
    public static final MoleculeEnum yellowPigment = MoleculeEnum.addMolecule("yellowPigment", 53, MatterState.SOLID, new Element(ElementEnum.Cr), new Element(ElementEnum.K, 2), new Element(ElementEnum.O, 4));
    public static final MoleculeEnum limePigment = MoleculeEnum.addMolecule("limePigment", 54, MatterState.SOLID, new Element(ElementEnum.Ni), new Element(ElementEnum.Cl, 2));
    public static final MoleculeEnum lightbluePigment = MoleculeEnum.addMolecule("lightbluePigment", 55, MatterState.SOLID, new Element(ElementEnum.Cu), new Molecule(sulfate));
    public static final MoleculeEnum purplePigment = MoleculeEnum.addMolecule("purplePigment", 56, MatterState.SOLID, new Element(ElementEnum.K), new Element(ElementEnum.Mn), new Element(ElementEnum.O, 4));
    public static final MoleculeEnum greenPigment = MoleculeEnum.addMolecule("greenPigment", 57, MatterState.SOLID, new Element(ElementEnum.Co), new Element(ElementEnum.Zn), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum blackPigment = MoleculeEnum.addMolecule("blackPigment", 58, MatterState.GAS, new Element(ElementEnum.C), new Element(ElementEnum.H, 2), new Element(ElementEnum.O));
    public static final MoleculeEnum whitePigment = MoleculeEnum.addMolecule("whitePigment", 59, MatterState.SOLID, new Element(ElementEnum.Ti), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum metasilicate = MoleculeEnum.addMolecule("metasilicate", 60, MatterState.SOLID, new Element(ElementEnum.Si), new Element(ElementEnum.O, 3));
    public static final MoleculeEnum beryl = MoleculeEnum.addMolecule("beryl", 61, MatterState.SOLID, new Element(ElementEnum.Be, 3), new Element(ElementEnum.Al, 2), new Molecule(metasilicate, 6));
    public static final MoleculeEnum ethanol = MoleculeEnum.addMolecule("ethanol", 62, MatterState.LIQUID, 1100, new Element(ElementEnum.C, 2), new Element(ElementEnum.H, 5), new Molecule(hydroxide));
    public static final MoleculeEnum amphetamine = MoleculeEnum.addMolecule("amphetamine", 63, MatterState.LIQUID, new Element(ElementEnum.C, 9), new Element(ElementEnum.H, 13), new Element(ElementEnum.N));
    public static final MoleculeEnum theobromine = MoleculeEnum.addMolecule("theobromine", 64, MatterState.SOLID, new Element(ElementEnum.C, 7), new Element(ElementEnum.H, 8), new Element(ElementEnum.N, 4), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum starch = MoleculeEnum.addMolecule("starch", 65, MatterState.SOLID, new Molecule(cellulose, 3));
    public static final MoleculeEnum sucrose = MoleculeEnum.addMolecule("sucrose", 66, MatterState.SOLID, new Element(ElementEnum.C, 12), new Element(ElementEnum.H, 22), new Element(ElementEnum.O, 11));
    public static final MoleculeEnum pantherine = MoleculeEnum.addMolecule("pantherine", 67, MatterState.SOLID, new Element(ElementEnum.C, 4), new Element(ElementEnum.H, 6), new Element(ElementEnum.N, 2), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum aluminiumOxide = MoleculeEnum.addMolecule("aluminiumOxide", 68, MatterState.SOLID, new Element(ElementEnum.Al, 2), new Element(ElementEnum.O, 3));
    public static final MoleculeEnum fullrene = MoleculeEnum.addMolecule("fullrene", 69, 0.47f, 0.47f, 0.47f, 0.47f, 0.47f, 0.47f, MatterState.SOLID, new Element(ElementEnum.C, 64), new Element(ElementEnum.C, 64), new Element(ElementEnum.C, 64), new Element(ElementEnum.C, 64));
    public static final MoleculeEnum valine = MoleculeEnum.addMolecule("valine", 70, MatterState.SOLID, new Element(ElementEnum.C, 5), new Element(ElementEnum.H, 11), new Element(ElementEnum.N), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum penicillin = MoleculeEnum.addMolecule("penicillin", 71, MatterState.SOLID, new Element(ElementEnum.C, 16), new Element(ElementEnum.H, 18), new Element(ElementEnum.N, 2), new Element(ElementEnum.O, 4), new Element(ElementEnum.S));
    public static final MoleculeEnum testosterone = MoleculeEnum.addMolecule("testosterone", 72, MatterState.LIQUID, new Element(ElementEnum.C, 19), new Element(ElementEnum.H, 28), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum kaolinite = MoleculeEnum.addMolecule("kaolinite", 73, MatterState.SOLID, new Element(ElementEnum.Al, 2), new Element(ElementEnum.Si, 2), new Element(ElementEnum.O, 5), new Molecule(hydroxide, 4));
    public static final MoleculeEnum fingolimod = MoleculeEnum.addMolecule("fingolimod", 74, MatterState.SOLID, new Element(ElementEnum.C, 19), new Element(ElementEnum.H, 33), new Molecule(nitrogenDioxide));
    public static final MoleculeEnum arginine = MoleculeEnum.addMolecule("arginine", 75, MatterState.SOLID, new Element(ElementEnum.C, 6), new Element(ElementEnum.H, 14), new Element(ElementEnum.N, 4), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum shikimicAcid = MoleculeEnum.addMolecule("shikimicAcid", 76, MatterState.SOLID, new Element(ElementEnum.C, 7), new Element(ElementEnum.H, 10), new Element(ElementEnum.O, 5));
    public static final MoleculeEnum sulfuricAcid = MoleculeEnum.addMolecule("sulfuricAcid", 77, MatterState.LIQUID, new Element(ElementEnum.H, 2), new Element(ElementEnum.S), new Element(ElementEnum.O, 4));
    public static final MoleculeEnum glyphosate = MoleculeEnum.addMolecule("glyphosate", 78, MatterState.LIQUID, new Element(ElementEnum.C, 3), new Element(ElementEnum.H, 8), new Element(ElementEnum.N), new Element(ElementEnum.O, 5), new Element(ElementEnum.P));
    public static final MoleculeEnum asprin = MoleculeEnum.addMolecule("asprin", 79, MatterState.SOLID, new Element(ElementEnum.C, 9), new Element(ElementEnum.H, 8), new Element(ElementEnum.O, 4));
    public static final MoleculeEnum ddt = MoleculeEnum.addMolecule("ddt", 80, MatterState.SOLID, new Element(ElementEnum.C, 14), new Element(ElementEnum.H, 9), new Element(ElementEnum.Cl, 5));
    public static final MoleculeEnum dota = MoleculeEnum.addMolecule("dota", 81, MatterState.SOLID, new Element(ElementEnum.C, 16), new Element(ElementEnum.H, 28), new Element(ElementEnum.N, 4), new Element(ElementEnum.O, 8));
    public static final MoleculeEnum mycotoxin = MoleculeEnum.addMolecule("mycotoxin", 82, 0.89f, 0.83f, 0.07f, 0.89f, 0.83f, 0.07f, MatterState.SOLID, new Element(ElementEnum.C, 24), new Element(ElementEnum.H, 34), new Element(ElementEnum.O, 9));
    public static final MoleculeEnum salt = MoleculeEnum.addMolecule("salt", 83, MatterState.SOLID, new Element(ElementEnum.Na), new Element(ElementEnum.Cl));
    public static final MoleculeEnum ammonia = MoleculeEnum.addMolecule("ammonia", 84, MatterState.GAS, new Element(ElementEnum.N), new Element(ElementEnum.H, 3));
    public static final MoleculeEnum nodularin = MoleculeEnum.addMolecule("nodularin", 85, MatterState.SOLID, new Element(ElementEnum.C, 41), new Element(ElementEnum.H, 60), new Element(ElementEnum.N, 8), new Element(ElementEnum.O, 10));
    public static final MoleculeEnum tetrodotoxin = MoleculeEnum.addMolecule("tetrodotoxin", 86, MatterState.SOLID, new Element(ElementEnum.C, 11), new Element(ElementEnum.H, 11), new Element(ElementEnum.N, 3), new Element(ElementEnum.O, 8));
    public static final MoleculeEnum thc = MoleculeEnum.addMolecule("thc", 87, MatterState.SOLID, new Element(ElementEnum.C, 21), new Element(ElementEnum.H, 30), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum mt = MoleculeEnum.addMolecule("mt", 88, MatterState.LIQUID, new Element(ElementEnum.C, 9), new Element(ElementEnum.H, 7), new Element(ElementEnum.Mn, 1), new Element(ElementEnum.O, 3));
    public static final MoleculeEnum buli = MoleculeEnum.addMolecule("buli", 89, MatterState.SOLID, new Element(ElementEnum.Li), new Element(ElementEnum.C, 4), new Element(ElementEnum.H, 9));
    public static final MoleculeEnum plat = MoleculeEnum.addMolecule("plat", 90, MatterState.SOLID, new Element(ElementEnum.H, 2), new Element(ElementEnum.Pt, 1), new Element(ElementEnum.Cl, 6));
    public static final MoleculeEnum phosgene = MoleculeEnum.addMolecule("phosgene", 91, MatterState.GAS, new Element(ElementEnum.C), new Element(ElementEnum.O), new Element(ElementEnum.Cl, 2));
    public static final MoleculeEnum aalc = MoleculeEnum.addMolecule("aalc", 92, MatterState.LIQUID, 800, new Element(ElementEnum.C, 3), new Element(ElementEnum.H, 5), new Molecule(hydroxide));
    public static final MoleculeEnum hist = MoleculeEnum.addMolecule("hist", 93, MatterState.SOLID, new Element(ElementEnum.C, 17), new Element(ElementEnum.H, 21), new Element(ElementEnum.N), new Element(ElementEnum.O));
    public static final MoleculeEnum pal2 = MoleculeEnum.addMolecule("pal2", 94, MatterState.SOLID, new Element(ElementEnum.C, 31), new Element(ElementEnum.H, 42), new Element(ElementEnum.N, 2), new Element(ElementEnum.O, 6));
    public static final MoleculeEnum retinol = MoleculeEnum.addMolecule("retinol", 95, MatterState.SOLID, new Element(ElementEnum.C, 20), new Element(ElementEnum.H, 29), new Molecule(hydroxide));
    public static final MoleculeEnum xylitol = MoleculeEnum.addMolecule("xylitol", 96, MatterState.SOLID, new Element(ElementEnum.C, 5), new Element(ElementEnum.H, 12), new Element(ElementEnum.O, 5));
    public static final MoleculeEnum weedex = MoleculeEnum.addMolecule("weedex", 97, MatterState.SOLID, new Element(ElementEnum.C, 8), new Element(ElementEnum.H, 8), new Element(ElementEnum.Cl), new Element(ElementEnum.N, 3), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum xanax = MoleculeEnum.addMolecule("xanax", 98, MatterState.SOLID, new Element(ElementEnum.C, 17), new Element(ElementEnum.H, 13), new Element(ElementEnum.Cl), new Element(ElementEnum.N, 4));
    public static final MoleculeEnum hcl = MoleculeEnum.addMolecule("hcl", 99, MatterState.LIQUID, new Element(ElementEnum.H), new Element(ElementEnum.Cl));
    public static final MoleculeEnum cocaine = MoleculeEnum.addMolecule("cocaine", 100, MatterState.SOLID, new Element(ElementEnum.C, 17), new Element(ElementEnum.H, 21), new Element(ElementEnum.N), new Element(ElementEnum.O, 4));
    public static final MoleculeEnum cocainehcl = MoleculeEnum.addMolecule("cocainehcl", 101, MatterState.SOLID, new Molecule(cocaine), new Molecule(hcl));
    public static final MoleculeEnum blueorgodye = MoleculeEnum.addMolecule("blueorgodye", 102, MatterState.LIQUID, new Element(ElementEnum.C, 15), new Element(ElementEnum.H, 18));
    public static final MoleculeEnum redorgodye = MoleculeEnum.addMolecule("redorgodye", 103, MatterState.SOLID, new Element(ElementEnum.C, 15), new Element(ElementEnum.H, 11), new Element(ElementEnum.O, 11));
    public static final MoleculeEnum purpleorgodye = MoleculeEnum.addMolecule("purpleorgodye", 104, MatterState.SOLID, new Element(ElementEnum.C, 15), new Element(ElementEnum.H, 11), new Element(ElementEnum.O, 7));
    public static final MoleculeEnum olivine = MoleculeEnum.addMolecule("olivine", 105, MatterState.SOLID, new Element(ElementEnum.Fe, 2), new Element(ElementEnum.Si), new Element(ElementEnum.O, 4));
    public static final MoleculeEnum metblue = MoleculeEnum.addMolecule("metblue", 106, MatterState.SOLID, new Element(ElementEnum.C, 16), new Element(ElementEnum.H, 18), new Element(ElementEnum.N, 3), new Element(ElementEnum.S), new Element(ElementEnum.Cl));
    public static final MoleculeEnum meoh = MoleculeEnum.addMolecule("meoh", 107, MatterState.LIQUID, 500, new Molecule(methyl), new Molecule(hydroxide));
    public static final MoleculeEnum lcd = MoleculeEnum.addMolecule("lcd", 108, MatterState.SOLID, new Element(ElementEnum.C, 34), new Element(ElementEnum.H, 50), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum radchlor = MoleculeEnum.addMolecule("radchlor", 109, MatterState.SOLID, new Element(ElementEnum.Ra), new Element(ElementEnum.Cl, 2));
    public static final MoleculeEnum caulerpenyne = MoleculeEnum.addMolecule("caulerpenyne", 110, MatterState.SOLID, new Element(ElementEnum.C, 21), new Element(ElementEnum.H, 26), new Element(ElementEnum.O, 6));
    public static final MoleculeEnum latropine = MoleculeEnum.addMolecule("latropine", 111, MatterState.SOLID, new Element(ElementEnum.C, 17), new Element(ElementEnum.H, 23), new Element(ElementEnum.N), new Element(ElementEnum.O, 4));
    public static final MoleculeEnum gallicacid = MoleculeEnum.addMolecule("gallicacid", 112, MatterState.SOLID, new Element(ElementEnum.C, 7), new Element(ElementEnum.H, 17), new Element(ElementEnum.O, 5));
    public static final MoleculeEnum glucose = MoleculeEnum.addMolecule("glucose", 113, MatterState.SOLID, new Element(ElementEnum.C, 6), new Element(ElementEnum.H, 12), new Element(ElementEnum.O, 6));
    public static final MoleculeEnum tannicacid = MoleculeEnum.addMolecule("tannicacid", 114, MatterState.SOLID, new Molecule(gallicacid, 10), new Molecule(glucose));
    public static final MoleculeEnum hperox = MoleculeEnum.addMolecule("hperox", 115, MatterState.LIQUID, new Element(ElementEnum.H, 2), new Molecule(peroxide));
    public static final MoleculeEnum galliumarsenide = MoleculeEnum.addMolecule("galliumarsenide", 116, MatterState.SOLID, new Element(ElementEnum.Ga), new Element(ElementEnum.As));
    public static final MoleculeEnum fibroin = MoleculeEnum.addMolecule("fibroin", 117, MatterState.LIQUID, new Molecule(glycine), new Molecule(serine), new Molecule(glycine), new Molecule(alinine), new Molecule(glycine), new Molecule(alinine));
    public static final MoleculeEnum aluminiumPhosphate = MoleculeEnum.addMolecule("aluminiumPhosphate", 118, MatterState.SOLID, new Element(ElementEnum.Al), new Molecule(phosphate));
    public static final MoleculeEnum potassiumOxide = MoleculeEnum.addMolecule("potassiumOxide", 119, MatterState.SOLID, new Element(ElementEnum.K, 2), new Element(ElementEnum.O));
    public static final MoleculeEnum sodiumOxide = MoleculeEnum.addMolecule("sodiumOxide", 120, MatterState.SOLID, new Element(ElementEnum.Na, 2), new Element(ElementEnum.O));
    public static final MoleculeEnum plagioclaseAnorthite = MoleculeEnum.addMolecule("plagioclaseAnorthite", 121, MatterState.SOLID, new Element(ElementEnum.Ca), new Element(ElementEnum.Al, 2), new Element(ElementEnum.Si, 2), new Element(ElementEnum.O, 8));
    public static final MoleculeEnum plagioclaseAlbite = MoleculeEnum.addMolecule("plagioclaseAlbite", 122, MatterState.SOLID, new Element(ElementEnum.Na), new Element(ElementEnum.Al, 2), new Element(ElementEnum.Si, 3), new Element(ElementEnum.O, 8));
    public static final MoleculeEnum orthoclase = MoleculeEnum.addMolecule("orthoclase", 123, MatterState.SOLID, new Element(ElementEnum.K), new Element(ElementEnum.Al), new Element(ElementEnum.Si, 3), new Element(ElementEnum.O, 8));
    public static final MoleculeEnum biotite = MoleculeEnum.addMolecule("biotite", 124, MatterState.SOLID, new Element(ElementEnum.K), new Element(ElementEnum.Fe, 3), new Element(ElementEnum.Al), new Element(ElementEnum.Si, 3), new Element(ElementEnum.O, 10), new Element(ElementEnum.F, 2));
    public static final MoleculeEnum augite = MoleculeEnum.addMolecule("augite", 125, MatterState.SOLID, new Element(ElementEnum.Na), new Element(ElementEnum.Fe), new Element(ElementEnum.Al, 2), new Element(ElementEnum.O, 6));
    public static final MoleculeEnum talc = MoleculeEnum.addMolecule("talc", 126, MatterState.SOLID, new Element(ElementEnum.Mg, 3), new Element(ElementEnum.Si, 4), new Element(ElementEnum.O, 10));
    public static final MoleculeEnum propane = MoleculeEnum.addMolecule("propane", 127, MatterState.GAS, 1400, new Element(ElementEnum.C, 3), new Element(ElementEnum.H, 8));
    public static final MoleculeEnum peridot = MoleculeEnum.addMolecule("peridot", 128, MatterState.SOLID, new Element(ElementEnum.Mg, 2), new Element(ElementEnum.O, 4), new Element(ElementEnum.Si));
    public static final MoleculeEnum topaz = MoleculeEnum.addMolecule("topaz", 129, MatterState.SOLID, new Element(ElementEnum.Al, 2), new Element(ElementEnum.O, 4), new Element(ElementEnum.F, 2));
    public static final MoleculeEnum zoisite = MoleculeEnum.addMolecule("zoisite", 130, MatterState.SOLID, new Element(ElementEnum.Ca, 2), new Element(ElementEnum.Al, 3), new Element(ElementEnum.Si, 3), new Element(ElementEnum.O, 13), new Element(ElementEnum.H));
    public static final MoleculeEnum cysteine = MoleculeEnum.addMolecule("cysteine", 131, MatterState.SOLID, new Element(ElementEnum.C, 3), new Element(ElementEnum.H, 7), new Element(ElementEnum.N), new Element(ElementEnum.O, 2), new Element(ElementEnum.S));
    public static final MoleculeEnum threonine = MoleculeEnum.addMolecule("threonine", 132, MatterState.SOLID, new Element(ElementEnum.C, 4), new Element(ElementEnum.H, 9), new Element(ElementEnum.N), new Element(ElementEnum.O, 3));
    public static final MoleculeEnum lysine = MoleculeEnum.addMolecule("lysine", 133, MatterState.SOLID, new Element(ElementEnum.C, 6), new Element(ElementEnum.H, 14), new Element(ElementEnum.N, 2), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum methionine = MoleculeEnum.addMolecule("methionine", 134, MatterState.SOLID, new Element(ElementEnum.C, 5), new Element(ElementEnum.H, 11), new Element(ElementEnum.N), new Element(ElementEnum.O, 2), new Element(ElementEnum.S));
    public static final MoleculeEnum tyrosine = MoleculeEnum.addMolecule("tyrosine", 135, MatterState.SOLID, new Element(ElementEnum.C, 9), new Element(ElementEnum.H, 11), new Element(ElementEnum.N), new Element(ElementEnum.O, 3));
    public static final MoleculeEnum histidine = MoleculeEnum.addMolecule("histidine", 136, MatterState.SOLID, new Element(ElementEnum.C, 6), new Element(ElementEnum.H, 9), new Element(ElementEnum.N, 3), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum phenylalanine = MoleculeEnum.addMolecule("phenylalanine", 137, MatterState.SOLID, new Element(ElementEnum.C, 9), new Element(ElementEnum.H, 11), new Element(ElementEnum.N), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum glutamine = MoleculeEnum.addMolecule("glutamine", 138, MatterState.SOLID, new Element(ElementEnum.C, 5), new Element(ElementEnum.H, 10), new Element(ElementEnum.N, 2), new Element(ElementEnum.O, 3));
    public static final MoleculeEnum proline = MoleculeEnum.addMolecule("proline", 139, MatterState.SOLID, new Element(ElementEnum.C, 5), new Element(ElementEnum.H, 9), new Element(ElementEnum.N), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum leucine = MoleculeEnum.addMolecule("leucine", 140, MatterState.SOLID, new Element(ElementEnum.C, 6), new Element(ElementEnum.H, 13), new Element(ElementEnum.N), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum tryptophan = MoleculeEnum.addMolecule("tryptophan", 141, MatterState.SOLID, new Element(ElementEnum.C, 11), new Element(ElementEnum.H, 12), new Element(ElementEnum.N, 2), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum isoleucine = MoleculeEnum.addMolecule("isoleucine", 142, MatterState.SOLID, new Element(ElementEnum.C, 6), new Element(ElementEnum.H, 13), new Element(ElementEnum.N), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum glutamates = MoleculeEnum.addMolecule("glutamates", 143, MatterState.SOLID, new Element(ElementEnum.C, 5), new Element(ElementEnum.H, 9), new Element(ElementEnum.N), new Element(ElementEnum.O, 4));
    public static final MoleculeEnum asparagine = MoleculeEnum.addMolecule("asparagine", 144, MatterState.SOLID, new Element(ElementEnum.C, 4), new Element(ElementEnum.H, 8), new Element(ElementEnum.N, 2), new Element(ElementEnum.O, 3));
    public static final MoleculeEnum keratin = MoleculeEnum.addMolecule("keratin", 145, MatterState.SOLID, new Molecule(threonine), new Molecule(cysteine), new Molecule(proline), new Molecule(threonine), new Molecule(proline), new Molecule(cysteine), new Molecule(proline));
    public static final MoleculeEnum asbestos = MoleculeEnum.addMolecule("asbestos", 146, MatterState.SOLID, new Element(ElementEnum.Mg, 3), new Element(ElementEnum.Si, 2), new Element(ElementEnum.O, 5), new Molecule(hydroxide, 4));
    public static final MoleculeEnum lithiumHydroxide = MoleculeEnum.addMolecule("lithiumHydroxide", 147, MatterState.SOLID, new Element(ElementEnum.Li, 1), new Molecule(hydroxide, 1));
    public static final MoleculeEnum sodiumHydroxide = MoleculeEnum.addMolecule("sodiumHydroxide", 148, MatterState.SOLID, new Element(ElementEnum.Na, 1), new Molecule(hydroxide, 1));
    public static final MoleculeEnum potassiumHydroxide = MoleculeEnum.addMolecule("potassiumHydroxide", 149, MatterState.SOLID, new Element(ElementEnum.K, 1), new Molecule(hydroxide, 1));
    public static final MoleculeEnum rubidiumHydroxide = MoleculeEnum.addMolecule("rubidiumHydroxide", 150, MatterState.SOLID, new Element(ElementEnum.Rb, 1), new Molecule(hydroxide, 1));
    public static final MoleculeEnum cesiumHydroxide = MoleculeEnum.addMolecule("cesiumHydroxide", 151, MatterState.SOLID, new Element(ElementEnum.Cs, 1), new Molecule(hydroxide, 1));
    public static final MoleculeEnum franciumHydroxide = MoleculeEnum.addMolecule("franciumHydroxide", 152, MatterState.SOLID, new Element(ElementEnum.Fr, 1), new Molecule(hydroxide, 1));
    public static final MoleculeEnum hypophosphite = MoleculeEnum.addMolecule("hypophosphite", 153, MatterState.SOLID, new Element(ElementEnum.H, 2), new Element(ElementEnum.P, 1), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum aluminiumHypophosphite = MoleculeEnum.addMolecule("aluminiumHypophosphite", 154, MatterState.SOLID, new Element(ElementEnum.Al, 1), new Molecule(hypophosphite, 3));
    public static final MoleculeEnum omphacite = MoleculeEnum.addMolecule("omphacite", 155, MatterState.SOLID, new Element(ElementEnum.Ca, 1), new Element(ElementEnum.Al, 1), new Element(ElementEnum.Si, 2), new Element(ElementEnum.O, 6));
    public static final MoleculeEnum silicate = MoleculeEnum.addMolecule("silicate", 156, MatterState.SOLID, new Element(ElementEnum.Si, 1), new Element(ElementEnum.O, 4));
    public static final MoleculeEnum pyrope = MoleculeEnum.addMolecule("pyrope", 157, MatterState.SOLID, new Element(ElementEnum.Mg, 3), new Element(ElementEnum.Al, 2), new Molecule(silicate, 3));
    public static final MoleculeEnum almadine = MoleculeEnum.addMolecule("almadine", 158, MatterState.SOLID, new Element(ElementEnum.Fe, 3), new Element(ElementEnum.Al, 2), new Molecule(silicate, 3));
    public static final MoleculeEnum spessartine = MoleculeEnum.addMolecule("spessartine", 159, MatterState.SOLID, new Element(ElementEnum.Mn, 3), new Element(ElementEnum.Al, 2), new Molecule(silicate, 3));
    public static final MoleculeEnum redGarnet = MoleculeEnum.addMolecule("redGarnet", 160, MatterState.SOLID, new Molecule(pyrope, 3), new Molecule(almadine, 5), new Molecule(spessartine, 8));
    public static final MoleculeEnum forsterite = MoleculeEnum.addMolecule("forsterite", 161, MatterState.SOLID, new Element(ElementEnum.Mg, 2), new Molecule(silicate, 1));
    public static final MoleculeEnum chromite = MoleculeEnum.addMolecule("chromite", 162, MatterState.SOLID, new Element(ElementEnum.Fe, 1), new Element(ElementEnum.Cr, 2), new Element(ElementEnum.O, 4));
    public static final MoleculeEnum siliconOxide = MoleculeEnum.addMolecule("siliconOxide", 163, MatterState.SOLID, new Element(ElementEnum.Si, 1), new Element(ElementEnum.O, 1));
    public static final MoleculeEnum ironOxide = MoleculeEnum.addMolecule("ironOxide", 164, MatterState.SOLID, new Element(ElementEnum.Fe, 1), new Element(ElementEnum.O, 1));
    public static final MoleculeEnum galliumOxide = MoleculeEnum.addMolecule("galliumOxide", 165, MatterState.SOLID, new Element(ElementEnum.Ga, 1), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum arsenicOxide = MoleculeEnum.addMolecule("arsenicOxide", 166, MatterState.SOLID, new Element(ElementEnum.As, 1), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum sulfurDioxide = MoleculeEnum.addMolecule("sulfurDioxide", 167, MatterState.GAS, new Element(ElementEnum.S), new Element(ElementEnum.O, 2));
    public static final MoleculeEnum hydrogenSulfide = MoleculeEnum.addMolecule("hydrogenSulfide", 168, MatterState.GAS, new Element(ElementEnum.H, 2), new Element(ElementEnum.S));
    public static final MoleculeEnum sodiumBisulfate = MoleculeEnum.addMolecule("sodiumBisulfate", 169, MatterState.SOLID, new Element(ElementEnum.Na), new Element(ElementEnum.H), new Molecule(sulfate));
    public static final MoleculeEnum sodiumSulfate = MoleculeEnum.addMolecule("sodiumSulfate", 170, MatterState.SOLID, new Element(ElementEnum.Na, 2), new Molecule(sulfate));
    public static final MoleculeEnum dimethyltryptamine = MoleculeEnum.addMolecule("dimethyltryptamine", 171, MatterState.SOLID, new Element(ElementEnum.C, 12), new Element(ElementEnum.H, 16), new Element(ElementEnum.N, 2));
    public static final MoleculeEnum oleicAcid = MoleculeEnum.addMolecule("oleicAcid", 172, MatterState.SOLID, new Element(ElementEnum.C, 18), new Element(ElementEnum.H, 34), new Element(ElementEnum.O, 2));
    private final String localizationKey;
    private final ArrayList<PotionChemical> components;
    private final int id;
    private final String name;
    private final int size;
    private final String formula;
    public float red;
    public float green;
    public float blue;
    public float red2;
    public float green2;
    public float blue2;

    public MoleculeEnum(String name, int id, float colorRed, float colorGreen, float colorBlue, float colorRed2, float colorGreen2, float colorBlue2, MatterState roomState, PotionChemical ... chemicals) {
        this(name, id, colorRed, colorGreen, colorBlue, colorRed2, colorGreen2, colorBlue2, roomState, -1, chemicals);
    }

    public MoleculeEnum(String name, int id, float colorRed, float colorGreen, float colorBlue, float colorRed2, float colorGreen2, float colorBlue2, MatterState roomState, int fuelBurnTime, PotionChemical ... chemicals) {
        super(roomState, MoleculeEnum.computeRadioactivity(chemicals));
        this.id = id;
        this.name = name;
        this.components = new ArrayList();
        this.localizationKey = "molecule." + name;
        for (PotionChemical potionChemical : chemicals) {
            this.components.add(potionChemical);
        }
        this.red = colorRed;
        this.green = colorGreen;
        this.blue = colorBlue;
        this.red2 = colorRed2;
        this.green2 = colorGreen2;
        this.blue2 = colorBlue2;
        this.size = this.computSize();
        this.formula = this.computFormula();
        if (fuelBurnTime > 0) {
            MoleculeEnum.registerFuel(this, fuelBurnTime);
        }
    }

    public MoleculeEnum(String name, int id, MatterState roomState, PotionChemical ... chemicals) {
        this(name, id, MoleculeEnum.getRandomColor(name.hashCode()), MoleculeEnum.getRandomColor(name.hashCode() * 2), MoleculeEnum.getRandomColor(name.hashCode() * 3), MoleculeEnum.getRandomColor(name.hashCode() * 4), MoleculeEnum.getRandomColor(name.hashCode() * 5), MoleculeEnum.getRandomColor(name.hashCode() * 6), roomState, -1, chemicals);
    }

    public int getColor1() {
        int r = (int)(255.0f / this.red);
        int color = (int)(255.0f * this.red);
        color = (color << 8) + (int)(255.0f * this.green);
        color = (color << 8) + (int)(255.0f * this.blue);
        return color;
    }

    public int getColor2() {
        int color = (int)(255.0f * this.red2);
        color = (color << 8) + (int)(255.0f * this.green2);
        color = (color << 8) + (int)(255.0f * this.blue2);
        return color;
    }

    public static MoleculeEnum addMolecule(String name, int id, float colorRed, float colorGreen, float colorBlue, float colorRed2, float colorGreen2, float colorBlue2, MatterState roomState, PotionChemical ... chemicals) {
        return MoleculeEnum.addMolecule(name, id, colorRed, colorGreen, colorBlue, colorRed2, colorGreen2, colorBlue2, roomState, -1, chemicals);
    }

    public static MoleculeEnum addMolecule(String name, int id, float colorRed, float colorGreen, float colorBlue, float colorRed2, float colorGreen2, float colorBlue2, MatterState roomState, int fuelBurnTime, PotionChemical ... chemicals) {
        MoleculeEnum molecule = new MoleculeEnum(name, id, colorRed, colorGreen, colorBlue, colorRed2, colorGreen2, colorBlue2, roomState, fuelBurnTime, chemicals);
        MoleculeEnum.registerMolecule(molecule);
        return molecule;
    }

    public static MoleculeEnum addMolecule(String name, int id, MatterState roomState, PotionChemical ... chemicals) {
        return MoleculeEnum.addMolecule(name, id, roomState, -1, chemicals);
    }

    public static MoleculeEnum addMolecule(String name, int id, MatterState roomState, int fuelBurnTime, PotionChemical ... chemicals) {
        return MoleculeEnum.addMolecule(name, id, MoleculeEnum.getRandomColor(name.hashCode()), MoleculeEnum.getRandomColor(name.hashCode() * 2), MoleculeEnum.getRandomColor(name.hashCode() * 3), MoleculeEnum.getRandomColor(name.hashCode() * 4), MoleculeEnum.getRandomColor(name.hashCode() * 5), MoleculeEnum.getRandomColor(name.hashCode() * 6), roomState, fuelBurnTime, chemicals);
    }

    public static void registerFuel(MoleculeEnum molecule, int burnTime) {
        if (!fuelBurnTimes.containsKey(molecule) && burnTime > 0) {
            fuelBurnTimes.put(molecule, burnTime);
        }
    }

    public int getFuelBurnTime() {
        if (fuelBurnTimes.containsKey(this)) {
            return fuelBurnTimes.get(this);
        }
        return -1;
    }

    public static void registerMolecule(MoleculeEnum molecule) {
        MoleculeEnum.addMapping(molecule);
        if (!molecule.name.equals("water")) {
            // empty if block
        }
    }

    public static void registerMTMolecule(MoleculeEnum molecule) {
        MoleculeEnum.addMapping(molecule);
        ArrayList<PotionChemical> var5 = molecule.components();
        PotionChemical[] var6 = var5.toArray(new PotionChemical[var5.size()]);
        ItemStack var7 = new ItemStack((Item)ModItems.molecule, 1, molecule.id());
    }

    public static void unregisterMolecule(MoleculeEnum molecule) {
        MoleculeEnum.removeMapping(molecule);
        RecipeDecomposer.remove(new ItemStack((Item)ModItems.molecule, 1, molecule.id()));
    }

    private static float getRandomColor(long seed) {
        Random random = new Random(seed);
        return random.nextFloat();
    }

    private int computSize() {
        int result = 0;
        Iterator<PotionChemical> iter = this.components().iterator();
        while (iter.hasNext()) {
            result += iter.next().amount;
        }
        return result;
    }

    public int getSize() {
        return this.size;
    }

    public static MoleculeEnum getById(int id) {
        return molecules.get(id);
    }

    public static MoleculeEnum getByName(String name) {
        return nameToMolecules.get(name);
    }

    public int id() {
        return this.id;
    }

    public ArrayList<PotionChemical> components() {
        return this.components;
    }

    public String name() {
        return this.name;
    }

    private static RadiationEnum computeRadioactivity(PotionChemical[] components) {
        RadiationEnum radiation = null;
        for (PotionChemical chemical : components) {
            RadiationEnum anotherRadiation = null;
            if (chemical instanceof Element) {
                anotherRadiation = ((Element)chemical).element.radioactivity();
            } else if (chemical instanceof Molecule) {
                anotherRadiation = ((Molecule)chemical).molecule.radioactivity();
            }
            if (anotherRadiation == null || anotherRadiation == RadiationEnum.stable || radiation != null && radiation.getLife() <= anotherRadiation.getLife()) continue;
            radiation = anotherRadiation;
        }
        return radiation == null ? RadiationEnum.stable : radiation;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public String getUnlocalizedName() {
        return this.localizationKey;
    }

    private static void addMapping(MoleculeEnum molecule) {
        if (molecules.containsKey(molecule.id())) {
            throw new IllegalArgumentException("id " + molecule.id() + " is used");
        }
        if (nameToMolecules.containsKey(molecule.name())) {
            throw new IllegalArgumentException("name " + molecule.name() + " is used");
        }
        molecules.put(molecule.id(), molecule);
        nameToMolecules.put(molecule.name(), molecule);
    }

    private static void removeMapping(MoleculeEnum molecule) {
        molecules.remove(molecule.id());
        nameToMolecules.remove(molecule.name());
    }

    public String getFormula() {
        return this.formula;
    }

    private String computFormula() {
        String formula = "";
        for (PotionChemical component : this.components) {
            if (component instanceof Element) {
                formula = formula + ((Element)component).element.name();
                if (component.amount <= 1) continue;
                formula = formula + component.amount;
                continue;
            }
            if (!(component instanceof Molecule)) continue;
            if (component.amount > 1) {
                formula = formula + "(";
            }
            formula = formula + ((Molecule)component).molecule.getFormula();
            if (component.amount <= 1) continue;
            formula = formula + ")" + component.amount;
        }
        return formula;
    }

    public static void init() {
    }

    public PotionChemical[] componentsArray() {
        return this.components.toArray(new PotionChemical[this.components.size()]);
    }
}

