/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.polytool;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import minechem.item.ItemPolytool;
import minechem.item.element.ElementEnum;
import minechem.recipe.RecipeDecomposer;
import minechem.recipe.handler.RecipeHandlerDecomposer;
import minechem.utils.MinechemUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PolytoolEventHandler {
    private static final Random random = new Random();

    public void addDrops(LivingDropsEvent event, ItemStack dropStack) {
        EntityItem entityitem = new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, dropStack);
        entityitem.func_174867_a(10);
        event.getDrops().add(entityitem);
    }

    @SubscribeEvent
    public void onDrop(LivingDropsEvent event) {
        if ("player".equals(event.getSource().field_76373_n)) {
            EntityLivingBase enemy;
            EntityItem entityItem2;
            float powerSilicon;
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            ItemStack stack = player.func_184607_cu();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemPolytool && (powerSilicon = ItemPolytool.getPowerOfType(stack, ElementEnum.Si)) > 0.0f) {
                int amount = (int)Math.ceil(random.nextDouble() * (double)powerSilicon);
                Iterator iter = event.getDrops().iterator();
                if ((float)random.nextInt(16) < 1.0f + powerSilicon) {
                    ArrayList<EntityItem> trueResult = new ArrayList<EntityItem>();
                    block0: while (iter.hasNext()) {
                        entityItem2 = (EntityItem)iter.next();
                        ItemStack item = entityItem2.func_92059_d();
                        while (item.func_190916_E() > 0) {
                            RecipeDecomposer recipe = RecipeHandlerDecomposer.instance.getRecipe(item);
                            if (recipe != null) {
                                NonNullList<ItemStack> items = MinechemUtil.convertChemicalsIntoItemStacks(recipe.getOutput());
                                for (ItemStack itemStack : items) {
                                    trueResult.add(new EntityItem(entityItem2.field_70170_p, entityItem2.field_70165_t, entityItem2.field_70163_u, entityItem2.field_70161_v, itemStack));
                                }
                            } else {
                                trueResult.add(entityItem2);
                                continue block0;
                            }
                            item.func_190918_g(1);
                        }
                    }
                    event.getDrops().clear();
                    event.getDrops().addAll(trueResult);
                }
            }
            if (((enemy = event.getEntityLiving()) instanceof EntitySkeleton || enemy instanceof EntityZombie || enemy instanceof EntityPlayer || enemy instanceof EntityWitherSkeleton || enemy instanceof EntityCreeper || enemy instanceof EntityDragon) && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemPolytool) {
                float power;
                if (enemy instanceof EntityZombie && (power = ItemPolytool.getPowerOfType(stack, ElementEnum.N)) > 0.0f) {
                    int amount = (int)Math.ceil(random.nextDouble() * (double)power);
                    this.addDrops(event, new ItemStack(Items.field_151083_be, amount, 0));
                    Iterator iter = event.getDrops().iterator();
                    while (iter.hasNext()) {
                        entityItem2 = (EntityItem)iter.next();
                        if (entityItem2.func_92059_d().func_77973_b() != Items.field_151078_bh) continue;
                        iter.remove();
                    }
                }
                if (enemy instanceof EntitySkeleton && (power = ItemPolytool.getPowerOfType(stack, ElementEnum.Ca)) > 0.0f) {
                    int amount = (int)Math.ceil(random.nextDouble() * (double)power);
                    for (EntityItem entityItem2 : event.getDrops()) {
                        if (entityItem2.func_92059_d().func_77973_b() != Items.field_151103_aS) continue;
                        entityItem2.func_92059_d().func_190917_f(amount);
                    }
                }
                for (float beheading = ItemPolytool.getPowerOfType(stack, ElementEnum.Be); beheading > 5.0f; beheading -= 1.0f) {
                    if (!(beheading > 0.0f) || !((float)random.nextInt(5) < beheading * 10.0f)) continue;
                    if (event.getEntityLiving() instanceof EntitySkeleton) {
                        this.addDrops(event, new ItemStack(Items.field_151144_bL, 1, 0));
                        continue;
                    }
                    if (event.getEntityLiving() instanceof EntityWitherSkeleton) {
                        this.addDrops(event, new ItemStack(Items.field_151144_bL, 1, 1));
                        continue;
                    }
                    if (event.getEntityLiving() instanceof EntityZombie) {
                        this.addDrops(event, new ItemStack(Items.field_151144_bL, 1, 2));
                        continue;
                    }
                    if (event.getEntityLiving() instanceof EntityPlayer) {
                        ItemStack dropStack = new ItemStack(Items.field_151144_bL, 1, 3);
                        NBTTagCompound nametag = new NBTTagCompound();
                        nametag.func_74778_a("SkullOwner", player.func_145748_c_().func_150254_d());
                        this.addDrops(event, dropStack);
                        continue;
                    }
                    if (event.getEntityLiving() instanceof EntityCreeper) {
                        this.addDrops(event, new ItemStack(Items.field_151144_bL, 1, 4));
                        continue;
                    }
                    if (!(event.getEntityLiving() instanceof EntityDragon)) continue;
                    this.addDrops(event, new ItemStack(Items.field_151144_bL, 1, 5));
                }
            }
        }
    }
}

