/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.polytool;

import java.util.Iterator;
import minechem.item.element.ElementAlloyEnum;
import minechem.item.element.ElementEnum;
import minechem.item.polytool.PolytoolUpgradeType;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class PolytoolTypeAlloy
extends PolytoolUpgradeType {
    private ElementAlloyEnum alloy;

    public PolytoolTypeAlloy(ElementAlloyEnum alloy) {
        this.alloy = alloy;
    }

    public PolytoolTypeAlloy(ElementAlloyEnum alloy, float power) {
        this.power = power;
        this.alloy = alloy;
    }

    public float getStrOre() {
        return this.alloy.pickaxe * this.power;
    }

    public float getStrStone() {
        return this.alloy.stone * this.power;
    }

    public float getStrAxe() {
        return this.alloy.axe * this.power;
    }

    public float getStrSword() {
        return this.alloy.sword * this.power;
    }

    public float getStrShovel() {
        return this.alloy.shovel * this.power;
    }

    @Override
    public float getStrVsBlock(ItemStack itemStack, Block block, int meta) {
        if (this.isToolEffective(new ItemStack(Items.field_151046_w), block, meta)) {
            for (int id : OreDictionary.getOreIDs((ItemStack)new ItemStack(block, 1, meta))) {
                if (!OreDictionary.getOreName((int)id).contains("stone")) continue;
                return this.getStrStone();
            }
            if (block == Blocks.field_150348_b || block == Blocks.field_150347_e) {
                return this.getStrStone();
            }
            return this.getStrOre();
        }
        if (this.isToolEffective(new ItemStack(Items.field_151047_v), block, meta)) {
            return this.getStrShovel();
        }
        if (this.isToolEffective(new ItemStack(Items.field_151048_u), block, meta)) {
            return this.getStrSword();
        }
        if (this.isToolEffective(new ItemStack(Items.field_151056_x), block, meta)) {
            return this.getStrAxe();
        }
        return 0.0f;
    }

    public boolean isToolEffective(ItemStack itemStack, Block block, int meta) {
        String type;
        IBlockState state = block.func_176203_a(meta);
        Iterator var4 = itemStack.func_77973_b().getToolClasses(itemStack).iterator();
        do {
            if (!var4.hasNext()) {
                return false;
            }
            type = (String)var4.next();
        } while (!state.func_177230_c().isToolEffective(type, state));
        return true;
    }

    @Override
    public float getDamageModifier() {
        return this.getStrSword();
    }

    @Override
    public ElementEnum getElement() {
        return this.alloy.element;
    }

    @Override
    public String getDescription() {
        String result = "";
        result = result + "Ore: " + this.getStrOre() + " ";
        result = result + "Stone: " + this.getStrStone() + " ";
        result = result + "Sword: " + this.getStrSword() + " ";
        result = result + "Axe: " + this.getStrAxe() + " ";
        result = result + "Shovel: " + this.getStrShovel() + " ";
        return result;
    }
}

