/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.polytool.types;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import minechem.item.ItemPolytool;
import minechem.item.element.ElementEnum;
import minechem.item.polytool.PolytoolUpgradeType;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class PolytoolTypeIron
extends PolytoolUpgradeType {
    private static Map<String, Boolean> ores = new LinkedHashMap<String, Boolean>();

    public static void getOres() {
        for (String ore : OreDictionary.getOreNames()) {
            if (!ore.regionMatches(0, "ore", 0, 3)) continue;
            for (ItemStack stack : OreDictionary.getOres((String)ore)) {
                ores.put(PolytoolTypeIron.blockHash(stack), true);
            }
        }
    }

    private static String blockHash(ItemStack stack) {
        return PolytoolTypeIron.blockHash(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77952_i());
    }

    private static String blockHash(Block block, int meta) {
        return block.func_149739_a() + "@" + meta;
    }

    @Override
    public void onBlockDestroyed(ItemStack itemStack, World world, Block id, int x1, int y1, int z1, EntityLivingBase entityLiving) {
        if (!world.field_72995_K && entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            ArrayList<Vec3i> queue = new ArrayList<Vec3i>(100);
            float carbon = 0.0f;
            for (PolytoolUpgradeType upgrade : ItemPolytool.getUpgrades(itemStack)) {
                if (upgrade.getElement() != ElementEnum.C) continue;
                carbon = upgrade.power;
            }
            IBlockState state = world.func_180495_p(new BlockPos(x1, y1, z1));
            if (ores.containsKey(PolytoolTypeIron.blockHash(id, state.func_177230_c().func_176201_c(state)))) {
                int toMine = (int)this.power;
                queue.add(new Vec3i(x1, y1, z1));
                while (!queue.isEmpty()) {
                    Vec3i coord = (Vec3i)queue.remove(0);
                    int x = coord.func_177958_n();
                    int y = coord.func_177956_o();
                    int z = coord.func_177952_p();
                    for (EnumFacing dir : EnumFacing.values()) {
                        if (world.func_180495_p(new BlockPos(x + dir.func_82601_c(), y + dir.func_96559_d(), z + dir.func_82599_e())).func_177230_c() != id || world.func_180495_p(new BlockPos(x + dir.func_82601_c(), y + dir.func_96559_d(), z + dir.func_82599_e())) != state) continue;
                        this.breakExtraBlock(world, x + dir.func_82601_c(), y + dir.func_96559_d(), z + dir.func_82599_e(), player, id, state.func_177230_c().func_176201_c(state), carbon);
                        queue.add(new Vec3i(x + dir.func_82601_c(), y + dir.func_96559_d(), z + dir.func_82599_e()));
                        if (--toMine > 0) continue;
                        return;
                    }
                }
            }
        }
    }

    @Override
    public ElementEnum getElement() {
        return ElementEnum.Fe;
    }

    @Override
    public String getDescription() {
        return "Mines deposits of ores";
    }

    protected void breakExtraBlock(World world, int x, int y, int z, EntityPlayer player, Block block, int meta, float carbon) {
        if (player.field_71075_bZ.field_75098_d) {
            block.func_176208_a(world, new BlockPos(x, y, z), block.func_176203_a(meta), player);
            world.func_175698_g(new BlockPos(x, y, z));
            if (!world.field_72995_K) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, new BlockPos(x, y, z)));
            }
            return;
        }
        if (!world.field_72995_K) {
            int bonus = block == Blocks.field_150482_ag || block == Blocks.field_150365_q ? (int)(world.field_73012_v.nextDouble() * Math.log(carbon)) + 1 : 1;
            block.func_176208_a(world, new BlockPos(x, y, z), block.func_176203_a(meta), player);
            if (block.removedByPlayer(block.func_176203_a(meta), world, new BlockPos(x, y, z), player, true)) {
                for (int i = 0; i < bonus; ++i) {
                    block.func_180657_a(world, player, new BlockPos(x, y, z), block.func_176203_a(meta), null, ItemStack.field_190927_a);
                }
            }
            EntityPlayerMP mpPlayer = (EntityPlayerMP)player;
            mpPlayer.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, new BlockPos(x, y, z)));
        }
    }
}

