/*
 * Decompiled with CFR 0.152.
 */
package minechem.potion;

import java.util.HashMap;
import minechem.item.molecule.MoleculeEnum;
import minechem.potion.PharmacologyEffectRegistry;
import minechem.utils.MinechemUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PotionEnchantmentCoated
extends Enchantment {
    MoleculeEnum molecule;
    public static final HashMap<MoleculeEnum, PotionEnchantmentCoated> POTION_COATED_REGISTRY = new HashMap();

    protected PotionEnchantmentCoated(MoleculeEnum molecule, int id) {
        super(Enchantment.Rarity.COMMON, EnumEnchantmentType.WEAPON, EntityEquipmentSlot.values());
        this.molecule = molecule;
    }

    public void applyEffect(EntityLivingBase entity) {
        PharmacologyEffectRegistry.applyEffect(this.molecule, entity);
    }

    public int func_77319_d() {
        return 1;
    }

    public int func_77325_b() {
        return 10;
    }

    public boolean func_92089_a(ItemStack par1ItemStack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return false;
    }

    public String func_77316_c(int level) {
        String enchantedName = I18n.func_135052_a((String)("enchantment.level." + level), (Object[])new Object[0]);
        if (I18n.func_188566_a((String)"minechem.enchantment.coated")) {
            return MinechemUtil.getLocalString(this.molecule.getUnlocalizedName()) + " " + I18n.func_135052_a((String)"minechem.enchantment.coated", (Object[])new Object[]{enchantedName});
        }
        return MinechemUtil.getLocalString(this.molecule.getUnlocalizedName()) + " " + enchantedName + " Coated";
    }

    public static void register(IForgeRegistry<Enchantment> registry) {
        block0: for (MoleculeEnum molecule : MoleculeEnum.molecules.values()) {
            if (molecule == null || !PharmacologyEffectRegistry.hasEffect(molecule)) continue;
            for (Enchantment ench : Enchantment.field_185264_b) {
                if (ench == null) continue;
                PotionEnchantmentCoated newEnch = new PotionEnchantmentCoated(molecule, Enchantment.func_185258_b((Enchantment)ench));
                newEnch.setRegistryName(new ResourceLocation("minechem", molecule.getUnlocalizedName() + ".coated"));
                newEnch.func_77322_b(molecule.getUnlocalizedName() + ".coated");
                registry.register((IForgeRegistryEntry)newEnch);
                POTION_COATED_REGISTRY.put(molecule, newEnch);
                continue block0;
            }
        }
    }
}

