/*
 * Decompiled with CFR 0.152.
 */
package minechem.recipe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import minechem.api.IDecomposerControl;
import minechem.init.ModConfig;
import minechem.potion.PotionChemical;
import minechem.recipe.RecipeDecomposerFluid;
import minechem.utils.MapKey;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeDecomposer {
    public static Map<MapKey, RecipeDecomposer> recipes = new LinkedHashMap<MapKey, RecipeDecomposer>();
    private static final Random rand = new Random();
    ItemStack input = ItemStack.field_190927_a;
    public Map<MapKey, PotionChemical> output = new LinkedHashMap<MapKey, PotionChemical>();

    public static RecipeDecomposer add(RecipeDecomposer recipe) {
        if (!recipe.input.func_190926_b() && recipe.input.func_77973_b() != null) {
            if (RecipeDecomposer.isBlacklisted(recipe.input) || recipe.input.func_77973_b() instanceof IDecomposerControl && ((IDecomposerControl)recipe.input.func_77973_b()).getDecomposerMultiplier(recipe.input) == 0.0) {
                return null;
            }
            if (recipes.get(MapKey.getKey(recipe.input)) == null) {
                recipes.put(MapKey.getKey(recipe.input), recipe);
            }
        } else if (recipe instanceof RecipeDecomposerFluid && ((RecipeDecomposerFluid)recipe).inputFluid != null && recipes.get(MapKey.getKey(((RecipeDecomposerFluid)recipe).inputFluid)) == null) {
            recipes.put(MapKey.getKey(((RecipeDecomposerFluid)recipe).inputFluid), recipe);
        }
        return recipe;
    }

    public static RecipeDecomposer remove(String string) {
        if (recipes.containsKey(string)) {
            return recipes.remove(string);
        }
        return null;
    }

    public static RecipeDecomposer remove(ItemStack itemStack) {
        MapKey key = MapKey.getKey(itemStack);
        if (key != null && recipes.containsKey(key)) {
            return recipes.remove(key);
        }
        return null;
    }

    public static RecipeDecomposer remove(MapKey key) {
        return recipes.remove(key);
    }

    public static RecipeDecomposer get(ItemStack itemStack) {
        if (itemStack.func_190926_b() || itemStack.func_77973_b() == null) {
            return null;
        }
        return RecipeDecomposer.get(MapKey.getKey(itemStack));
    }

    public static RecipeDecomposer get(FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return null;
        }
        RecipeDecomposer recipe = RecipeDecomposer.get(MapKey.getKey(fluidStack));
        if (recipe instanceof RecipeDecomposerFluid) {
            RecipeDecomposerFluid fluidRecipe = (RecipeDecomposerFluid)recipe;
            return fluidStack.amount >= fluidRecipe.inputFluid.amount ? fluidRecipe : null;
        }
        return null;
    }

    public static RecipeDecomposer get(MapKey key) {
        return recipes.get(key);
    }

    public static void removeRecipeSafely(String item) {
        for (ItemStack i : OreDictionary.getOres((String)item)) {
            RecipeDecomposer.remove(i);
        }
    }

    public static void addOreDictRecipe(String item, PotionChemical ... chemicals) {
        if (chemicals.length > 0) {
            for (ItemStack i : OreDictionary.getOres((String)item)) {
                RecipeDecomposer.add(new RecipeDecomposer(new ItemStack(i.func_77973_b(), 1, i.func_77952_i()), chemicals));
            }
        }
    }

    public RecipeDecomposer(ItemStack input, PotionChemical ... chemicals) {
        this(chemicals);
        this.input = input;
    }

    public RecipeDecomposer(ItemStack input, List<PotionChemical> chemicals) {
        this(chemicals.toArray(new PotionChemical[chemicals.size()]));
        this.input = input;
    }

    public RecipeDecomposer(PotionChemical ... chemicals) {
        this.addChemicals(chemicals);
    }

    public void addChemicals(PotionChemical ... chemicals) {
        for (PotionChemical potionChemical : chemicals) {
            PotionChemical current = this.output.get(new MapKey(potionChemical));
            if (current != null) {
                current.amount += potionChemical.amount;
                continue;
            }
            this.output.put(new MapKey(potionChemical), potionChemical.copy());
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public MapKey getKey() {
        return new MapKey(this.getInput());
    }

    public ArrayList<PotionChemical> getOutput() {
        ArrayList<PotionChemical> result = new ArrayList<PotionChemical>();
        result.addAll(this.output.values());
        return result;
    }

    public ArrayList<PotionChemical> getOutputRaw() {
        ArrayList<PotionChemical> result = new ArrayList<PotionChemical>();
        result.addAll(this.output.values());
        return result;
    }

    public PotionChemical[] getOutputAsArray() {
        return this.output.values().toArray(new PotionChemical[this.output.values().size()]);
    }

    public ArrayList<PotionChemical> getPartialOutputRaw(int f) {
        ArrayList<PotionChemical> raw = this.getOutput();
        ArrayList<PotionChemical> result = new ArrayList<PotionChemical>();
        if (raw != null) {
            for (PotionChemical chem : raw) {
                try {
                    PotionChemical reduced;
                    if (chem == null || (reduced = chem.copy()) == null) continue;
                    reduced.amount = (int)Math.floor(chem.amount / f);
                    if (reduced.amount == 0 && rand.nextFloat() > (float)(chem.amount / f)) {
                        reduced.amount = 1;
                    }
                    result.add(reduced);
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public boolean isNull() {
        return this.output == null;
    }

    public boolean hasOutput() {
        return !this.output.values().isEmpty();
    }

    public boolean outputContains(PotionChemical potionChemical) {
        PotionChemical output;
        boolean contains = false;
        Iterator<PotionChemical> iterator = this.output.values().iterator();
        while (iterator.hasNext() && !(contains = potionChemical.sameAs(output = iterator.next()))) {
        }
        return contains;
    }

    public static boolean isBlacklisted(ItemStack itemStack) {
        for (ItemStack stack : ModConfig.decomposerBlacklist) {
            if (stack.func_77973_b() != itemStack.func_77973_b() || stack.func_77952_i() != Short.MAX_VALUE && stack.func_77952_i() != itemStack.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    public float getChance() {
        return 1.0f;
    }
}

