/*
 * Decompiled with CFR 0.152.
 */
package minechem.recipe;

import minechem.init.ModConfig;
import minechem.item.ItemMolecule;
import minechem.potion.PharmacologyEffectRegistry;
import minechem.potion.PotionEnchantmentCoated;
import minechem.utils.MinechemUtil;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RecipePotionCoating
implements IRecipe {
    ItemStack output = ItemStack.field_190927_a;

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        if (ModConfig.SwordEffects) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack s = inv.func_70301_a(i);
                if (s.func_190926_b() || !(s.func_77973_b() instanceof ItemSword)) continue;
                for (int j = 0; j < inv.func_70302_i_(); ++j) {
                    ItemStack s2 = inv.func_70301_a(j);
                    if (s2.func_190926_b() || !(s2.func_77973_b() instanceof ItemMolecule) || !PharmacologyEffectRegistry.hasEffect(MinechemUtil.getMolecule(s2))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean doesItemContainEnchantment(ItemStack stack, Enchantment enchantment) {
        NBTTagList enchNBTList = stack.func_77986_q();
        int enchID = Enchantment.func_185258_b((Enchantment)enchantment);
        if (enchNBTList.func_82582_d()) {
            return false;
        }
        for (int i = 0; i < enchNBTList.func_74745_c(); ++i) {
            NBTTagCompound tag = enchNBTList.func_150305_b(i);
            if (tag.func_82582_d() || !tag.func_150297_b("id", 2) || tag.func_74765_d("id") != enchID) continue;
            return true;
        }
        return false;
    }

    private int getCurrentEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        NBTTagList enchNBTList = stack.func_77986_q();
        int enchID = Enchantment.func_185258_b((Enchantment)enchantment);
        if (!enchNBTList.func_82582_d()) {
            for (int i = 0; i < enchNBTList.func_74745_c(); ++i) {
                NBTTagCompound tag = enchNBTList.func_150305_b(i);
                if (tag.func_82582_d() || !tag.func_150297_b("id", 2) || tag.func_74765_d("id") != enchID) continue;
                return tag.func_74765_d("lvl");
            }
        }
        return -1;
    }

    private boolean incEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        int maxLevel = enchantment.func_77325_b();
        int currentLevel = this.getCurrentEnchantmentLevel(stack, enchantment);
        if (currentLevel < maxLevel) {
            NBTTagList enchNBTList = stack.func_77986_q();
            int enchID = Enchantment.func_185258_b((Enchantment)enchantment);
            if (!enchNBTList.func_82582_d()) {
                for (int i = 0; i < enchNBTList.func_74745_c(); ++i) {
                    NBTTagCompound tag = enchNBTList.func_150305_b(i);
                    if (tag.func_82582_d() || !tag.func_150297_b("id", 2) || tag.func_74765_d("id") != enchID) continue;
                    tag.func_74777_a("lvl", (short)(tag.func_74765_d("lvl") + 1));
                    return true;
                }
            }
        }
        return false;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack s = inv.func_70301_a(i);
            if (s.func_190926_b() || !(s.func_77973_b() instanceof ItemSword)) continue;
            ItemStack result = s.func_77946_l();
            for (int j = 0; j < inv.func_70302_i_(); ++j) {
                ItemStack s2 = inv.func_70301_a(j);
                if (s2.func_190926_b() || !(s2.func_77973_b() instanceof ItemMolecule) || !PharmacologyEffectRegistry.hasEffect(MinechemUtil.getMolecule(s2))) continue;
                PotionEnchantmentCoated ench = PotionEnchantmentCoated.POTION_COATED_REGISTRY.get(MinechemUtil.getMolecule(s2));
                if (this.doesItemContainEnchantment(s, ench)) {
                    if (!this.incEnchantmentLevel(result, ench)) continue;
                    return result;
                }
                result.func_77966_a((Enchantment)PotionEnchantmentCoated.POTION_COATED_REGISTRY.get(MinechemUtil.getMolecule(s2)), 1);
                this.output = result.func_77946_l();
                return result;
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inventoryCrafting) {
        return NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 1 && height >= 1;
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        return this;
    }

    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minechem", "potion_coating");
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }
}

