/*
 * Decompiled with CFR 0.152.
 */
package minechem.recipe.handler;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import minechem.api.recipe.ISynthesisRecipe;
import minechem.init.ModRegistries;
import minechem.item.ItemElement;
import minechem.item.ItemMolecule;
import minechem.item.element.Element;
import minechem.item.molecule.Molecule;
import minechem.potion.PotionChemical;
import minechem.recipe.RecipeSynthesisShaped;
import minechem.recipe.RecipeSynthesisShapeless;
import minechem.recipe.SingleItemStackBasedIngredient;
import minechem.utils.MinechemUtil;
import minechem.utils.RecipeUtil;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeHandlerSynthesis {
    private static final String PREFIX_SHAPED = "synthesis_shaped_";
    private static final String PREFIX_SHAPELESS = "synthesis_shapeless_";
    public static RecipeHandlerSynthesis instance = new RecipeHandlerSynthesis();
    public final Int2IntMap itemToCount = new Int2IntOpenHashMap();

    public static boolean itemStacksMatchesShapelessRecipe(NonNullList<ItemStack> stacks, RecipeSynthesisShapeless recipe, int factor) {
        NonNullList<ItemStack> stacksCopy = MinechemUtil.copyStackList(stacks);
        NonNullList stackList = NonNullList.func_191196_a();
        for (SingleItemStackBasedIngredient ingredient : recipe.getSingleIngredients()) {
            stackList.add((Object)ingredient.getIngredientStack());
        }
        if (stacksCopy.size() == stackList.size()) {
            block1: for (int i = 0; i < stackList.size(); ++i) {
                for (int j = 0; j < stacksCopy.size(); ++j) {
                    if (((ItemStack)stackList.get(i)).func_190926_b() || !MinechemUtil.stacksAreSameKind((ItemStack)stacksCopy.get(j), (ItemStack)stackList.get(i)) || ((ItemStack)stackList.get(i)).func_190916_E() != ((ItemStack)stacksCopy.get(j)).func_190916_E()) continue;
                    stackList.set(i, (Object)ItemStack.field_190927_a);
                    continue block1;
                }
            }
            if (MinechemUtil.isStackListEmpty((NonNullList<ItemStack>)stackList)) {
                return true;
            }
        }
        return false;
    }

    public static boolean itemStacksMatchesShapedRecipe(NonNullList<ItemStack> stacks, RecipeSynthesisShaped recipe, int factor) {
        PotionChemical[] chemicals = MinechemUtil.stackListToChemicalArray(stacks);
        NonNullList<ItemStack> recipeStacks = RecipeUtil.ingredientListToStackList(recipe.getIngredients());
        for (int i = 0; i < chemicals.length; ++i) {
            if (((ItemStack)stacks.get(i)).func_190926_b() && chemicals[i] == null) continue;
            if (((ItemStack)stacks.get(i)).func_190926_b() || chemicals[i] == null) {
                return false;
            }
            if (MinechemUtil.itemStackMatchesChemical((ItemStack)recipeStacks.get(i), chemicals[i], factor) && ((ItemStack)recipeStacks.get(i)).func_190916_E() == chemicals[i].amount) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static ISynthesisRecipe findMatchingRecipe(InventoryCrafting craftMatrix, World worldIn) {
        for (ISynthesisRecipe irecipe : ModRegistries.SYNTHESIS_RECIPES) {
            if (!irecipe.matches(craftMatrix, worldIn)) continue;
            return irecipe;
        }
        return null;
    }

    private static NonNullList<ItemStack> getListFromRecipe(ISynthesisRecipe recipe) {
        NonNullList tmpList = NonNullList.func_191196_a();
        NonNullList<SingleItemStackBasedIngredient> ingredients = recipe.getSingleIngredients();
        for (SingleItemStackBasedIngredient ingredient : ingredients) {
            tmpList.add((Object)ingredient.getIngredientStack());
        }
        return tmpList;
    }

    public static ISynthesisRecipe getRecipeFromInput(NonNullList<ItemStack> stackList) {
        ISynthesisRecipe matchedRecipe = null;
        block0: for (Map.Entry recipeEntry : ModRegistries.SYNTHESIS_RECIPES.getEntries()) {
            int i;
            ItemStack currentStack;
            ISynthesisRecipe recipe = (ISynthesisRecipe)recipeEntry.getValue();
            NonNullList<ItemStack> recipeList = RecipeHandlerSynthesis.getListFromRecipe(recipe);
            if (recipe.isShaped()) {
                if (recipeList.size() != stackList.size()) continue;
                currentStack = ItemStack.field_190927_a;
                for (i = 0; i < stackList.size(); ++i) {
                    currentStack = (ItemStack)stackList.get(i);
                    if (MinechemUtil.stacksAreSameKind(currentStack, (ItemStack)recipeList.get(i)) && currentStack.func_190916_E() == ((ItemStack)recipeList.get(i)).func_190916_E()) {
                        matchedRecipe = recipe;
                        continue block0;
                    }
                    matchedRecipe = null;
                }
                continue;
            }
            if (recipeList.size() != stackList.size()) continue;
            currentStack = ItemStack.field_190927_a;
            for (i = 0; i < stackList.size(); ++i) {
                currentStack = (ItemStack)stackList.get(i);
                if (MinechemUtil.stacksAreSameKind(currentStack, (ItemStack)recipeList.get(i)) && currentStack.func_190916_E() == ((ItemStack)recipeList.get(i)).func_190916_E()) {
                    matchedRecipe = recipe;
                    continue block0;
                }
                matchedRecipe = null;
            }
        }
        return matchedRecipe;
    }

    private static <K extends IForgeRegistryEntry<ISynthesisRecipe>> ISynthesisRecipe register(ISynthesisRecipe object) {
        return (ISynthesisRecipe)GameData.register_impl((IForgeRegistryEntry)object);
    }

    public static void addShapedRecipe(ResourceLocation registryName, int energyCost, ItemStack result, Object ... recipe) {
        RecipeSynthesisShaped.MinechemShapedPrimer primer = RecipeSynthesisShaped.parseShaped(recipe);
        ISynthesisRecipe newRecipe = (ISynthesisRecipe)new RecipeSynthesisShaped(primer.width, primer.height, energyCost, primer.input, result).setRegistryName(registryName);
        RecipeHandlerSynthesis.register(newRecipe);
    }

    public static void addShapedRecipe(String name, int energyCost, ItemStack result, Object ... recipe) {
        String regDomain = name.split(":").length == 1 ? "minechem" : name.split(":")[1];
        String regPath = name.split(":").length == 1 ? name : name.split(":")[1];
        RecipeHandlerSynthesis.addShapedRecipe(new ResourceLocation(regDomain, PREFIX_SHAPED + regPath), energyCost, result, recipe);
    }

    public static void addShapelessRecipe(String name, int energyCost, @Nonnull ItemStack output, PotionChemical ... recipe) {
        NonNullList lst = NonNullList.func_191196_a();
        for (PotionChemical ingredient : recipe) {
            if (!(ingredient instanceof PotionChemical)) continue;
            PotionChemical chemical = ingredient;
            lst.add((Object)MinechemUtil.chemicalToItemStack(chemical, chemical.amount));
        }
        NonNullList<SingleItemStackBasedIngredient> dumbList = SingleItemStackBasedIngredient.fromItemStacks((ItemStack[])lst.toArray((Object[])new ItemStack[lst.size()]));
        ISynthesisRecipe newRecipe = (ISynthesisRecipe)new RecipeSynthesisShapeless(output, energyCost, dumbList).setRegistryName(new ResourceLocation("minechem", PREFIX_SHAPELESS + name));
        RecipeHandlerSynthesis.register(newRecipe);
    }

    public static void removeShapedRecipe(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemElement || stack.func_77973_b() instanceof ItemMolecule) {
            RecipeHandlerSynthesis.removeShapedRecipe(MinechemUtil.itemStackToChemical(stack));
        }
    }

    private static void removeShapedRecipe(PotionChemical recipeOutput) {
        RecipeSynthesisShaped recipe = RecipeHandlerSynthesis.getShapedRecipe(recipeOutput);
        if (recipe != null) {
            RecipeUtil.removeRecipe(recipe.getRegistryName());
        }
    }

    public static ISynthesisRecipe getRecipeFromOutput(ItemStack stack) {
        IForgeRegistryEntry.Impl recipe = null;
        recipe = RecipeHandlerSynthesis.getShapedRecipe(stack);
        if (recipe == null) {
            recipe = RecipeHandlerSynthesis.getShapelessRecipe(stack);
        }
        return recipe;
    }

    public static int getEnergyCost(ISynthesisRecipe recipe) {
        if (recipe instanceof RecipeSynthesisShaped) {
            return ((RecipeSynthesisShaped)recipe).getEnergyCost();
        }
        if (recipe instanceof RecipeSynthesisShapeless) {
            return ((RecipeSynthesisShapeless)recipe).getEnergyCost();
        }
        return 0;
    }

    public static boolean isShaped(ISynthesisRecipe recipe) {
        return recipe.isShaped();
    }

    public static boolean isShapeless(ISynthesisRecipe recipe) {
        return !recipe.isShaped();
    }

    public static PotionChemical[] getChemicalsFromRecipe(ISynthesisRecipe recipe) {
        PotionChemical[] returnArray = new PotionChemical[recipe.getIngredients().size()];
        NonNullList<ItemStack> stackList = RecipeUtil.getRecipeAsStackList(recipe);
        for (int i = 0; i < stackList.size(); ++i) {
            ItemStack stack = ((ItemStack)stackList.get(i)).func_77946_l();
            returnArray[i] = MinechemUtil.isStackAnElement(stack) ? new Element(MinechemUtil.getElement(stack)) : (MinechemUtil.isStackAMolecule(stack) ? new Molecule(MinechemUtil.getMolecule(stack)) : null);
        }
        return returnArray;
    }

    private static RecipeSynthesisShaped getShapedRecipe(PotionChemical recipeOutput) {
        int amount = 1;
        if (recipeOutput instanceof Element) {
            amount = ((Element)recipeOutput).amount;
        } else if (recipeOutput instanceof Molecule) {
            amount = ((Molecule)recipeOutput).amount;
        }
        return RecipeHandlerSynthesis.getShapedRecipe(MinechemUtil.chemicalToItemStack(recipeOutput, amount));
    }

    private static RecipeSynthesisShaped getShapedRecipe(ItemStack recipeOutput) {
        Set recipes = ModRegistries.SYNTHESIS_RECIPES.getEntries();
        for (Map.Entry recipeEntry : recipes) {
            ItemStack resultStack;
            ISynthesisRecipe recipe = (ISynthesisRecipe)recipeEntry.getValue();
            if (!(recipe instanceof RecipeSynthesisShaped) || !MinechemUtil.stacksAreSameKind(recipeOutput, resultStack = recipe.getRecipeOutput())) continue;
            return (RecipeSynthesisShaped)recipe;
        }
        return null;
    }

    private static RecipeSynthesisShapeless getShapelessRecipe(ItemStack recipeOutput) {
        Set recipes = ModRegistries.SYNTHESIS_RECIPES.getEntries();
        for (Map.Entry recipeEntry : recipes) {
            ItemStack resultStack;
            ISynthesisRecipe recipe = (ISynthesisRecipe)recipeEntry.getValue();
            if (!(recipe instanceof RecipeSynthesisShapeless) || !MinechemUtil.stacksAreSameKind(recipeOutput, resultStack = recipe.getRecipeOutput())) continue;
            return (RecipeSynthesisShapeless)recipe;
        }
        return null;
    }

    private static RecipeSynthesisShapeless getShapelessRecipe(PotionChemical recipeOutput) {
        int amount = 1;
        if (recipeOutput instanceof Element) {
            amount = ((Element)recipeOutput).amount;
        } else if (recipeOutput instanceof Molecule) {
            amount = ((Molecule)recipeOutput).amount;
        }
        return RecipeHandlerSynthesis.getShapelessRecipe(MinechemUtil.chemicalToItemStack(recipeOutput, amount));
    }

    public static void addShapelessOreDictRecipe(String item, int energyCost, PotionChemical ... chemicals) {
        NonNullList oreDictEntries = OreDictionary.getOres((String)item);
        Iterator itr = oreDictEntries.iterator();
        for (int entry = 0; itr.hasNext() && entry < 8; ++entry) {
            PotionChemical[] val = new PotionChemical[9];
            for (int i = 0; i < chemicals.length; ++i) {
                val[(i + entry) % 9] = chemicals[i];
            }
            ItemStack ore = (ItemStack)itr.next();
            RecipeHandlerSynthesis.addShapelessRecipe(ore.func_77973_b().func_77658_a(), energyCost, new ItemStack(ore.func_77973_b(), 1, ore.func_77952_i()), val);
        }
    }

    public static void addShapedOreDictRecipe(String item, int energyCost, PotionChemical ... chemicals) {
        NonNullList oreDictEntries = OreDictionary.getOres((String)item);
        if (!oreDictEntries.isEmpty()) {
            ItemStack ore = (ItemStack)oreDictEntries.get(0);
            ResourceLocation regName = ore.func_77973_b().getRegistryName();
            RecipeHandlerSynthesis.addShapedRecipe(regName.func_110624_b() + "_" + regName.func_110623_a() + "_" + ore.func_77952_i(), energyCost, new ItemStack(ore.func_77973_b(), 1, ore.func_77952_i()), RecipeHandlerSynthesis.createShapedObject(chemicals));
        }
    }

    private static Object[] createShapedObject(PotionChemical[] chemicals) {
        int i;
        int currentSymbolIndex = 97;
        String[] pattern = new String[3];
        ArrayList<Object> symbolDefs = new ArrayList<Object>();
        for (int i2 = 0; i2 < 3; ++i2) {
            String rowStr = "";
            for (int j = 0; j < 3; ++j) {
                if (chemicals[j + i2 * 3] == null) {
                    rowStr = rowStr + " ";
                    continue;
                }
                rowStr = rowStr + (char)currentSymbolIndex;
                symbolDefs.add(Character.valueOf((char)currentSymbolIndex));
                symbolDefs.add(chemicals[j + i2 * 3]);
                ++currentSymbolIndex;
            }
            pattern[i2] = rowStr;
        }
        Object[] returnObject = new Object[pattern.length + symbolDefs.size()];
        for (i = 0; i < 3; ++i) {
            returnObject[i] = pattern[i];
        }
        for (i = 3; i < symbolDefs.size() + 3; ++i) {
            returnObject[i] = symbolDefs.get(i - 3);
        }
        return returnObject;
    }

    public void accountStack(ItemStack stack) {
        this.accountStack(stack, -1);
    }

    public void accountStack(ItemStack stack, int forceCount) {
        if (!(stack.func_190926_b() || stack.func_77951_h() || stack.func_77948_v() || stack.func_82837_s())) {
            int i = RecipeHandlerSynthesis.pack(stack);
            int j = forceCount == -1 ? stack.func_190916_E() : forceCount;
            this.increment(i, j);
        }
    }

    public static int pack(ItemStack stack) {
        Item item = stack.func_77973_b();
        int i = item.func_77614_k() ? stack.func_77960_j() : 0;
        return Item.field_150901_e.func_148757_b((Object)item) << 16 | i & 0xFFFF;
    }

    public boolean containsItem(int p_194120_1_) {
        return this.itemToCount.get(p_194120_1_) > 0;
    }

    public int tryTake(int p_194122_1_, int maximum) {
        int i = this.itemToCount.get(p_194122_1_);
        if (i >= maximum) {
            this.itemToCount.put(p_194122_1_, i - maximum);
            return p_194122_1_;
        }
        return 0;
    }

    private void increment(int p_194117_1_, int amount) {
        this.itemToCount.put(p_194117_1_, this.itemToCount.get(p_194117_1_) + amount);
    }

    public boolean canCraft(ISynthesisRecipe recipe, @Nullable IntList p_194116_2_) {
        return this.canCraft(recipe, p_194116_2_, 1);
    }

    public boolean canCraft(ISynthesisRecipe recipe, @Nullable IntList p_194118_2_, int p_194118_3_) {
        return new RecipePicker(recipe).tryPick(p_194118_3_, p_194118_2_);
    }

    public int getBiggestCraftableStack(ISynthesisRecipe recipe, @Nullable IntList p_194114_2_) {
        return this.getBiggestCraftableStack(recipe, Integer.MAX_VALUE, p_194114_2_);
    }

    public int getBiggestCraftableStack(ISynthesisRecipe recipe, int p_194121_2_, @Nullable IntList p_194121_3_) {
        return new RecipePicker(recipe).tryPickAll(p_194121_2_, p_194121_3_);
    }

    public static ItemStack unpack(int p_194115_0_) {
        return p_194115_0_ == 0 ? ItemStack.field_190927_a : new ItemStack(Item.func_150899_d((int)(p_194115_0_ >> 16 & 0xFFFF)), 1, p_194115_0_ & 0xFFFF);
    }

    public void clear() {
        this.itemToCount.clear();
    }

    public static class SynthesisRecipeCallbacks
    implements IForgeRegistry.MissingFactory<ISynthesisRecipe> {
        public static final SynthesisRecipeCallbacks INSTANCE = new SynthesisRecipeCallbacks();

        public ISynthesisRecipe createMissing(ResourceLocation key, boolean isNetwork) {
            return isNetwork ? new DummyRecipe().setRegistryName(key) : null;
        }

        private static class DummyRecipe
        implements ISynthesisRecipe {
            private static ItemStack result = ItemStack.field_190927_a;
            private ResourceLocation name;

            private DummyRecipe() {
            }

            public ISynthesisRecipe setRegistryName(ResourceLocation name) {
                this.name = name;
                return this;
            }

            public ResourceLocation getRegistryName() {
                return this.name;
            }

            public Class<ISynthesisRecipe> getRegistryType() {
                return ISynthesisRecipe.class;
            }

            @Override
            public boolean matches(InventoryCrafting inv, World worldIn) {
                return false;
            }

            @Override
            public ItemStack getCraftingResult(InventoryCrafting inv) {
                return result;
            }

            @Override
            public boolean canFit(int width, int height) {
                return false;
            }

            @Override
            public ItemStack getRecipeOutput() {
                return result;
            }

            @Override
            public boolean isDynamic() {
                return true;
            }

            @Override
            public int getEnergyCost() {
                return 0;
            }
        }
    }

    class RecipePicker {
        private final ISynthesisRecipe recipe;
        private final List<SingleItemStackBasedIngredient> ingredients = Lists.newArrayList();
        private final int ingredientCount;
        private final int[] possessedIngredientStacks;
        private final int possessedIngredientStackCount;
        private final BitSet data;
        private IntList path = new IntArrayList();

        public RecipePicker(ISynthesisRecipe p_i47608_2_) {
            this.recipe = p_i47608_2_;
            this.ingredients.addAll((Collection<SingleItemStackBasedIngredient>)p_i47608_2_.getSingleIngredients());
            this.ingredients.removeIf(p_194103_0_ -> p_194103_0_ == SingleItemStackBasedIngredient.EMPTY);
            this.ingredientCount = this.ingredients.size();
            this.possessedIngredientStacks = this.getUniqueAvailIngredientItems();
            this.possessedIngredientStackCount = this.possessedIngredientStacks.length;
            this.data = new BitSet(this.ingredientCount + this.possessedIngredientStackCount + this.ingredientCount + this.ingredientCount * this.possessedIngredientStackCount);
            for (int i = 0; i < this.ingredients.size(); ++i) {
                IntList intlist = this.ingredients.get(i).func_194139_b();
                for (int j = 0; j < this.possessedIngredientStackCount; ++j) {
                    if (!intlist.contains(this.possessedIngredientStacks[j])) continue;
                    this.data.set(this.getIndex(true, j, i));
                }
            }
        }

        public boolean tryPick(int p_194092_1_, @Nullable IntList listIn) {
            boolean flag1;
            if (p_194092_1_ <= 0) {
                return true;
            }
            int k = 0;
            while (this.dfs(p_194092_1_)) {
                RecipeHandlerSynthesis.this.tryTake(this.possessedIngredientStacks[this.path.getInt(0)], p_194092_1_);
                int l = this.path.size() - 1;
                this.setSatisfied(this.path.getInt(l));
                for (int i1 = 0; i1 < l; ++i1) {
                    this.toggleResidual((i1 & 1) == 0, (Integer)this.path.get(i1), (Integer)this.path.get(i1 + 1));
                }
                this.path.clear();
                this.data.clear(0, this.ingredientCount + this.possessedIngredientStackCount);
                ++k;
            }
            boolean flag = k == this.ingredientCount;
            boolean bl = flag1 = flag && listIn != null;
            if (flag1) {
                listIn.clear();
            }
            this.data.clear(0, this.ingredientCount + this.possessedIngredientStackCount + this.ingredientCount);
            int j1 = 0;
            NonNullList<SingleItemStackBasedIngredient> list = this.recipe.getSingleIngredients();
            for (int k1 = 0; k1 < list.size(); ++k1) {
                if (flag1 && list.get(k1) == SingleItemStackBasedIngredient.EMPTY) {
                    listIn.add(0);
                    continue;
                }
                for (int l1 = 0; l1 < this.possessedIngredientStackCount; ++l1) {
                    if (!this.hasResidual(false, j1, l1)) continue;
                    this.toggleResidual(true, l1, j1);
                    RecipeHandlerSynthesis.this.increment(this.possessedIngredientStacks[l1], p_194092_1_);
                    if (!flag1) continue;
                    listIn.add(this.possessedIngredientStacks[l1]);
                }
                ++j1;
            }
            return flag;
        }

        private int[] getUniqueAvailIngredientItems() {
            IntAVLTreeSet intcollection = new IntAVLTreeSet();
            for (SingleItemStackBasedIngredient ingredient : this.ingredients) {
                intcollection.addAll((IntCollection)ingredient.func_194139_b());
            }
            IntIterator intiterator = intcollection.iterator();
            while (intiterator.hasNext()) {
                if (RecipeHandlerSynthesis.this.containsItem(intiterator.nextInt())) continue;
                intiterator.remove();
            }
            return intcollection.toIntArray();
        }

        private boolean dfs(int p_194098_1_) {
            int k = this.possessedIngredientStackCount;
            for (int l = 0; l < k; ++l) {
                if (RecipeHandlerSynthesis.this.itemToCount.get(this.possessedIngredientStacks[l]) < p_194098_1_) continue;
                this.visit(false, l);
                while (!this.path.isEmpty()) {
                    int i2;
                    int i1 = this.path.size();
                    boolean flag = (i1 & 1) == 1;
                    int j1 = this.path.getInt(i1 - 1);
                    if (!flag && !this.isSatisfied(j1)) break;
                    int k1 = flag ? this.ingredientCount : k;
                    for (int l1 = 0; l1 < k1; ++l1) {
                        if (this.hasVisited(flag, l1) || !this.hasConnection(flag, j1, l1) || !this.hasResidual(flag, j1, l1)) continue;
                        this.visit(flag, l1);
                        break;
                    }
                    if ((i2 = this.path.size()) != i1) continue;
                    this.path.removeInt(i2 - 1);
                }
                if (this.path.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private boolean isSatisfied(int p_194091_1_) {
            return this.data.get(this.getSatisfiedIndex(p_194091_1_));
        }

        private void setSatisfied(int p_194096_1_) {
            this.data.set(this.getSatisfiedIndex(p_194096_1_));
        }

        private int getSatisfiedIndex(int p_194094_1_) {
            return this.ingredientCount + this.possessedIngredientStackCount + p_194094_1_;
        }

        private boolean hasConnection(boolean p_194093_1_, int p_194093_2_, int p_194093_3_) {
            return this.data.get(this.getIndex(p_194093_1_, p_194093_2_, p_194093_3_));
        }

        private boolean hasResidual(boolean p_194100_1_, int p_194100_2_, int p_194100_3_) {
            return p_194100_1_ != this.data.get(1 + this.getIndex(p_194100_1_, p_194100_2_, p_194100_3_));
        }

        private void toggleResidual(boolean p_194089_1_, int p_194089_2_, int p_194089_3_) {
            this.data.flip(1 + this.getIndex(p_194089_1_, p_194089_2_, p_194089_3_));
        }

        private int getIndex(boolean p_194095_1_, int p_194095_2_, int p_194095_3_) {
            int k = p_194095_1_ ? p_194095_2_ * this.ingredientCount + p_194095_3_ : p_194095_3_ * this.ingredientCount + p_194095_2_;
            return this.ingredientCount + this.possessedIngredientStackCount + this.ingredientCount + 2 * k;
        }

        private void visit(boolean p_194088_1_, int p_194088_2_) {
            this.data.set(this.getVisitedIndex(p_194088_1_, p_194088_2_));
            this.path.add(p_194088_2_);
        }

        private boolean hasVisited(boolean p_194101_1_, int p_194101_2_) {
            return this.data.get(this.getVisitedIndex(p_194101_1_, p_194101_2_));
        }

        private int getVisitedIndex(boolean p_194099_1_, int p_194099_2_) {
            return (p_194099_1_ ? 0 : this.ingredientCount) + p_194099_2_;
        }

        public int tryPickAll(int p_194102_1_, @Nullable IntList list) {
            int k = 0;
            int l = Math.min(p_194102_1_, this.getMinIngredientCount()) + 1;
            while (true) {
                int i1;
                if (this.tryPick(i1 = (k + l) / 2, null)) {
                    if (l - k <= 1) {
                        if (i1 > 0) {
                            this.tryPick(i1, list);
                        }
                        return i1;
                    }
                    k = i1;
                    continue;
                }
                l = i1;
            }
        }

        private int getMinIngredientCount() {
            int k = Integer.MAX_VALUE;
            for (SingleItemStackBasedIngredient ingredient : this.ingredients) {
                int l = 0;
                IntListIterator intlistiterator = ingredient.func_194139_b().iterator();
                while (intlistiterator.hasNext()) {
                    int i1 = (Integer)intlistiterator.next();
                    l = Math.max(l, RecipeHandlerSynthesis.this.itemToCount.get(i1));
                }
                if (k <= 0) continue;
                k = Math.min(k, l);
            }
            return k;
        }
    }
}

