/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import minechem.init.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.ArrayUtils;

public class Blueprint {
    public static IBlockState A = ModBlocks.reactor_core.func_176203_a(1);
    public static IBlockState B = ModBlocks.reactor_wall.func_176203_a(1);
    public static IBlockState C = ModBlocks.tungsten_plating.func_176203_a(2);
    public static IBlockState D = Blocks.field_150350_a.func_176223_P();
    public static Blueprint FISSION_REACTOR = new Blueprint(new IBlockState[][][]{{{A, A, A, A, A}, {A, A, A, A, A}, {A, A, A, A, A}, {A, A, A, A, A}, {A, A, A, A, A}}, {{A, A, A, A, A}, {A, D, D, D, A}, {A, D, D, D, A}, {A, D, D, D, A}, {A, A, A, A, A}}, {{A, A, A, A, A}, {A, D, D, D, A}, {A, D, C, D, A}, {A, D, D, D, A}, {A, A, A, A, A}}, {{A, A, A, A, A}, {A, D, D, D, A}, {A, D, D, D, A}, {A, D, D, D, A}, {A, A, A, A, A}}, {{A, A, A, A, A}, {A, A, A, A, A}, {A, A, A, A, A}, {A, A, A, A, A}, {A, A, A, A, A}}});
    private final IBlockState[][][] states;

    public Blueprint(IBlockState[][][] statesToPlace) {
        this.states = statesToPlace;
    }

    public Blueprint(Block[][][] blocks) {
        IBlockState[][][] states = new IBlockState[blocks.length][][];
        for (int i = 0; i < blocks.length; ++i) {
            states[i] = new IBlockState[blocks[i].length][];
            for (int j = 0; j < blocks[i].length; ++j) {
                states[i][j] = new IBlockState[blocks[i][j].length];
                for (int k = 0; k < blocks[i][j].length; ++k) {
                    states[i][j][k] = blocks[i][j][k] == null ? null : blocks[i][j][k].func_176223_P();
                }
            }
        }
        this.states = states;
    }

    public IBlockState[][][] getReverseVerticalArray() {
        IBlockState[][][] newStates = this.states;
        ArrayUtils.reverse((Object[])newStates);
        return newStates;
    }

    public void placeStateArray(BlockPos pos, World world) {
        this.placeStateArray(pos, world, EnumFacing.NORTH);
    }

    public void placeStateArray(BlockPos pos, World world, EnumFacing facing) {
        int xOffset = 0;
        int zOffset = 0;
        for (int y = 0; y < this.states.length; ++y) {
            for (int x = 0; x < this.states[y].length; ++x) {
                for (int z = 0; z < this.states[y][x].length; ++z) {
                    if (this.states[y][x][z] == null) continue;
                    switch (facing) {
                        case NORTH: {
                            xOffset = 0;
                            zOffset = -(this.states[y][x].length - 1);
                            break;
                        }
                        case SOUTH: {
                            xOffset = -(this.states[y][x].length - 1);
                            zOffset = 0;
                            break;
                        }
                        case WEST: {
                            xOffset = -(this.states[y][x].length - 1);
                            zOffset = -(this.states[y][x].length - 1);
                            break;
                        }
                    }
                    world.func_175656_a(pos.func_177982_a(x + xOffset, y, z + zOffset), this.states[y][x][z]);
                }
            }
        }
    }

    public void visualiseStateArray(BlockPos pos, World world) {
        this.visualiseStateArray(pos, world, EnumFacing.NORTH, -1);
    }

    public void visualiseStateArray(BlockPos pos, World world, EnumFacing facing) {
        this.visualiseStateArray(pos, world, facing, -1);
    }

    public int getTotalVerticalSlices() {
        return this.states[0][0].length;
    }

    public IBlockState[] getVerticalSliceFromBlueprint(int layer) {
        IBlockState[] vertStates = new IBlockState[this.states[0].length * this.states.length];
        if (layer < 0) {
            return vertStates;
        }
        for (int y = 0; y < this.states.length; ++y) {
            for (int x = 0; x < this.states[y].length; ++x) {
                for (int z = 0; z < this.states[y][x].length; ++z) {
                    if (this.states[y][x][z] == null || z != -1 && z != layer) continue;
                    vertStates[y + x * this.states.length] = this.states[y][x][z];
                }
            }
        }
        return vertStates;
    }

    public boolean isStructureBuilt(BlockPos pos, World world, EnumFacing facing) {
        int total = this.getTotalVerticalSlices();
        for (int i = 0; i < total; ++i) {
            if (this.isVerticalSliceBuilt(pos, world, facing, i)) continue;
            return false;
        }
        return true;
    }

    public int getXSize() {
        return this.states[0].length;
    }

    public int getZSize() {
        return this.states[0][0].length;
    }

    public boolean isVerticalSliceBuilt(BlockPos pos, World world, EnumFacing facing, int layer) {
        if (layer < 0) {
            return true;
        }
        IBlockState[] requiredSlice = this.getVerticalSliceFromBlueprint(layer);
        int xOffset = 0;
        int zOffset = 0;
        IBlockState[][][] statesToUse = facing.func_176734_d() == EnumFacing.NORTH || facing.func_176734_d() == EnumFacing.EAST ? this.states : this.getReverseVerticalArray();
        for (int y = 0; y < statesToUse.length; ++y) {
            for (int x = 0; x < statesToUse[y].length; ++x) {
                for (int z = 0; z < statesToUse[y][x].length; ++z) {
                    IBlockState required;
                    IBlockState current;
                    int comparingLayer;
                    if (statesToUse[y][x][z] == null) continue;
                    int n = comparingLayer = facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH ? z : x;
                    if (comparingLayer != layer) continue;
                    BlockPos newPos = pos.func_177982_a(x + xOffset, y, z + zOffset);
                    switch (facing.func_176734_d()) {
                        case NORTH: {
                            xOffset = 0;
                            zOffset = -(statesToUse[y][x].length - 1);
                            newPos = pos.func_177982_a(x + xOffset - statesToUse[y][x].length / 2, y, z + zOffset - 2);
                            break;
                        }
                        case SOUTH: {
                            xOffset = -(statesToUse[y][x].length - 1);
                            zOffset = 0;
                            newPos = pos.func_177982_a(-(x + xOffset + statesToUse[y][x].length / 2), y, -(z + 2) + statesToUse[y][x].length * 2 - 2);
                            break;
                        }
                        case WEST: {
                            xOffset = -(statesToUse[y][x].length - 1);
                            zOffset = -(statesToUse[y][x].length - 1);
                            newPos = pos.func_177982_a(-(x + 2 + statesToUse[y][x].length / 2) - 2, y, -(z + zOffset + statesToUse[y][x].length / 2));
                            break;
                        }
                        case EAST: {
                            newPos = pos.func_177982_a(x + xOffset + statesToUse[y][x].length / 2, y, z + zOffset - 2);
                        }
                    }
                    if (requiredSlice[z] == null || (current = world.func_180495_p(newPos)) == (required = requiredSlice[statesToUse[y][x].length - 1 - x + y * statesToUse.length])) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void visualiseStateArray(BlockPos pos, World world, EnumFacing facing, int layer) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)1);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            int xOffset = 0;
            int zOffset = 0;
            IBlockState[][][] statesToUse = facing.func_176734_d() == EnumFacing.NORTH || facing.func_176734_d() == EnumFacing.EAST ? this.states : this.getReverseVerticalArray();
            for (int y = 0; y < statesToUse.length; ++y) {
                for (int x = 0; x < statesToUse[y].length; ++x) {
                    for (int z = 0; z < statesToUse[y][x].length; ++z) {
                        int comparingLayer;
                        if (statesToUse[y][x][z] == null) continue;
                        int n = comparingLayer = facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH ? z : x;
                        if (layer != -1 && comparingLayer != layer) continue;
                        BlockPos newPos = pos.func_177982_a(x + xOffset, y, z + zOffset);
                        switch (facing.func_176734_d()) {
                            case NORTH: {
                                zOffset = -(statesToUse[y][x].length - 1);
                                newPos = pos.func_177982_a(x - statesToUse[y][x].length / 2, y, z + zOffset - 2);
                                break;
                            }
                            case SOUTH: {
                                xOffset = -(statesToUse[y][x].length - 1);
                                newPos = pos.func_177982_a(-(x + xOffset + statesToUse[y][x].length / 2), y, -(z + 2) + statesToUse[y][x].length * 2 - 2);
                                break;
                            }
                            case WEST: {
                                xOffset = -(statesToUse[y][x].length - 1);
                                zOffset = -(this.states[y][x].length - 1);
                                newPos = pos.func_177982_a(-(x + 2 + statesToUse[y][x].length / 2) - 2, y, -(z + zOffset + statesToUse[y][x].length / 2));
                                break;
                            }
                            case EAST: {
                                newPos = pos.func_177982_a(x + xOffset + statesToUse[y][x].length / 2, y, z - 2);
                            }
                        }
                        if (world.func_180495_p(newPos).func_177230_c() != Blocks.field_150350_a) continue;
                        Minecraft.func_71410_x().func_175602_ab().func_175018_a(statesToUse[y][x][z], newPos, (IBlockAccess)world, vertexbuffer);
                    }
                }
            }
            GlStateManager.func_179094_E();
            Blueprint.removeStandartTranslationFromTESRMatrix();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
        }
    }

    public static void removeStandartTranslationFromTESRMatrix() {
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        Entity rView = Minecraft.func_71410_x().func_175606_aa();
        if (rView == null) {
            rView = Minecraft.func_71410_x().field_71439_g;
        }
        Entity entity = rView;
        double tx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double ty = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double tz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179137_b((double)(-tx), (double)(-ty), (double)(-tz));
    }
}

