/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import minechem.api.IMinechemBlueprint;
import minechem.block.tile.TileBlueprintProjector;
import minechem.init.ModItems;
import minechem.init.ModRegistries;
import minechem.utils.LocalPosition;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class BlueprintUtil {
    public static int structureRenderTicks = 0;
    public static MultiblockBlockAccess blockAccess;
    public static int currentLayer;

    public static IMinechemBlueprint getBlueprint(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_150297_b("Blueprint", 8)) {
            ResourceLocation regName = new ResourceLocation(nbt.func_74779_i("Blueprint"));
            return (IMinechemBlueprint)ModRegistries.MINECHEM_BLUEPRINTS.getValue(regName);
        }
        return null;
    }

    public static ItemStack createStack(IMinechemBlueprint blueprint) {
        ItemStack blueprintStack = new ItemStack((Item)ModItems.blueprint);
        if (!blueprintStack.func_77942_o()) {
            blueprintStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = blueprintStack.func_77978_p();
        nbt.func_74778_a("Blueprint", "");
        if (blueprint == null) {
            nbt.func_82580_o("Blueprint");
        } else {
            nbt.func_74778_a("Blueprint", blueprint.getRegistryName().toString());
        }
        return blueprintStack;
    }

    public static boolean isBlueprintBlank(ItemStack blueprint) {
        NBTTagCompound nbt;
        if (blueprint.func_77942_o() && (nbt = blueprint.func_77978_p()).func_150297_b("Blueprint", 8)) {
            String regName = nbt.func_74779_i("Blueprint");
            return regName.isEmpty();
        }
        return true;
    }

    public static List<IMinechemBlueprint> getAllBlueprints() {
        return ModRegistries.MINECHEM_BLUEPRINTS.getValues();
    }

    public static NonNullList<ItemStack> getAllBlueprintsAsStacks() {
        NonNullList stackList = NonNullList.func_191196_a();
        for (IMinechemBlueprint blueprint : BlueprintUtil.getAllBlueprints()) {
            stackList.add((Object)BlueprintUtil.createStack(blueprint));
        }
        return stackList;
    }

    public static Pair<IMinechemBlueprint, EnumFacing> getBlueprintFromStructure(World world, BlockPos pos) {
        List bpList = ModRegistries.MINECHEM_BLUEPRINTS.getValues();
        for (IMinechemBlueprint bp : bpList) {
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                LocalPosition position = new LocalPosition(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), facing);
                position.moveForwards(Math.floor(bp.xSize() / 2));
                position.moveLeft(Math.floor(bp.zSize() / 2));
                position.moveDown(Math.floor(bp.ySize() / 2));
                LocalPosition.Pos3 worldPos = position.getLocalPos(pos);
                if (!BlueprintUtil.isStructureComplete(bp, facing, world, pos)) continue;
                return Pair.of((Object)bp, (Object)facing);
            }
        }
        return null;
    }

    public static boolean isStructureComplete(World world, BlockPos pos) {
        return BlueprintUtil.getBlueprintFromStructure(world, pos) != null;
    }

    public static boolean isStructureComplete(IMinechemBlueprint blueprint, EnumFacing structureFacing, World world, BlockPos pos) {
        if (blueprint == null || structureFacing == null || world == null || pos == null) {
            return false;
        }
        LocalPosition position = new LocalPosition(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), structureFacing);
        position.moveForwards(Math.floor(blueprint.zSize() / 2));
        position.moveRight(Math.floor(blueprint.xSize() / 2));
        position.moveDown(Math.floor(blueprint.ySize() / 2));
        IBlockState[][][] resultStructure = blueprint.getStructure();
        for (int x = 0; x < blueprint.xSize(); ++x) {
            for (int y = 0; y < blueprint.ySize(); ++y) {
                for (int z = 0; z < blueprint.zSize(); ++z) {
                    if (x == blueprint.getManagerPosX() && y == blueprint.getManagerPosY() && z == blueprint.getManagerPosZ()) continue;
                    LocalPosition.Pos3 worldPos = position.getLocalPos(new BlockPos(x, y, z));
                    BlockPos wPos = new BlockPos(pos.func_177958_n() - blueprint.getManagerPosX() + x, pos.func_177956_o() - blueprint.getManagerPosY() + y, pos.func_177952_p() - blueprint.getManagerPosZ() + z);
                    IBlockState bpState = resultStructure[y][x][z];
                    IBlockState worldState = world.func_180495_p(wPos);
                    Block bpBlock = bpState.func_177230_c();
                    Block worldBlock = worldState.func_177230_c();
                    int bpMeta = bpBlock.func_176201_c(bpState);
                    int worldMeta = worldBlock.func_176201_c(worldState);
                    if (bpBlock == worldBlock && bpMeta == worldMeta) continue;
                    worldState = world.func_180495_p(new BlockPos(worldPos.x, worldPos.y, worldPos.z));
                    worldBlock = worldState.func_177230_c();
                    worldMeta = worldBlock.func_176201_c(worldState);
                    if (bpBlock == worldBlock && bpMeta == worldMeta) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderStructureOnScreen(IMinechemBlueprint blueprint, int x, int y, int mx, int my, float rotX, float rotY, int scale) {
        boolean openBuffer = false;
        int stackDepth = GL11.glGetInteger((int)2979);
        try {
            int structureLength = blueprint.zSize();
            int structureWidth = blueprint.xSize();
            int structureHeight = blueprint.ySize();
            double squirt = Math.sqrt(structureHeight * structureHeight + structureWidth * structureWidth + structureLength * structureLength);
            float transX = x + 40 + blueprint.getXOffset();
            float transY = y + 0 + blueprint.getYOffset();
            int yOffTotal = (int)((double)(transY - (float)y) + (double)scale * squirt / 2.0);
            GlStateManager.func_179091_B();
            GlStateManager.func_179094_E();
            RenderHelper.func_74518_a();
            boolean i = false;
            ItemStack highlighted = ItemStack.field_190927_a;
            BlockRendererDispatcher blockRender = Minecraft.func_71410_x().func_175602_ab();
            float f = (float)Math.sqrt(structureHeight * structureHeight + structureWidth * structureWidth + structureLength * structureLength);
            GlStateManager.func_179109_b((float)transX, (float)transY, (float)Math.max(structureHeight, Math.max(structureWidth, structureLength)));
            GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)1.0f);
            GlStateManager.func_179114_b((float)rotX, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(90.0f + rotY), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)((float)structureLength / -2.0f), (float)((float)structureHeight / -2.0f), (float)((float)structureWidth / -2.0f));
            GlStateManager.func_179140_f();
            if (Minecraft.func_71379_u()) {
                GlStateManager.func_179103_j((int)7425);
            } else {
                GlStateManager.func_179103_j((int)7424);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            boolean idx = false;
            for (int h = 0; h < structureHeight; ++h) {
                for (int l = 0; l < structureLength; ++l) {
                    for (int w = 0; w < structureWidth; ++w) {
                        BlockPos pos = new BlockPos(l, h, w);
                        if (blockAccess == null || blockAccess.func_175623_d(pos)) continue;
                        GlStateManager.func_179109_b((float)l, (float)h, (float)w);
                        GlStateManager.func_179109_b((float)(-l), (float)(-h), (float)(-w));
                        IBlockState state = blockAccess.func_180495_p(pos);
                        Tessellator tessellator = Tessellator.func_178181_a();
                        BufferBuilder buffer = tessellator.func_178180_c();
                        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                        openBuffer = true;
                        blockRender.func_175018_a(state, pos, (IBlockAccess)blockAccess, buffer);
                        tessellator.func_78381_a();
                        openBuffer = false;
                    }
                }
            }
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
            GlStateManager.func_179101_C();
            GlStateManager.func_179147_l();
            RenderHelper.func_74518_a();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (openBuffer) {
            try {
                Tessellator.func_178181_a().func_78381_a();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (int newStackDepth = GL11.glGetInteger((int)2979); newStackDepth > stackDepth; --newStackDepth) {
            GlStateManager.func_179121_F();
        }
    }

    public final ItemStack[][][] convertToStacks(IMinechemBlueprint blueprint) {
        IBlockState[][][] schematicArray = blueprint.getStructure();
        ItemStack[][][] stackArray = new ItemStack[][][]{};
        for (int xIndex = 0; xIndex < schematicArray.length; ++xIndex) {
            for (int yIndex = 0; yIndex < schematicArray[xIndex].length; ++yIndex) {
                for (int zIndex = 0; zIndex < schematicArray[xIndex][yIndex].length; ++zIndex) {
                    if (stackArray[xIndex][yIndex][zIndex] != null) continue;
                    IBlockState currentState = schematicArray[xIndex][yIndex][zIndex];
                    int meta = currentState.func_177230_c().func_176201_c(currentState);
                    stackArray[xIndex][yIndex][zIndex] = new ItemStack(currentState.func_177230_c(), 1, meta);
                }
            }
        }
        return stackArray;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderBlueprintInWorld(TileBlueprintProjector te) {
        if (te.func_145831_w() != null && te.hasBlueprint()) {
            WorldProxy proxy = new WorldProxy((IBlockAccess)te.func_145831_w(), 15);
            BlockPos tilePos = te.func_174877_v();
            int xCoord = tilePos.func_177958_n();
            int yCoord = tilePos.func_177956_o();
            int zCoord = tilePos.func_177952_p();
            EnumFacing dir = EnumFacing.field_176754_o[te.func_145832_p() - 2];
            IBlockState[][][] schematicArray = te.getBlueprint().getStructure();
            for (int xIndex = 0; xIndex < schematicArray.length; ++xIndex) {
                for (int yIndex = 0; yIndex < schematicArray[xIndex].length; ++yIndex) {
                    for (int zIndex = 0; zIndex < schematicArray[xIndex][yIndex].length; ++zIndex) {
                        int zRender;
                        int xRender;
                        int yRender = yCoord + yIndex;
                        if (dir.func_82601_c() > 0) {
                            xRender = xCoord + xIndex * -1 + dir.func_82601_c() + schematicArray.length;
                            zRender = zCoord + zIndex - schematicArray[xIndex][yIndex].length / 2;
                        } else if (dir.func_82601_c() < 0) {
                            xRender = xCoord + xIndex + dir.func_82601_c() - schematicArray.length;
                            zRender = zCoord + zIndex * -1 + schematicArray[xIndex][yIndex].length / 2;
                        } else if (dir.func_82599_e() > 0) {
                            xRender = xCoord + zIndex * -1 + schematicArray[xIndex][yIndex].length / 2;
                            zRender = zCoord + xIndex * -1 + dir.func_82599_e() + schematicArray.length;
                        } else {
                            xRender = xCoord + zIndex - schematicArray[xIndex][yIndex].length / 2;
                            zRender = zCoord + xIndex + dir.func_82599_e() - schematicArray.length;
                        }
                        proxy.setCoordinates(xRender, yRender, zRender);
                        IBlockState currentState = schematicArray[xIndex][yIndex][zIndex];
                        proxy.setBlockMetadata(currentState.func_177230_c().func_176201_c(currentState));
                        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
                        BlockPos blockPos = te.func_174877_v();
                        IBakedModel model = blockRenderer.func_175023_a().func_178125_b(currentState);
                        Tessellator tessellator = Tessellator.func_178181_a();
                        BufferBuilder worldRenderer = tessellator.func_178180_c();
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179137_b((double)((double)xCoord + 0.5), (double)((double)yCoord + 0.5), (double)((double)zCoord + 0.5));
                        RenderHelper.func_74518_a();
                        GlStateManager.func_179112_b((int)770, (int)771);
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179129_p();
                        if (Minecraft.func_71379_u()) {
                            GL11.glShadeModel((int)7425);
                        } else {
                            GL11.glShadeModel((int)7424);
                        }
                        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                        worldRenderer.func_178969_c(-0.5 - (double)blockPos.func_177958_n(), -0.5 - (double)blockPos.func_177956_o(), -0.5 - (double)blockPos.func_177952_p());
                        worldRenderer.func_181669_b(255, 255, 255, 255);
                        blockRenderer.func_175019_b().func_178267_a((IBlockAccess)te.func_145831_w(), model, currentState, blockPos, worldRenderer, true);
                        worldRenderer.func_178969_c(0.0, 0.0, 0.0);
                        tessellator.func_78381_a();
                        RenderHelper.func_74519_b();
                        GlStateManager.func_179121_F();
                    }
                }
            }
        }
    }

    static {
        currentLayer = 0;
    }

    public static class WorldProxy
    implements IBlockAccess {
        IBlockAccess world;
        int meta;
        int brightness;
        int x;
        int y;
        int z;

        public WorldProxy(IBlockAccess world, int brightness) {
            this.world = world;
            this.setBlockMetadata(0);
            this.brightness = brightness;
        }

        public void setCoordinates(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public final void setBlockMetadata(int meta) {
            this.meta = meta;
        }

        public TileEntity func_175625_s(BlockPos pos) {
            return null;
        }

        public int func_175626_b(BlockPos pos, int lightValue) {
            return 0;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            return null;
        }

        public boolean func_175623_d(BlockPos pos) {
            return false;
        }

        public Biome func_180494_b(BlockPos pos) {
            return null;
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return 0;
        }

        public WorldType func_175624_G() {
            return null;
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return true;
        }
    }

    public static class MultiblockRenderInfo {
        public IMinechemBlueprint multiblock;
        public IBlockState[][][] data;
        public int blockCount = 0;
        public int[] countPerLevel;
        public int structureHeight = 0;
        public int structureLength = 0;
        public int structureWidth = 0;
        public int showLayer = -1;
        private int blockIndex = -1;
        private int maxBlockIndex;

        public MultiblockRenderInfo(IMinechemBlueprint multiblock) {
            this.multiblock = multiblock;
            this.init(multiblock.getStructure());
            this.maxBlockIndex = this.blockIndex = this.structureHeight * this.structureLength * this.structureWidth;
        }

        public void init(IBlockState[][][] structure) {
            this.data = structure;
            this.structureHeight = structure.length;
            this.structureWidth = 0;
            this.structureLength = 0;
            this.countPerLevel = new int[this.structureHeight];
            this.blockCount = 0;
            for (int h = 0; h < structure.length; ++h) {
                if (structure[h].length > this.structureLength) {
                    this.structureLength = structure[h].length;
                }
                int perLvl = 0;
                for (int l = 0; l < structure[h].length; ++l) {
                    if (structure[h][l].length > this.structureWidth) {
                        this.structureWidth = structure[h][l].length;
                    }
                    for (IBlockState ss : structure[h][l]) {
                        if (ss == null) continue;
                        ++perLvl;
                    }
                }
                this.countPerLevel[h] = perLvl;
                this.blockCount += perLvl;
            }
        }

        public void setShowLayer(int layer) {
            this.showLayer = layer;
            if (layer < 0) {
                this.reset();
            } else {
                this.blockIndex = (layer + 1) * (this.structureLength * this.structureWidth) - 1;
            }
        }

        public void reset() {
            this.blockIndex = this.maxBlockIndex;
        }

        public void step() {
            int start = this.blockIndex;
            do {
                if (++this.blockIndex < this.maxBlockIndex) continue;
                this.blockIndex = 0;
            } while (this.isEmpty(this.blockIndex) && this.blockIndex != start);
        }

        private boolean isEmpty(int index) {
            int y = index / (this.structureLength * this.structureWidth);
            int r = index % (this.structureLength * this.structureWidth);
            int x = r / this.structureWidth;
            int z = r % this.structureWidth;
            IBlockState stack = this.data[y][x][z];
            return stack == null;
        }

        public int getLimiter() {
            return this.blockIndex;
        }
    }

    public static class MultiblockBlockAccess
    implements IBlockAccess {
        public final MultiblockRenderInfo data;
        private final IBlockState[][][] structure;

        public MultiblockBlockAccess(MultiblockRenderInfo data) {
            this.data = data;
            int[] index = new int[]{0};
            this.structure = (IBlockState[][][])Arrays.stream(data.multiblock.getStructure()).map(layer -> (IBlockState[][])Arrays.stream(layer).map(row -> Arrays.stream(row).map(blockstate -> blockstate).collect(Collectors.toList()).toArray(new IBlockState[0])).collect(Collectors.toList()).toArray((T[])new IBlockState[0][])).collect(Collectors.toList()).toArray((T[])new IBlockState[0][][]);
        }

        @Nullable
        public TileEntity func_175625_s(BlockPos pos) {
            return null;
        }

        public int func_175626_b(BlockPos pos, int lightValue) {
            return 0xF000F0;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            int index;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (y >= 0 && y < this.structure.length && x >= 0 && x < this.structure[y].length && z >= 0 && z < this.structure[y][x].length && (index = y * (this.data.structureLength * this.data.structureWidth) + x * this.data.structureWidth + z) <= this.data.getLimiter()) {
                return this.structure[y][x][z];
            }
            return Blocks.field_150350_a.func_176223_P();
        }

        public boolean func_175623_d(BlockPos pos) {
            return this.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a;
        }

        public Biome func_180494_b(BlockPos pos) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world != null) {
                return world.func_180494_b(pos);
            }
            return Biomes.field_150583_P;
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return 0;
        }

        public WorldType func_175624_G() {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world != null) {
                return world.func_175624_G();
            }
            return WorldType.field_77137_b;
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return false;
        }
    }
}

