/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

public class ColorHelper {
    public static int RGB(int red, int green, int blue) {
        return ColorHelper.RGBA(red, green, blue, 255);
    }

    public static int RGB(float red, float green, float blue) {
        return ColorHelper.RGBA((int)red * 255, (int)green * 255, (int)blue * 255, 255);
    }

    public static int RGB(String colour) {
        if (!colour.startsWith("#") || colour.length() != 7) {
            throw new IllegalArgumentException("Use #RRGGBB format");
        }
        return ColorHelper.RGB(Integer.parseInt(colour.substring(1, 3), 16), Integer.parseInt(colour.substring(3, 5), 16), Integer.parseInt(colour.substring(5, 7), 16));
    }

    public static int RGBA(int red, int green, int blue, int alpha) {
        return alpha << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static int blend(int ... colours) {
        if (colours.length < 1) {
            throw new IllegalArgumentException();
        }
        int[] alphas = new int[colours.length];
        int[] reds = new int[colours.length];
        int[] greens = new int[colours.length];
        int[] blues = new int[colours.length];
        for (int i = 0; i < colours.length; ++i) {
            alphas[i] = colours[i] >> 24 & 0xFF;
            reds[i] = (colours[i] & 0xFF0000) >> 16;
            greens[i] = (colours[i] & 0xFF00) >> 8;
            blues[i] = colours[i] & 0xFF;
        }
        float b = 0.0f;
        float g = 0.0f;
        float r = 0.0f;
        float a = 0.0f;
        float ratio = 1.0f / (float)colours.length;
        for (int alpha : alphas) {
            a += (float)alpha * ratio;
        }
        for (int red : reds) {
            r += (float)red * ratio;
        }
        for (int green : greens) {
            g += (float)green * ratio;
        }
        for (int blue : blues) {
            b += (float)blue * ratio;
        }
        return (int)a << 24 | (int)r << 16 | (int)g << 8 | (int)b;
    }

    public static int tone(int colour, float scale) {
        float r = colour >> 16 & 0xFF;
        float g = colour >> 8 & 0xFF;
        float b = colour & 0xFF;
        return ColorHelper.RGB(r * scale, g * scale, b * scale);
    }
}

