/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import minechem.utils.DirectionMultiplier;
import minechem.utils.Position;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class LocalPosition
extends Position {
    DirectionMultiplier multiplier;

    public LocalPosition(double x, double y, double z, EnumFacing orientation) {
        super(x, y, z, orientation);
        this.multiplier = DirectionMultiplier.map.get(orientation);
    }

    public int getLocalX(int x) {
        return (int)this.x + x * this.multiplier.xMultiplier;
    }

    public int getLocalY(int y) {
        return (int)this.y + y * this.multiplier.yMultiplier;
    }

    public int getLocalZ(int z) {
        return (int)this.z + z * this.multiplier.zMultiplier;
    }

    public Pos3 getLocalPos(int x, int y, int z) {
        Pos3 pos = new Pos3();
        pos.y = this.getLocalY(y);
        if (this.orientation == EnumFacing.SOUTH || this.orientation == EnumFacing.NORTH) {
            pos.x = this.getLocalX(z);
            pos.z = this.getLocalZ(x);
        } else {
            pos.x = this.getLocalX(x);
            pos.z = this.getLocalZ(z);
        }
        return pos;
    }

    public Pos3 getLocalPos(BlockPos pos) {
        return this.getLocalPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public BlockPos getLocalBlockPos() {
        Pos3 p = this.getLocalPos((int)this.x, (int)this.y, (int)this.z);
        return new BlockPos(p.x, p.y, p.z);
    }

    public class Pos3 {
        public int x;
        public int y;
        public int z;
    }
}

