/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class Position {
    public double x;
    public double y;
    public double z;
    public EnumFacing orientation;

    public Position(double ci, double cj, double ck) {
        this.x = ci;
        this.y = cj;
        this.z = ck;
        this.orientation = EnumFacing.NORTH;
    }

    public Position(double ci, double cj, double ck, EnumFacing corientation) {
        this.x = ci;
        this.y = cj;
        this.z = ck;
        this.orientation = corientation;
    }

    public Position(Position p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
        this.orientation = p.orientation;
    }

    public Position(NBTTagCompound nbttagcompound) {
        this.x = nbttagcompound.func_74769_h("i");
        this.y = nbttagcompound.func_74769_h("j");
        this.z = nbttagcompound.func_74769_h("k");
        this.orientation = EnumFacing.NORTH;
    }

    public Position(TileEntity tile) {
        this.x = tile.func_174877_v().func_177958_n();
        this.y = tile.func_174877_v().func_177956_o();
        this.z = tile.func_174877_v().func_177952_p();
    }

    public void moveRight(double step) {
        switch (this.orientation) {
            case SOUTH: {
                this.x -= step;
                break;
            }
            case NORTH: {
                this.x += step;
                break;
            }
            case EAST: {
                this.z += step;
                break;
            }
            case WEST: {
                this.z -= step;
                break;
            }
        }
    }

    public void moveLeft(double step) {
        this.moveRight(-step);
    }

    public void moveForwards(double step) {
        switch (this.orientation) {
            case UP: {
                this.y += step;
                break;
            }
            case DOWN: {
                this.y -= step;
                break;
            }
            case SOUTH: {
                this.z += step;
                break;
            }
            case NORTH: {
                this.z -= step;
                break;
            }
            case EAST: {
                this.x += step;
                break;
            }
            case WEST: {
                this.x -= step;
                break;
            }
        }
    }

    public void moveBackwards(double step) {
        this.moveForwards(-step);
    }

    public void moveUp(double step) {
        switch (this.orientation) {
            case SOUTH: 
            case NORTH: 
            case EAST: 
            case WEST: {
                this.y += step;
                break;
            }
        }
    }

    public void moveDown(double step) {
        this.moveUp(-step);
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74780_a("i", this.x);
        nbttagcompound.func_74780_a("j", this.y);
        nbttagcompound.func_74780_a("k", this.z);
    }

    public String toString() {
        return "{" + this.x + ", " + this.y + ", " + this.z + "}";
    }

    public Position min(Position p) {
        return new Position(p.x > this.x ? this.x : p.x, p.y > this.y ? this.y : p.y, p.z > this.z ? this.z : p.z);
    }

    public Position max(Position p) {
        return new Position(p.x < this.x ? this.x : p.x, p.y < this.y ? this.y : p.y, p.z < this.z ? this.z : p.z);
    }
}

