/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import minechem.client.model.generated.ModelProperties;
import minechem.client.model.generated.PerspectiveAwareBakedModel;
import minechem.client.model.generated.Transforms;
import minechem.item.element.ElementEnum;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import net.minecraftforge.common.model.TRSRTransformation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public final class RenderUtil {
    private static final EnumFacing[] HORIZONTALS = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};
    private static final EnumFacing[] VERTICALS = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST};
    private static Map<ResourceLocation, IBakedModel> MODEL_CACHE = Maps.newHashMap();

    public static void drawTextureIn3D(ResourceLocation texture, int color) {
        float scale = 1.0f;
        GlStateManager.func_179109_b((float)(-scale / 2.0f), (float)(-scale / 2.0f), (float)0.0f);
        IBakedModel model = RenderUtil.getModel(texture);
        RenderUtil.render(model, color);
    }

    public static IBakedModel getModel(ResourceLocation loc) {
        if (!RenderUtil.getModelCache().containsKey(loc)) {
            RenderUtil.getModelCache().put(loc, new PerspectiveAwareBakedModel((List<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)Minecraft.func_71410_x().func_147117_R().func_110572_b(loc.toString()), (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.of(TRSRTransformation.identity())), Transforms.DEFAULT_ITEM, ModelProperties.DEFAULT_ITEM));
        }
        return RenderUtil.getModelCache().get(loc);
    }

    public static Map<ResourceLocation, IBakedModel> getModelCache() {
        return MODEL_CACHE;
    }

    public static void render(IBakedModel model, ItemStack stack) {
        RenderUtil.render(model, -1, stack);
    }

    public static void render(IBakedModel model, int color) {
        RenderUtil.render(model, color, ItemStack.field_190927_a);
    }

    public static void render(IBakedModel model) {
        RenderUtil.render(model, 0);
    }

    public static void render(IBakedModel model, int color, ItemStack stack) {
        RenderUtil.renderQuads(model.func_188616_a((IBlockState)null, (EnumFacing)null, 0L), 0.0f);
    }

    public static void renderQuads(List<BakedQuad> quads, float alphaOverride) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        int alpha = (int)(alphaOverride * 255.0f) & 0xFF;
        for (BakedQuad quad : quads) {
            int colour = -1;
            colour |= alpha << 24;
            boolean doParty = false;
            Minecraft mc = Minecraft.func_71410_x();
            WorldClient world = mc.field_71441_e;
            EntityPlayerSP player = mc.field_71439_g;
            BlockPos pos = player.func_180425_c();
            int distance = 2;
            for (int x = -distance; x < distance; ++x) {
                block2: for (int y = -distance; y < distance; ++y) {
                    for (int z = -distance; z < distance; ++z) {
                        IBlockState state;
                        BlockPos checkingPos = pos.func_177982_a(x, y, z);
                        if (world.func_180495_p(checkingPos).func_177230_c() != Blocks.field_150421_aI || !((Boolean)(state = world.func_180495_p(checkingPos)).func_177229_b((IProperty)BlockJukebox.field_176432_a)).booleanValue()) continue;
                        doParty = true;
                        continue block2;
                    }
                }
            }
            if (doParty) {
                Random rand = world.field_73012_v;
                int red = rand.nextInt(255);
                int green = rand.nextInt(255);
                int blue = rand.nextInt(255);
                colour = (colour << 8) + red;
                colour = (colour << 8) + green;
                colour = (colour << 8) + blue;
            }
            LightUtil.renderQuadColor((BufferBuilder)buffer, (BakedQuad)quad, (int)colour);
        }
        tess.func_78381_a();
    }

    public static void renderQuadsColored(List<BakedQuad> quads, int color, float alphaOverride) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        int alpha = (int)(alphaOverride * 255.0f) & 0xFF;
        for (BakedQuad quad : quads) {
            color |= alpha << 24;
            boolean doParty = false;
            Minecraft mc = Minecraft.func_71410_x();
            WorldClient world = mc.field_71441_e;
            EntityPlayerSP player = mc.field_71439_g;
            BlockPos pos = player.func_180425_c();
            int distance = 2;
            for (int x = -distance; x < distance; ++x) {
                block2: for (int y = -distance; y < distance; ++y) {
                    for (int z = -distance; z < distance; ++z) {
                        IBlockState state;
                        BlockPos checkingPos = pos.func_177982_a(x, y, z);
                        if (world.func_180495_p(checkingPos).func_177230_c() != Blocks.field_150421_aI || !((Boolean)(state = world.func_180495_p(checkingPos)).func_177229_b((IProperty)BlockJukebox.field_176432_a)).booleanValue()) continue;
                        doParty = true;
                        continue block2;
                    }
                }
            }
            if (doParty) {
                Random rand = world.field_73012_v;
                int red = rand.nextInt(255);
                int green = rand.nextInt(255);
                int blue = rand.nextInt(255);
                color = (color << 8) + red;
                color = (color << 8) + green;
                color = (color << 8) + blue;
            }
            LightUtil.renderQuadColor((BufferBuilder)buffer, (BakedQuad)quad, (int)color);
        }
        tess.func_78381_a();
    }

    public static void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color, ItemStack stack) {
        boolean flag = color == -1 && !stack.func_190926_b();
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (!flag) {
                int n = k = color == -1 ? -1 : color;
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                k |= 0xFF000000;
            }
            if (bakedquad.getFormat().equals((Object)renderer.func_178973_g())) {
                renderer.func_178981_a(bakedquad.func_178209_a());
                ForgeHooksClient.putQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)k);
                continue;
            }
            LightUtil.ItemConsumer cons = renderer == Tessellator.func_178181_a().func_178180_c() ? LightUtil.getItemConsumer() : new LightUtil.ItemConsumer((IVertexConsumer)new VertexBufferConsumer(renderer));
            float b = (float)(k & 0xFF) / 255.0f;
            float g = (float)(k >>> 8 & 0xFF) / 255.0f;
            float r = (float)(k >>> 16 & 0xFF) / 255.0f;
            float a = (float)(k >>> 24 & 0xFF) / 255.0f;
            cons.setAuxColor(new float[]{r, g, b, a});
            bakedquad.pipe((IVertexConsumer)cons);
        }
    }

    public static void setOpenGLColour(int colour) {
        Color color = new Color(colour);
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
    }

    public static void resetOpenGLColour() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void setGreyscaleOpenGLColour(float greyscale) {
        GlStateManager.func_179131_c((float)greyscale, (float)greyscale, (float)greyscale, (float)1.0f);
    }

    public static void setColorForElement(ElementEnum element) {
        switch (element.classification()) {
            case actinide: {
                GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case alkaliMetal: {
                GlStateManager.func_179124_c((float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case alkalineEarthMetal: {
                GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case halogen: {
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case inertGas: {
                GlStateManager.func_179124_c((float)0.0f, (float)1.0f, (float)1.0f);
                break;
            }
            case lanthanide: {
                GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case nonmetal: {
                GlStateManager.func_179124_c((float)1.0f, (float)0.5f, (float)0.0f);
                break;
            }
            case otherMetal: {
                GlStateManager.func_179124_c((float)0.5f, (float)1.0f, (float)0.0f);
                break;
            }
            case semimetallic: {
                GlStateManager.func_179124_c((float)0.0f, (float)1.0f, (float)0.5f);
                break;
            }
            case transitionMetal: {
                GlStateManager.func_179124_c((float)0.0f, (float)0.5f, (float)1.0f);
                break;
            }
        }
    }

    public static int getColorForElement(ElementEnum element) {
        switch (element.classification()) {
            case actinide: {
                return -65536;
            }
            case alkaliMetal: {
                return -16711936;
            }
            case alkalineEarthMetal: {
                return -16776961;
            }
            case halogen: {
                return -256;
            }
            case inertGas: {
                return -16711681;
            }
            case lanthanide: {
                return -65281;
            }
            case nonmetal: {
                return -35072;
            }
            case otherMetal: {
                return -8913152;
            }
            case semimetallic: {
                return -16711817;
            }
            case transitionMetal: {
                return -16746497;
            }
        }
        return -1;
    }

    public static void startScissor(Minecraft minecraft, int x, int y, int w, int h) {
        ScaledResolution scaledRes = new ScaledResolution(minecraft);
        int scale = scaledRes.func_78325_e();
        int scissorWidth = w * scale;
        int scissorHeight = h * scale;
        int scissorX = x * scale;
        int scissorY = minecraft.field_71440_d - scissorHeight - y * scale;
        GL11.glEnable((int)3089);
        GL11.glScissor((int)scissorX, (int)scissorY, (int)scissorWidth, (int)scissorHeight);
    }

    public static void endScissor() {
        GL11.glDisable((int)3089);
    }

    public static ImmutableList<BakedQuad> getQuadsForSprites(VertexFormat format, Optional<TRSRTransformation> transform, TextureAtlasSprite ... sprites) {
        int tint = 0;
        ImmutableList.Builder builder = ImmutableList.builder();
        float horizontalPixelPos = 0.0f;
        for (TextureAtlasSprite sprite : sprites) {
            int off;
            int off2;
            boolean face;
            boolean building;
            int u;
            int v;
            int uMax = sprite.func_94211_a();
            int vMax = sprite.func_94216_b();
            FaceData faceData = new FaceData(uMax, vMax);
            boolean translucent = false;
            for (int f = 0; f < sprite.func_110970_k(); ++f) {
                int[] pixels = sprite.func_147965_a(f)[0];
                boolean[] ptv = new boolean[uMax];
                Arrays.fill(ptv, true);
                for (v = 0; v < vMax; ++v) {
                    boolean ptu = true;
                    for (int u2 = 0; u2 < uMax; ++u2) {
                        boolean t;
                        int alpha = RenderUtil.getAlpha(pixels, uMax, vMax, u2, v);
                        boolean bl = t = (float)alpha / 255.0f <= 0.1f;
                        if (!t && alpha < 255) {
                            translucent = true;
                        }
                        if (ptu && !t) {
                            faceData.set(EnumFacing.WEST, u2, v);
                        }
                        if (!ptu && t) {
                            faceData.set(EnumFacing.EAST, u2 - 1, v);
                        }
                        if (ptv[u2] && !t) {
                            faceData.set(EnumFacing.UP, u2, v);
                        }
                        if (!ptv[u2] && t) {
                            faceData.set(EnumFacing.DOWN, u2, v - 1);
                        }
                        ptu = t;
                        ptv[u2] = t;
                    }
                    if (ptu) continue;
                    faceData.set(EnumFacing.EAST, uMax - 1, v);
                }
                for (u = 0; u < uMax; ++u) {
                    if (ptv[u]) continue;
                    faceData.set(EnumFacing.DOWN, u, vMax - 1);
                }
            }
            for (EnumFacing facing : HORIZONTALS) {
                for (v = 0; v < vMax; ++v) {
                    int uStart = 0;
                    int uEnd = uMax;
                    building = false;
                    for (int u3 = 0; u3 < uMax; ++u3) {
                        face = faceData.get(facing, u3, v);
                        if (!translucent) {
                            if (!face) continue;
                            if (!building) {
                                building = true;
                                uStart = u3;
                            }
                            uEnd = u3 + 1;
                            continue;
                        }
                        if (building && !face) {
                            off2 = facing == EnumFacing.DOWN ? 1 : 0;
                            builder.add((Object)RenderUtil.buildSideQuad(format, transform, facing, tint, sprite, uStart, v + off2, u3 - uStart, horizontalPixelPos));
                            building = false;
                            continue;
                        }
                        if (building || !face) continue;
                        building = true;
                        uStart = u3;
                    }
                    if (!building) continue;
                    off = facing == EnumFacing.DOWN ? 1 : 0;
                    builder.add((Object)RenderUtil.buildSideQuad(format, transform, facing, tint, sprite, uStart, v + off, uEnd - uStart, horizontalPixelPos));
                }
            }
            for (EnumFacing facing : VERTICALS) {
                for (u = 0; u < uMax; ++u) {
                    int vStart = 0;
                    int vEnd = vMax;
                    building = false;
                    for (int v2 = 0; v2 < vMax; ++v2) {
                        face = faceData.get(facing, u, v2);
                        if (!translucent) {
                            if (!face) continue;
                            if (!building) {
                                building = true;
                                vStart = v2;
                            }
                            vEnd = v2 + 1;
                            continue;
                        }
                        if (building && !face) {
                            off2 = facing == EnumFacing.EAST ? 1 : 0;
                            builder.add((Object)RenderUtil.buildSideQuad(format, transform, facing, tint, sprite, u + off2, vStart, v2 - vStart, horizontalPixelPos));
                            building = false;
                            continue;
                        }
                        if (building || !face) continue;
                        building = true;
                        vStart = v2;
                    }
                    if (!building) continue;
                    off = facing == EnumFacing.EAST ? 1 : 0;
                    builder.add((Object)RenderUtil.buildSideQuad(format, transform, facing, tint, sprite, u + off, vStart, vEnd - vStart, horizontalPixelPos));
                }
            }
            builder.add((Object)RenderUtil.buildQuad(format, transform, EnumFacing.NORTH, sprite, tint, 0.0f + horizontalPixelPos, 0.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f + horizontalPixelPos, 1.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f + horizontalPixelPos, 1.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f + horizontalPixelPos, 0.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94210_h()));
            builder.add((Object)RenderUtil.buildQuad(format, transform, EnumFacing.SOUTH, sprite, tint, 0.0f + horizontalPixelPos, 0.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f + horizontalPixelPos, 0.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f + horizontalPixelPos, 1.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f + horizontalPixelPos, 1.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94206_g()));
            horizontalPixelPos += 0.37f;
        }
        return builder.build();
    }

    private static int getAlpha(int[] pixels, int uMax, int vMax, int u, int v) {
        return pixels[u + (vMax - 1 - v) * uMax] >> 24 & 0xFF;
    }

    private static BakedQuad buildSideQuad(VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, int tint, TextureAtlasSprite sprite, int u, int v, int size, float horizontalOffset) {
        float eps = 0.01f;
        int width = sprite.func_94211_a();
        int height = sprite.func_94216_b();
        float x0 = (float)u / (float)width;
        float y0 = (float)v / (float)height;
        float x1 = x0;
        float y1 = y0;
        float z0 = 0.46875f;
        float z1 = 0.53125f;
        switch (side) {
            case WEST: {
                z0 = 0.53125f;
                z1 = 0.46875f;
            }
            case EAST: {
                y1 = (float)(v + size) / (float)height;
                break;
            }
            case DOWN: {
                z0 = 0.53125f;
                z1 = 0.46875f;
            }
            case UP: {
                x1 = (float)(u + size) / (float)width;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float dx = (float)side.func_176730_m().func_177958_n() * 0.01f / (float)width;
        float dy = (float)side.func_176730_m().func_177956_o() * 0.01f / (float)height;
        float u0 = 16.0f * (x0 - dx);
        float u1 = 16.0f * (x1 - dx);
        float v0 = 16.0f * (1.0f - y0 - dy);
        float v1 = 16.0f * (1.0f - y1 - dy);
        return RenderUtil.buildQuad(format, transform, RenderUtil.remap(side), sprite, tint, x0 + horizontalOffset, y0, z0, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0), x1 + horizontalOffset, y1, z0, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x1 + horizontalOffset, y1, z1, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x0 + horizontalOffset, y0, z1, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0));
    }

    private static EnumFacing remap(EnumFacing side) {
        return side.func_176740_k() == EnumFacing.Axis.Y ? side.func_176734_d() : side;
    }

    private static BakedQuad buildQuad(VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, TextureAtlasSprite sprite, int tint, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        RenderUtil.putVertex(builder, format, transform, side, x0, y0, z0, u0, v0);
        RenderUtil.putVertex(builder, format, transform, side, x1, y1, z1, u1, v1);
        RenderUtil.putVertex(builder, format, transform, side, x2, y2, z2, u2, v2);
        RenderUtil.putVertex(builder, format, transform, side, x3, y3, z3, u3, v3);
        return builder.build();
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, float x, float y, float z, float u, float v) {
        Vector4f vec = new Vector4f();
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    if (transform.isPresent()) {
                        vec.x = x;
                        vec.y = y;
                        vec.z = z;
                        vec.w = 1.0f;
                        transform.get().getMatrix().transform((Tuple4f)vec);
                        builder.put(e, new float[]{vec.x, vec.y, vec.z, vec.w});
                        continue block6;
                    }
                    builder.put(e, new float[]{x, y, z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (format.func_177348_c(e).func_177369_e() == 0) {
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{side.func_82601_c(), side.func_96559_d(), side.func_82599_e(), 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public static void drawCustomTooltip(GuiScreen gui, FontRenderer fr, List<String> textList, int x, int y, int subTipColor) {
        RenderUtil.drawCustomTooltip(gui, fr, textList, x, y, subTipColor, false);
    }

    public static void drawCustomTooltip(GuiScreen gui, FontRenderer fr, List<String> textList, int x, int y, int subTipColor, boolean ignoremouse) {
        if (!textList.isEmpty()) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution scaledresolution = new ScaledResolution(mc);
            int sf = scaledresolution.func_78325_e();
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int max = 240;
            int mx = Mouse.getEventX();
            boolean flip = false;
            if (!ignoremouse && (max + 24) * sf + mx > mc.field_71443_c && (max = (mc.field_71443_c - mx) / sf - 24) < 120) {
                max = 240;
                flip = true;
            }
            int widestLineWidth = 0;
            Iterator<String> textLineEntry = textList.iterator();
            boolean b = false;
            while (textLineEntry.hasNext()) {
                String textLine = textLineEntry.next();
                if (fr.func_78256_a(textLine) <= max) continue;
                b = true;
                break;
            }
            if (b) {
                ArrayList<String> tl = new ArrayList<String>();
                for (String o : textList) {
                    String textLine = "";
                    textLine = o;
                    List tl2 = fr.func_78271_c(textLine, textLine.startsWith("@@") ? max * 2 : max);
                    for (Object o2 : tl2) {
                        String textLine2 = ((String)o2).trim();
                        if (textLine.startsWith("@@")) {
                            textLine2 = "@@" + textLine2;
                        }
                        tl.add(textLine2);
                    }
                }
                textList = tl;
            }
            Iterator<String> textLines = textList.iterator();
            int totalHeight = -2;
            while (textLines.hasNext()) {
                String textLine = textLines.next();
                int lineWidth = fr.func_78256_a(textLine);
                if (textLine.startsWith("@@") && !fr.func_82883_a()) {
                    lineWidth /= 2;
                }
                if (lineWidth > widestLineWidth) {
                    widestLineWidth = lineWidth;
                }
                totalHeight += textLine.startsWith("@@") && !fr.func_82883_a() ? 7 : 10;
            }
            int sX = x + 12;
            int sY = y - 12;
            if (textList.size() > 1) {
                totalHeight += 2;
            }
            if (sY + totalHeight > scaledresolution.func_78328_b()) {
                sY = scaledresolution.func_78328_b() - totalHeight - 5;
            }
            if (flip) {
                sX -= widestLineWidth + 24;
            }
            Minecraft.func_71410_x().func_175599_af().field_77023_b = 300.0f;
            int var10 = -267386864;
            RenderUtil.drawGradientRect(sX - 3, sY - 4, sX + widestLineWidth + 3, sY - 3, var10, var10);
            RenderUtil.drawGradientRect(sX - 3, sY + totalHeight + 3, sX + widestLineWidth + 3, sY + totalHeight + 4, var10, var10);
            RenderUtil.drawGradientRect(sX - 3, sY - 3, sX + widestLineWidth + 3, sY + totalHeight + 3, var10, var10);
            RenderUtil.drawGradientRect(sX - 4, sY - 3, sX - 3, sY + totalHeight + 3, var10, var10);
            RenderUtil.drawGradientRect(sX + widestLineWidth + 3, sY - 3, sX + widestLineWidth + 4, sY + totalHeight + 3, var10, var10);
            int var11 = 0x505000FF;
            int var12 = (var11 & 0xFEFEFE) >> 1 | var11 & 0xFF000000;
            RenderUtil.drawGradientRect(sX - 3, sY - 3 + 1, sX - 3 + 1, sY + totalHeight + 3 - 1, var11, var12);
            RenderUtil.drawGradientRect(sX + widestLineWidth + 2, sY - 3 + 1, sX + widestLineWidth + 3, sY + totalHeight + 3 - 1, var11, var12);
            RenderUtil.drawGradientRect(sX - 3, sY - 3, sX + widestLineWidth + 3, sY - 3 + 1, var11, var11);
            RenderUtil.drawGradientRect(sX - 3, sY + totalHeight + 2, sX + widestLineWidth + 3, sY + totalHeight + 3, var12, var12);
            for (int i = 0; i < textList.size(); ++i) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)sX, (float)sY, (float)0.0f);
                String tl = textList.get(i);
                boolean shift = false;
                GL11.glPushMatrix();
                if (tl.startsWith("@@") && !fr.func_82883_a()) {
                    sY += 7;
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
                    shift = true;
                } else {
                    sY += 10;
                }
                tl = tl.replaceAll("@@", "");
                if (subTipColor != -99) {
                    tl = i == 0 ? "\u00a7" + Integer.toHexString(subTipColor) + tl : "\u00a77" + tl;
                }
                GL11.glTranslated((double)0.0, (double)0.0, (double)301.0);
                fr.func_175063_a(tl, 0.0f, shift ? 3.0f : 0.0f, -1);
                GL11.glPopMatrix();
                if (i == 0) {
                    sY += 2;
                }
                GL11.glPopMatrix();
            }
            Minecraft.func_71410_x().func_175599_af().field_77023_b = 0.0f;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    public static void drawGradientRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        boolean blendon = GL11.glIsEnabled((int)3042);
        float var7 = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float var8 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float var9 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float var10 = (float)(par5 & 0xFF) / 255.0f;
        float var11 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float var12 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float var13 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float var14 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator var15 = Tessellator.func_178181_a();
        var15.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181706_f);
        var15.func_178180_c().func_181662_b((double)par3, (double)par2, 300.0).func_181666_a(var8, var9, var10, var7).func_181675_d();
        var15.func_178180_c().func_181662_b((double)par1, (double)par2, 300.0).func_181666_a(var8, var9, var10, var7).func_181675_d();
        var15.func_178180_c().func_181662_b((double)par1, (double)par4, 300.0).func_181666_a(var12, var13, var14, var11).func_181675_d();
        var15.func_178180_c().func_181662_b((double)par3, (double)par4, 300.0).func_181666_a(var12, var13, var14, var11).func_181675_d();
        var15.func_78381_a();
        GL11.glShadeModel((int)7424);
        GlStateManager.func_179112_b((int)770, (int)771);
        if (!blendon) {
            GL11.glDisable((int)3042);
        }
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    private static class FaceData {
        private final EnumMap<EnumFacing, BitSet> data = new EnumMap(EnumFacing.class);
        private final int vMax;

        FaceData(int uMax, int vMax) {
            this.vMax = vMax;
            this.data.put(EnumFacing.WEST, new BitSet(uMax * vMax));
            this.data.put(EnumFacing.EAST, new BitSet(uMax * vMax));
            this.data.put(EnumFacing.UP, new BitSet(uMax * vMax));
            this.data.put(EnumFacing.DOWN, new BitSet(uMax * vMax));
        }

        public void set(EnumFacing facing, int u, int v) {
            this.data.get(facing).set(this.getIndex(u, v));
        }

        public boolean get(EnumFacing facing, int u, int v) {
            return this.data.get(facing).get(this.getIndex(u, v));
        }

        private int getIndex(int u, int v) {
            return v * this.vMax + u;
        }
    }
}

