/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.dimension.world.gen;

import asmodeuscore.core.astronomy.dimension.world.gen.ACBiome;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.api.world.ChunkProviderBase;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.world.gen.EnumCraterSize;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.fml.common.FMLLog;

public abstract class ChunkProviderSpaceLakes
extends ChunkProviderBase {
    protected static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Y = 256;
    protected static final int CHUNK_SIZE_Z = 16;
    private final double TERRAIN_HEIGHT_MOD = this.getHeightModifier();
    private final double SMALL_FEATURE_HEIGHT_MOD = this.getSmallFeatureHeightModifier();
    private final double MOUNTAIN_HEIGHT_MOD = this.getMountainHeightModifier();
    private final double VALLEY_HEIGHT_MOD = this.getValleyHeightModifier();
    private final int CRATER_PROB = this.getCraterProbability();
    private final int MID_HEIGHT = this.getTerrainLevel();
    private static final double MAIN_FEATURE_FILTER_MOD = 4.0;
    private static final double LARGE_FEATURE_FILTER_MOD = 8.0;
    private static final double SMALL_FEATURE_FILTER_MOD = 8.0;
    protected Random rand;
    private BiomeCache myBiomeCache;
    private NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves noiseGen5;
    public NoiseGeneratorOctaves noiseGen6;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    protected World worldObj;
    private double[] stoneNoise;
    private Biome[] biomesForGeneration = this.getBiomesForGeneration();
    double[] noise3;
    double[] noise1;
    double[] noise2;
    double[] noise5;
    double[] noise6;
    float[] squareTable;
    private NoiseGeneratorOctaves field_147431_j;
    private NoiseGeneratorOctaves field_147432_k;
    private NoiseGeneratorOctaves field_147429_l;
    private NoiseGeneratorPerlin field_147430_m;
    private double[] terrainCalcs;
    private float[] parabolicField;
    double[] field_147427_d;
    double[] field_147428_e;
    double[] field_147425_f;
    double[] field_147426_g;
    int[][] field_73219_j = new int[32][32];
    private final Gradient noiseGen8;
    private final Gradient gcnoiseGen1;
    private final Gradient gcnoiseGen2;
    private final Gradient gcnoiseGen3;
    private final Gradient gcnoiseGen4;
    private final Gradient gcnoiseGen5;
    private final Gradient gcnoiseGen6;
    private final Gradient gcnoiseGen7;
    public static List<GenBlocks> genBlocks = new ArrayList<GenBlocks>();
    private List<MapGenBaseMeta> worldGenerators;

    public ChunkProviderSpaceLakes(World world, long seed, boolean flag) {
        this.stoneNoise = new double[256];
        this.worldObj = world;
        this.rand = new Random(seed);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen8 = new Gradient(this.rand.nextLong(), 2, 0.25f);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.field_147431_j = new NoiseGeneratorOctaves(this.rand, 16);
        this.field_147432_k = new NoiseGeneratorOctaves(this.rand, 16);
        this.field_147429_l = new NoiseGeneratorOctaves(this.rand, 8);
        this.field_147430_m = new NoiseGeneratorPerlin(this.rand, 4);
        this.terrainCalcs = new double[825];
        this.parabolicField = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
        this.gcnoiseGen1 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.gcnoiseGen2 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.gcnoiseGen3 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.gcnoiseGen4 = new Gradient(this.rand.nextLong(), 2, 0.25f);
        this.gcnoiseGen5 = new Gradient(this.rand.nextLong(), 1, 0.25f);
        this.gcnoiseGen6 = new Gradient(this.rand.nextLong(), 1, 0.25f);
        this.gcnoiseGen7 = new Gradient(this.rand.nextLong(), 1, 0.25f);
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer primer = new ChunkPrimer();
        try {
            this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
            this.generateTerrain(x, z, primer);
            if (this.getCraterProbability() > 0) {
                this.createCraters(x, z, primer);
            }
            this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
            this.replaceBlocksForBiome(x, z, primer, this.biomesForGeneration);
            if (this.worldGenerators == null) {
                this.worldGenerators = this.getWorldGenerators();
            }
            for (MapGenBaseMeta generator : this.worldGenerators) {
                generator.generate(this.worldObj, x, z, primer);
            }
            this.onChunkProvider(x, z, primer);
        }
        catch (Exception e) {
            FMLLog.warning((String)("Error caught in planetary worldgen at coords " + x + "," + z + "."), (Object[])new Object[0]);
            e.printStackTrace();
        }
        Chunk chunk = new Chunk(this.worldObj, primer, x, z);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void generateTerrain(int chunkX, int chunkZ, ChunkPrimer primer) {
        int seaLevel = this.getWaterLevel();
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        if (this.getGenType() != GenType.GC) {
            this.makeLandPerBiome2(chunkX * 4, 0, chunkZ * 4);
            for (int i = 0; i < 4; ++i) {
                int j = i * 5;
                int k = (i + 1) * 5;
                for (int l = 0; l < 4; ++l) {
                    int i1 = (j + l) * 33;
                    int j1 = (j + l + 1) * 33;
                    int k1 = (k + l) * 33;
                    int l1 = (k + l + 1) * 33;
                    for (int i2 = 0; i2 < 32; ++i2) {
                        double d0 = 0.125;
                        double d1 = this.terrainCalcs[i1 + i2];
                        double d2 = this.terrainCalcs[j1 + i2];
                        double d3 = this.terrainCalcs[k1 + i2];
                        double d4 = this.terrainCalcs[l1 + i2];
                        double d5 = (this.terrainCalcs[i1 + i2 + 1] - d1) * 0.125;
                        double d6 = (this.terrainCalcs[j1 + i2 + 1] - d2) * 0.125;
                        double d7 = (this.terrainCalcs[k1 + i2 + 1] - d3) * 0.125;
                        double d8 = (this.terrainCalcs[l1 + i2 + 1] - d4) * 0.125;
                        for (int j2 = 0; j2 < 8; ++j2) {
                            double d9 = 0.25;
                            double d10 = d1;
                            double d11 = d2;
                            double d12 = (d3 - d1) * 0.25;
                            double d13 = (d4 - d2) * 0.25;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                double d14 = 0.25;
                                double d16 = (d11 - d10) * 0.25;
                                double lvt_45_1_ = d10 - d16;
                                for (int l2 = 0; l2 < 4; ++l2) {
                                    double d;
                                    lvt_45_1_ += d16;
                                    if (d > 0.0) {
                                        primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, this.getStoneBlock().getBlock().func_176203_a((int)this.getStoneBlock().getMetadata()));
                                        continue;
                                    }
                                    if (i2 * 8 + j2 >= seaLevel || !this.canGenerateWaterBlock()) continue;
                                    primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, this.getWaterBlock().getBlock().func_176203_a((int)this.getWaterBlock().getMetadata()));
                                }
                                d10 += d12;
                                d11 += d13;
                            }
                            d1 += d5;
                            d2 += d6;
                            d3 += d7;
                            d4 += d8;
                        }
                    }
                }
            }
        } else {
            this.makeGCland(chunkX, chunkZ, primer);
        }
    }

    public void makeGCland(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.gcnoiseGen1.setFrequency(0.015f);
        this.gcnoiseGen2.setFrequency(0.01f);
        this.gcnoiseGen3.setFrequency(0.01f);
        this.gcnoiseGen4.setFrequency(0.01f);
        this.gcnoiseGen5.setFrequency(0.01f);
        this.gcnoiseGen6.setFrequency(0.001f);
        this.gcnoiseGen7.setFrequency(0.005f);
        int x = 0;
        while (true) {
            if (x >= 16) break;
            int z = 0;
            while (true) {
                if (z >= 16) break;
                double baseHeight = (double)this.gcnoiseGen1.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * this.TERRAIN_HEIGHT_MOD;
                double smallHillHeight = (double)this.gcnoiseGen2.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * this.SMALL_FEATURE_HEIGHT_MOD;
                double mountainHeight = Math.abs(this.gcnoiseGen3.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)));
                double valleyHeight = Math.abs(this.gcnoiseGen4.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)));
                double featureFilter = (double)this.gcnoiseGen5.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * 4.0;
                double largeFilter = (double)this.gcnoiseGen6.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * 8.0;
                double smallFilter = (double)this.gcnoiseGen7.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * 8.0 - 0.5;
                mountainHeight = this.lerp(smallHillHeight, mountainHeight * this.MOUNTAIN_HEIGHT_MOD, this.fade(this.clamp(mountainHeight * 2.0, 0.0, 1.0)));
                valleyHeight = this.lerp(smallHillHeight, valleyHeight * this.VALLEY_HEIGHT_MOD - this.VALLEY_HEIGHT_MOD + 9.0, this.fade(this.clamp((valleyHeight + 2.0) * 4.0, 0.0, 1.0)));
                double yDev = this.lerp(valleyHeight, mountainHeight, this.fade(largeFilter));
                yDev = this.lerp(smallHillHeight, yDev, smallFilter);
                yDev = this.lerp(baseHeight, yDev, featureFilter);
                Biome biomes = this.worldObj.func_180494_b(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
                int y = 0;
                while (true) {
                    if (y >= 256) break;
                    if ((double)y < (double)this.MID_HEIGHT + yDev) {
                        if (this.enableBiomeGenBaseBlock() && !genBlocks.isEmpty()) {
                            int index = -1;
                            for (GenBlocks genBlock : genBlocks) {
                                ++index;
                                if (this.worldObj.field_73011_w != genBlock.getWorldProvider() || biomes != genBlock.getBiome()) continue;
                                break;
                            }
                            primer.func_177855_a(x, y, z, genBlocks.get(index).getStoneBlock().getBlock().func_176203_a((int)genBlocks.get(index).getStoneBlock().getMetadata()));
                        } else {
                            primer.func_177855_a(x, y, z, this.getStoneBlock().getBlock().func_176203_a((int)this.getStoneBlock().getMetadata()));
                        }
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
    }

    private void makeLandPerBiome2(int x, int zero, int z) {
        this.field_147426_g = this.noiseGen6.func_76305_a(this.field_147426_g, x, z, 5, 5, 200.0, 200.0, 0.5);
        this.field_147427_d = this.field_147429_l.func_76304_a(this.field_147427_d, x, zero, z, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.field_147428_e = this.field_147431_j.func_76304_a(this.field_147428_e, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        this.field_147425_f = this.field_147432_k.func_76304_a(this.field_147425_f, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        int terrainIndex = 0;
        int noiseIndex = 0;
        for (int ax = 0; ax < 5; ++ax) {
            for (int az = 0; az < 5; ++az) {
                float totalVariation = 0.0f;
                float totalHeight = 0.0f;
                float totalFactor = 0.0f;
                int two = 2;
                Biome biomegenbase = this.biomesForGeneration[ax + 2 + (az + 2) * 10];
                for (int ox = -two; ox <= two; ++ox) {
                    for (int oz = -two; oz <= two; ++oz) {
                        Biome biomegenbase1 = this.biomesForGeneration[ax + ox + 2 + (az + oz + 2) * 10];
                        float rootHeight = biomegenbase1.func_185355_j();
                        float heightVariation = biomegenbase1.func_185360_m();
                        float heightFactor = this.parabolicField[ox + 2 + (oz + 2) * 5] / (rootHeight + 2.0f);
                        if (biomegenbase1.func_185355_j() > biomegenbase.func_185355_j()) {
                            heightFactor /= 2.0f;
                        }
                        totalVariation += heightVariation * heightFactor;
                        totalHeight += rootHeight * heightFactor;
                        totalFactor += heightFactor;
                    }
                }
                totalVariation /= totalFactor;
                totalHeight /= totalFactor;
                totalVariation = totalVariation * 0.9f + 0.1f;
                totalHeight = (totalHeight * 4.0f - 1.0f) / 8.0f;
                double terrainNoise = this.field_147426_g[noiseIndex] / 8000.0;
                if (terrainNoise < 0.0) {
                    terrainNoise = -terrainNoise * 0.3;
                }
                if ((terrainNoise = terrainNoise * 3.0 - 2.0) < 0.0) {
                    if ((terrainNoise /= 2.0) < -1.0) {
                        terrainNoise = -1.0;
                    }
                    terrainNoise /= 1.4;
                    terrainNoise /= 2.0;
                } else {
                    if (terrainNoise > 1.0) {
                        terrainNoise = 1.0;
                    }
                    terrainNoise /= 8.0;
                }
                ++noiseIndex;
                double heightCalc = totalHeight;
                double variationCalc = (double)totalVariation * this.getHeightModifier() / 10.0;
                heightCalc += terrainNoise * 0.2;
                heightCalc = heightCalc * 8.5 / 8.0;
                double d5 = 8.5 + heightCalc * 4.0;
                for (int ay = 0; ay < 33; ++ay) {
                    double d6 = ((double)ay - d5) * 12.0 * 128.0 / 256.0 / variationCalc;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.field_147428_e[terrainIndex] / 512.0;
                    double d8 = this.field_147425_f[terrainIndex] / 512.0;
                    double d9 = (this.field_147427_d[terrainIndex] / 10.0 + 1.0) / 2.0;
                    double terrainCalc = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (ay > 29) {
                        double d11 = (float)(ay - 29) / 3.0f;
                        terrainCalc = terrainCalc * (1.0 - d11) + -10.0 * d11;
                    }
                    this.terrainCalcs[terrainIndex] = terrainCalc;
                    ++terrainIndex;
                }
            }
        }
    }

    public void replaceBlocksForBiome(int x, int z, ChunkPrimer primer, Biome[] par4ArrayOfBiomeGenBase) {
        int var5 = 20;
        float var6 = 0.03125f;
        this.noiseGen8.setFrequency(0.0625f);
        if (this.getGenType() != GenType.END) {
            for (int var8 = 0; var8 < 16; ++var8) {
                for (int var9 = 0; var9 < 16; ++var9) {
                    byte mStone;
                    Block stone;
                    byte var15m;
                    Block var15;
                    byte var14m;
                    Block var14;
                    ACBiome biomegenbase = (ACBiome)par4ArrayOfBiomeGenBase[var8 + var9 * 16];
                    int var12 = (int)((double)this.noiseGen8.getNoise((float)(x * 16 + var8), (float)(z * 16 + var9)) / 3.0 + this.getDirtLayerSize() + this.rand.nextDouble() * 0.25);
                    int var13 = -1;
                    if (this.enableBiomeGenBaseBlock() && !genBlocks.isEmpty()) {
                        int index = -1;
                        for (GenBlocks genBlock : genBlocks) {
                            ++index;
                            if (this.worldObj.field_73011_w != genBlock.getWorldProvider() || par4ArrayOfBiomeGenBase[var8 + var9 * 16] != genBlock.getBiome()) continue;
                            break;
                        }
                        var14 = genBlocks.get(index).getGrassBlock().getBlock();
                        var14m = genBlocks.get(index).getGrassBlock().getMetadata();
                        var15 = genBlocks.get(index).getDirtBlock().getBlock();
                        var15m = genBlocks.get(index).getDirtBlock().getMetadata();
                        stone = genBlocks.get(index).getStoneBlock().getBlock();
                        mStone = genBlocks.get(index).getStoneBlock().getMetadata();
                    } else {
                        var14 = this.getGrassBlock().getBlock();
                        var14m = this.getGrassBlock().getMetadata();
                        var15 = this.getDirtBlock().getBlock();
                        var15m = this.getDirtBlock().getMetadata();
                        stone = this.getStoneBlock().getBlock();
                        mStone = this.getStoneBlock().getMetadata();
                    }
                    for (int var16 = 255; var16 >= 0; --var16) {
                        int index = this.getIndex(var8, var16, var9);
                        if (this.canGenerateIceBlock() && (var16 == 5 || var16 == 6 + this.rand.nextInt(3))) {
                            primer.func_177855_a(var8, var16, var9, this.getIceBlock().getBlock().func_176203_a((int)this.getIceBlock().getMetadata()));
                        }
                        if (var16 <= 0 + this.rand.nextInt(5)) {
                            primer.func_177855_a(var8, var16, var9, Blocks.field_150357_h.func_176223_P());
                            continue;
                        }
                        Block var18 = primer.func_177856_a(var8, var16, var9).func_177230_c();
                        if (Blocks.field_150350_a == var18) {
                            var13 = -1;
                            continue;
                        }
                        if (var18 == stone) {
                            if (var13 == -1) {
                                if (var12 <= 0) {
                                    var14 = Blocks.field_150350_a;
                                    var14m = 0;
                                    var15 = stone;
                                    var15m = mStone;
                                } else if (var16 >= 36 && var16 <= 21) {
                                    if (this.enableBiomeGenBaseBlock() && !genBlocks.isEmpty()) {
                                        var14 = genBlocks.get(index).getGrassBlock().getBlock();
                                        var14m = genBlocks.get(index).getGrassBlock().getMetadata();
                                        var14 = genBlocks.get(index).getDirtBlock().getBlock();
                                        var14m = genBlocks.get(index).getDirtBlock().getMetadata();
                                    } else {
                                        var14 = this.getGrassBlock().getBlock();
                                        var14m = this.getGrassBlock().getMetadata();
                                        var14 = this.getDirtBlock().getBlock();
                                        var14m = this.getDirtBlock().getMetadata();
                                    }
                                }
                                var13 = var12;
                                primer.func_177855_a(var8, var16, var9, var14.func_176203_a((int)var14m));
                                continue;
                            }
                            if (var13 <= 0) continue;
                            --var13;
                            primer.func_177855_a(var8, var16, var9, var15.func_176203_a((int)var15m));
                            continue;
                        }
                        if (var16 >= this.getWaterLevel() || this.getGenType() != GenType.GC || !this.canGenerateWaterBlock()) continue;
                        primer.func_177855_a(var8, var16, var9, this.getWaterBlock().getBlock().func_176203_a((int)this.getWaterBlock().getMetadata()));
                    }
                }
            }
        }
    }

    public void createCraters(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.gcnoiseGen5.setFrequency(0.015f);
        for (int cx = chunkX - 2; cx <= chunkX + 2; ++cx) {
            block1: for (int cz = chunkZ - 2; cz <= chunkZ + 2; ++cz) {
                int x = 0;
                while (true) {
                    if (x >= 16) continue block1;
                    int z = 0;
                    while (true) {
                        if (z >= 16) break;
                        if (Math.abs(this.randFromPoint(cx * 16 + x, (cz * 16 + z) * 1000)) < (double)(this.gcnoiseGen5.getNoise((float)(cx * 16 + x), (float)(cz * 16 + z)) / (float)this.CRATER_PROB)) {
                            Random random = new Random(cx * 16 + x + (cz * 16 + z) * 5000);
                            EnumCraterSize cSize = EnumCraterSize.sizeArray[random.nextInt(EnumCraterSize.sizeArray.length)];
                            int size = random.nextInt(cSize.MAX_SIZE - cSize.MIN_SIZE) + cSize.MIN_SIZE + 15;
                            this.makeCrater(cx * 16 + x, cz * 16 + z, chunkX * 16, chunkZ * 16, size, primer);
                        }
                        ++z;
                    }
                    ++x;
                }
            }
        }
    }

    public void makeCrater(int craterX, int craterZ, int chunkX, int chunkZ, int size, ChunkPrimer primer) {
        int x = 0;
        while (true) {
            if (x >= 16) break;
            int z = 0;
            while (true) {
                if (z >= 16) break;
                double xDev = craterX - (chunkX + x);
                double zDev = craterZ - (chunkZ + z);
                if (xDev * xDev + zDev * zDev < (double)(size * size)) {
                    double sqrtY = (xDev /= (double)size) * xDev + (zDev /= (double)size) * zDev;
                    double yDev = sqrtY * sqrtY * 6.0;
                    yDev = 5.0 - yDev;
                    int helper = 0;
                    for (int y = 127; y > 0; --y) {
                        if (Blocks.field_150350_a != primer.func_177856_a(x, y, z).func_177230_c() && (double)helper <= yDev) {
                            primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                            this.getCraterAdditions(primer, x, y, z);
                            ++helper;
                        }
                        if ((double)helper > yDev) break;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    private double randFromPoint(int x, int z) {
        int n = x + z * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    protected int getIndex(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int posX = x << 4;
        int posZ = z << 4;
        this.worldObj.func_180494_b(new BlockPos(posX + 16, 0, posZ + 16));
        this.rand.setSeed(this.worldObj.func_72905_C());
        long var7 = this.rand.nextLong() / 2L * 2L + 1L;
        long var9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * var7 + (long)z * var9 ^ this.worldObj.func_72905_C());
        this.decoratePlanet(this.worldObj, this.rand, posX, posZ);
        this.onPopulate(x, z);
        BlockFalling.field_149832_M = false;
    }

    public void decoratePlanet(World world, Random rand, int x, int z) {
        this.getBiomeGenerator().decorate(world, rand, x, z);
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biomegenbase = this.worldObj.func_180494_b(pos);
        return biomegenbase.func_76747_a(creatureType);
    }

    public static void setBlocks(GenBlocks array) {
        genBlocks.add(array);
    }

    protected double lerp(double d1, double d2, double t) {
        if (t < 0.0) {
            return d1;
        }
        if (t > 1.0) {
            return d2;
        }
        return d1 + (d2 - d1) * t;
    }

    protected double fade(double n) {
        return n * n * n * (n * (n * 6.0 - 15.0) + 10.0);
    }

    protected double clamp(double x, double min, double max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    protected abstract BiomeDecoratorSpace getBiomeGenerator();

    protected abstract Biome[] getBiomesForGeneration();

    public abstract void onChunkProvider(int var1, int var2, ChunkPrimer var3);

    public abstract void onPopulate(int var1, int var2);

    protected abstract List<MapGenBaseMeta> getWorldGenerators();

    public abstract double getHeightModifier();

    public abstract double getSmallFeatureHeightModifier();

    public abstract double getMountainHeightModifier();

    public abstract double getValleyHeightModifier();

    public abstract int getWaterLevel();

    public abstract boolean canGenerateWaterBlock();

    public abstract boolean canGenerateIceBlock();

    public abstract int getCraterProbability();

    protected abstract BlockMetaPair getWaterBlock();

    protected abstract BlockMetaPair getGrassBlock();

    protected abstract BlockMetaPair getDirtBlock();

    protected abstract BlockMetaPair getStoneBlock();

    protected abstract boolean enableBiomeGenBaseBlock();

    protected abstract GenType getGenType();

    public int getCraterSize() {
        return 0;
    }

    public int getTerrainLevel() {
        return this.getWaterLevel();
    }

    public double getDirtLayerSize() {
        return 3.0;
    }

    protected BlockMetaPair getIceBlock() {
        return new BlockMetaPair(Blocks.field_150403_cj, 0);
    }

    public void getCraterAdditions(ChunkPrimer primer, int x, int y, int z) {
    }

    public class GenBlocks {
        private WorldProvider provider;
        private Biome biome;
        private BlockMetaPair grass;
        private BlockMetaPair dirt;
        private BlockMetaPair stone;

        public GenBlocks(WorldProvider provider, Biome biome, BlockMetaPair blockGrass, BlockMetaPair blockDirt, BlockMetaPair blockStone) {
            this.provider = provider;
            this.biome = biome;
            this.grass = blockGrass;
            this.dirt = blockDirt;
            this.stone = blockStone;
        }

        public WorldProvider getWorldProvider() {
            return this.provider;
        }

        public Biome getBiome() {
            return this.biome;
        }

        public BlockMetaPair getGrassBlock() {
            return this.grass;
        }

        public BlockMetaPair getDirtBlock() {
            return this.dirt;
        }

        public BlockMetaPair getStoneBlock() {
            return this.stone;
        }
    }

    public static enum GenType {
        GC,
        VANILLA,
        END;

    }
}

