/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityBioReactor
extends TileEntityInventoryBase
implements ISharingEnergyProvider {
    public final CustomEnergyStorage storage = new CustomEnergyStorage(200000, 0, 800);
    public int burnTime;
    public int maxBurnTime;
    public int producePerTick;
    private int lastBurnTime;
    private int lastProducePerTick;

    public TileEntityBioReactor() {
        super(8, "bioReactor");
    }

    public static boolean isValidItem(ItemStack stack) {
        if (StackUtil.isValid(stack)) {
            Item item = stack.func_77973_b();
            if (TileEntityBioReactor.isValid(item)) {
                return true;
            }
            if (item instanceof ItemBlock) {
                return TileEntityBioReactor.isValid(Block.func_149634_a((Item)item));
            }
        }
        return false;
    }

    private static boolean isValid(Object o) {
        return o instanceof IPlantable || o instanceof IGrowable || o instanceof ItemFood;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.burnTime <= 0) {
            ArrayList<Item> types = null;
            if (!this.isRedstonePowered && this.storage.getEnergyStored() < this.storage.getMaxEnergyStored()) {
                for (int i = 0; i < this.inv.getSlots(); ++i) {
                    ItemStack stack = this.inv.getStackInSlot(i);
                    if (!StackUtil.isValid(stack)) continue;
                    Item item = stack.func_77973_b();
                    if (!TileEntityBioReactor.isValidItem(stack) || types != null && types.contains(item)) continue;
                    if (types == null) {
                        types = new ArrayList<Item>();
                    }
                    types.add(item);
                    this.inv.setStackInSlot(i, StackUtil.shrink(stack, 1));
                }
                this.func_70296_d();
            }
            if (types != null && !types.isEmpty()) {
                int amount = types.size();
                this.producePerTick = (int)Math.pow(amount * 2, 2.0);
                this.burnTime = this.maxBurnTime = 200 - (int)Math.pow(1.8, amount);
            } else {
                this.burnTime = 0;
                this.maxBurnTime = 0;
                this.producePerTick = 0;
            }
        } else {
            --this.burnTime;
            this.storage.receiveEnergyInternal(this.producePerTick, false);
        }
        if ((this.lastBurnTime != this.burnTime || this.lastProducePerTick != this.producePerTick) && this.sendUpdateWithInterval()) {
            this.lastBurnTime = this.burnTime;
            this.lastProducePerTick = this.producePerTick;
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("MaxBurnTime", this.maxBurnTime);
        compound.func_74768_a("ProducePerTick", this.producePerTick);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        this.burnTime = compound.func_74762_e("BurnTime");
        this.maxBurnTime = compound.func_74762_e("MaxBurnTime");
        this.producePerTick = compound.func_74762_e("ProducePerTick");
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> TileEntityBioReactor.isValidItem(stack);
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return ItemStackHandlerAA.REMOVE_FALSE;
    }

    @Override
    public int getEnergyToSplitShare() {
        return this.storage.getEnergyStored();
    }

    @Override
    public boolean doesShareEnergy() {
        return true;
    }

    @Override
    public EnumFacing[] getEnergyShareSides() {
        return EnumFacing.values();
    }

    @Override
    public boolean canShareTo(TileEntity tile) {
        return true;
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.storage;
    }

    @Override
    public int getComparatorStrength() {
        float calc = (float)this.storage.getEnergyStored() / (float)this.storage.getMaxEnergyStored() * 15.0f;
        return (int)calc;
    }
}

