/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import java.util.HashMap;
import java.util.Map;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.client.model.ModelBioGenerator;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderBioGenerator
extends TileEntitySpecialRenderer<TileEntityBioGenerator> {
    private static final int stages = 40;
    private ModelBioGenerator model = new ModelBioGenerator();
    private Map<EnumFacing, MekanismRenderer.DisplayInteger[]> energyDisplays = new HashMap<EnumFacing, MekanismRenderer.DisplayInteger[]>();

    public void render(TileEntityBioGenerator tileEntity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        if (tileEntity.bioFuelSlot.fluidStored > 0) {
            this.push();
            MekanismRenderer.glowOn();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            this.func_147499_a(MekanismRenderer.getBlocksTexture());
            this.getDisplayList(tileEntity.facing)[tileEntity.getScaledFuelLevel(39)].render();
            MekanismRenderer.glowOff();
            this.pop();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        this.func_147499_a(MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.RENDER, (String)"BioGenerator.png"));
        switch (tileEntity.facing.ordinal()) {
            case 2: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.render(0.0625f);
        GlStateManager.func_179121_F();
    }

    private MekanismRenderer.DisplayInteger[] getDisplayList(EnumFacing side) {
        if (this.energyDisplays.containsKey(side)) {
            return this.energyDisplays.get(side);
        }
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[40];
        MekanismRenderer.Model3D model3D = new MekanismRenderer.Model3D();
        model3D.baseBlock = Blocks.field_150355_j;
        model3D.setTexture(MekanismRenderer.energyIcon);
        for (int i = 0; i < 40; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            switch (side) {
                case NORTH: {
                    model3D.minZ = 0.5;
                    model3D.maxZ = 0.875;
                    model3D.minX = 0.1875;
                    model3D.maxX = 0.8215;
                    model3D.minY = 0.4375;
                    model3D.maxY = 0.4375 + (double)((float)i / 40.0f) * 0.4375;
                    break;
                }
                case SOUTH: {
                    model3D.minZ = 0.125;
                    model3D.maxZ = 0.5;
                    model3D.minX = 0.1875;
                    model3D.maxX = 0.8215;
                    model3D.minY = 0.4375;
                    model3D.maxY = 0.4375 + (double)((float)i / 40.0f) * 0.4375;
                    break;
                }
                case WEST: {
                    model3D.minX = 0.5;
                    model3D.maxX = 0.875;
                    model3D.minZ = 0.1875;
                    model3D.maxZ = 0.8215;
                    model3D.minY = 0.4375;
                    model3D.maxY = 0.4375 + (double)((float)i / 40.0f) * 0.4375;
                    break;
                }
                case EAST: {
                    model3D.minX = 0.125;
                    model3D.maxX = 0.5;
                    model3D.minZ = 0.1875;
                    model3D.maxZ = 0.8215;
                    model3D.minY = 0.4375;
                    model3D.maxY = 0.4375 + (double)((float)i / 40.0f) * 0.4375;
                }
            }
            MekanismRenderer.renderObject((MekanismRenderer.Model3D)model3D);
            MekanismRenderer.DisplayInteger.endList();
        }
        this.energyDisplays.put(side, displays);
        return displays;
    }

    private void pop() {
        GL11.glPopAttrib();
        GlStateManager.func_179121_F();
    }

    private void push() {
        GlStateManager.func_179094_E();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }
}

