/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.network;

import com.rwtema.extrautils2.network.XUPacketBuffer;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class PacketTypeHandlers {
    static HashMap<Class<?>, BiConsumer<XUPacketBuffer, Object>> writers = new HashMap();
    static HashMap<Class<?>, Function<XUPacketBuffer, Object>> readers = new HashMap();

    public static <T> Class<T> ensureValid(Class<T> clazz) {
        if (writers.containsKey(clazz) && readers.containsKey(clazz)) {
            return clazz;
        }
        throw new IllegalArgumentException("Unsupported class: " + clazz);
    }

    public static <T> void register(Class<T> clazz, BiConsumer<XUPacketBuffer, T> writer, Function<XUPacketBuffer, T> reader) {
        writers.put(clazz, writer);
        readers.put(clazz, (Function)((Object)writer));
    }

    static {
        PacketTypeHandlers.register(Integer.class, XUPacketBuffer::writeInt, XUPacketBuffer::readInt);
        PacketTypeHandlers.register(Boolean.class, XUPacketBuffer::writeBoolean, XUPacketBuffer::readBoolean);
        PacketTypeHandlers.register(String.class, XUPacketBuffer::writeString, XUPacketBuffer::readString);
        PacketTypeHandlers.register(Short.class, XUPacketBuffer::writeShort, XUPacketBuffer::readShort);
        PacketTypeHandlers.register(String.class, XUPacketBuffer::writeString, XUPacketBuffer::readString);
        PacketTypeHandlers.register(BlockPos.class, XUPacketBuffer::writeBlockPos, XUPacketBuffer::readBlockPos);
        PacketTypeHandlers.register(Double.class, XUPacketBuffer::writeDouble, XUPacketBuffer::readDouble);
        PacketTypeHandlers.register(Long.class, XUPacketBuffer::writeLong, XUPacketBuffer::readLong);
        PacketTypeHandlers.register(NBTTagCompound.class, XUPacketBuffer::writeNBT, XUPacketBuffer::readNBT);
    }
}

