/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.fluids.FluidRef;
import com.rwtema.extrautils2.itemhandler.EmptyHandlerModifiable;
import com.rwtema.extrautils2.itemhandler.IItemHandlerModifiableCompat;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.XUPacketServerToClient;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.ItemStackNonNull;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileProxy
extends XUTile {
    public NBTSerializable.NBTObject<Vec3i, NBTTagIntArray> block_offset = this.registerNBT("block", new NBTSerializable.NBTObject<Vec3i, NBTTagIntArray>((Vec3i)BlockPos.field_177992_a){

        @Override
        protected NBTTagIntArray serialize(Vec3i value) {
            return new NBTTagIntArray(new int[]{value.func_177958_n(), value.func_177956_o(), value.func_177952_p()});
        }

        @Override
        protected Vec3i deserialize(NBTTagIntArray nbtTagIntArray) {
            int[] ints = nbtTagIntArray.func_150302_c();
            return new Vec3i(ints[0], ints[1], ints[2]);
        }
    });
    ProxyFluid[] fluidProxies = null;
    ProxyItem[] itemProxies = null;

    public void onLoad() {
        this.refreshProxies();
    }

    public void refreshProxies() {
        Vec3i value = (Vec3i)this.block_offset.value;
        if (value.func_177958_n() == 0 && value.func_177956_o() == 0 && value.func_177952_p() == 0) {
            this.fluidProxies = null;
            this.itemProxies = null;
        } else {
            this.fluidProxies = new ProxyFluid[7];
            this.itemProxies = new ProxyItem[7];
        }
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.fluidProxies != null || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemProxies != null;
    }

    @Override
    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        int i = TileProxy.getSafeOrdinal(facing);
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.fluidProxies == null) {
                return null;
            }
            ProxyFluid fluidProxy = this.fluidProxies[i];
            if (fluidProxy == null) {
                this.fluidProxies[i] = fluidProxy = new ProxyFluid(this, this.field_174879_c.func_177971_a((Vec3i)this.block_offset.value), facing);
            }
            return (T)fluidProxy;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.itemProxies == null) {
                return null;
            }
            ProxyItem itemProxy = this.itemProxies[i];
            if (itemProxy == null) {
                this.itemProxies[i] = itemProxy = new ProxyItem(this, this.field_174879_c.func_177971_a((Vec3i)this.block_offset.value), facing);
            }
            return (T)itemProxy;
        }
        return null;
    }

    public static class ProxyItem
    extends WrapperBase<IItemHandler>
    implements IItemHandlerModifiableCompat {
        public ProxyItem(@Nonnull TileProxy proxy, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
            super(proxy, pos, side);
        }

        @Override
        protected Capability<IItemHandler> getCapInstance() {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        @Override
        protected IItemHandler emptyCap() {
            return EmptyHandlerModifiable.INSTANCE;
        }

        @Override
        public void setStackInSlot(int slot, @ItemStackNonNull ItemStack stack) {
            if (!this.acquireLock()) {
                return;
            }
            IItemHandler cap = (IItemHandler)this.getCap();
            if (cap instanceof IItemHandlerModifiable) {
                ((IItemHandlerModifiable)cap).setStackInSlot(slot, stack);
            }
            this.releaseLock();
        }

        @Override
        public int getSlots() {
            if (!this.acquireLock()) {
                return 0;
            }
            IItemHandler cap = (IItemHandler)this.getCap();
            int slots = cap.getSlots();
            this.releaseLock();
            return slots;
        }

        @Override
        @ItemStackNonNull
        public ItemStack getStackInSlot(int slot) {
            if (!this.acquireLock()) {
                return StackHelper.empty();
            }
            IItemHandler cap = (IItemHandler)this.getCap();
            ItemStack stack = cap.getStackInSlot(slot);
            this.releaseLock();
            return stack;
        }

        @Override
        @ItemStackNonNull
        public ItemStack insertItem(int slot, @ItemStackNonNull ItemStack stack, boolean simulate) {
            if (StackHelper.isNull(stack) || !this.acquireLock()) {
                return stack;
            }
            IItemHandler cap = (IItemHandler)this.getCap();
            ItemStack insert = cap.insertItem(slot, stack, simulate);
            this.releaseLock();
            return insert;
        }

        @Override
        @ItemStackNonNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0 || !this.acquireLock()) {
                return StackHelper.empty();
            }
            IItemHandler cap = (IItemHandler)this.getCap();
            ItemStack extract = cap.extractItem(slot, amount, simulate);
            this.releaseLock();
            return extract;
        }
    }

    public static class ProxyFluid
    extends WrapperBase<IFluidHandler>
    implements IFluidHandler {
        public ProxyFluid(@Nonnull TileProxy proxy, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
            super(proxy, pos, side);
        }

        @Override
        protected Capability<IFluidHandler> getCapInstance() {
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        }

        @Override
        protected IFluidHandler emptyCap() {
            return EmptyFluidHandler.INSTANCE;
        }

        public IFluidTankProperties[] getTankProperties() {
            if (!this.acquireLock()) {
                return EmptyFluidHandler.EMPTY_TANK_PROPERTIES_ARRAY;
            }
            IFluidHandler cap = (IFluidHandler)this.getCap();
            IFluidTankProperties[] tankProperties = cap.getTankProperties();
            this.releaseLock();
            return tankProperties;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (!this.acquireLock()) {
                return 0;
            }
            IFluidHandler cap = (IFluidHandler)this.getCap();
            int fill = cap.fill(resource, doFill);
            this.releaseLock();
            return fill;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (!this.acquireLock()) {
                return null;
            }
            IFluidHandler cap = (IFluidHandler)this.getCap();
            FluidStack drain = cap.drain(resource, doDrain);
            this.releaseLock();
            return drain;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (!this.acquireLock()) {
                return null;
            }
            IFluidHandler cap = (IFluidHandler)this.getCap();
            FluidStack drain = cap.drain(maxDrain, doDrain);
            this.releaseLock();
            return drain;
        }
    }

    public static abstract class WrapperBase<C> {
        boolean lock = false;
        @Nonnull
        BlockPos pos;
        @Nonnull
        EnumFacing side;
        @Nonnull
        TileProxy proxy;

        public WrapperBase(@Nonnull TileProxy proxy, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
            this.pos = pos;
            this.side = side;
            this.proxy = proxy;
        }

        protected void sendParticle(Object obj) {
        }

        protected C getCap() {
            TileEntity tile = this.proxy.field_145850_b.func_175625_s(this.pos);
            if (tile == null || tile.getClass() == TileProxy.class) {
                return this.emptyCap();
            }
            Capability<C> capability = this.getCapInstance();
            if (!tile.hasCapability(capability, this.side)) {
                return this.emptyCap();
            }
            Object t = tile.getCapability(capability, this.side);
            if (t == null) {
                return this.emptyCap();
            }
            return (C)t;
        }

        protected abstract Capability<C> getCapInstance();

        protected abstract C emptyCap();

        public boolean acquireLock() {
            if (this.lock) {
                return false;
            }
            this.lock = true;
            return true;
        }

        public void releaseLock() {
            this.lock = false;
        }
    }

    @NetworkHandler.XUPacket
    public static class PacketProxyFlow
    extends XUPacketServerToClient {
        BlockPos start;
        BlockPos end;
        EnumFacing end_side;
        Object obj;

        @Override
        public void writeData() throws Exception {
            this.writeBlockPos(this.start);
            this.writeBlockPos(this.end);
            this.writeByte(XUTile.getSafeOrdinal(this.end_side));
            if (this.obj instanceof ItemRef) {
                this.writeByte(0);
                ((ItemRef)this.obj).write(this);
            } else if (this.obj instanceof FluidRef) {
                this.writeByte(1);
                ((FluidRef)this.obj).write(this);
            }
            throw new RuntimeException("Invalid Object " + this.obj);
        }

        @Override
        public void readData(EntityPlayer player) {
            this.start = this.readBlockPos();
            this.end = this.readBlockPos();
            this.end_side = XUTile.getSafeFacing(this.readByte());
            byte b = this.readByte();
            if (b == 0) {
                this.obj = ItemRef.read(this);
            } else if (b == 1) {
                this.obj = FluidRef.read(this);
            } else {
                throw new RuntimeException("Invalid Object Type " + b);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Runnable doStuffClient() {
            return new Runnable(){

                @Override
                public void run() {
                }
            };
        }
    }
}

