/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gas;

import mekanism.api.gas.GasRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class Gas {
    private String name;
    private String unlocalizedName;
    private Fluid fluid;
    private ResourceLocation iconLocation;
    private TextureAtlasSprite sprite;
    private boolean visible = true;
    private boolean from_fluid = false;
    private int tint = 0xFFFFFF;

    public Gas(String s, String icon) {
        this.unlocalizedName = this.name = s;
        this.iconLocation = new ResourceLocation(icon);
    }

    public Gas(String s, ResourceLocation icon) {
        this.unlocalizedName = this.name = s;
        this.iconLocation = icon;
    }

    public Gas(String s, int t) {
        this.unlocalizedName = this.name = s;
        this.iconLocation = new ResourceLocation("mekanism", "blocks/liquid/liquid");
        this.tint = t;
    }

    public Gas(Fluid f) {
        this.unlocalizedName = this.name = f.getName();
        this.iconLocation = f.getStill();
        this.fluid = f;
        this.from_fluid = true;
        this.tint = f.getColor() & 0xFFFFFF;
    }

    public static Gas readFromNBT(NBTTagCompound nbtTags) {
        if (nbtTags == null || nbtTags.func_82582_d()) {
            return null;
        }
        return GasRegistry.getGas(nbtTags.func_74779_i("gasName"));
    }

    public String getName() {
        return this.name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Gas setVisible(boolean v) {
        this.visible = v;
        return this;
    }

    public String getUnlocalizedName() {
        return "gas." + this.unlocalizedName;
    }

    public Gas setUnlocalizedName(String s) {
        this.unlocalizedName = s;
        return this;
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)this.getUnlocalizedName());
    }

    public ResourceLocation getIcon() {
        if (this.from_fluid) {
            return this.getFluid().getStill();
        }
        return this.iconLocation;
    }

    public TextureAtlasSprite getSprite() {
        TextureMap texMap = Minecraft.func_71410_x().func_147117_R();
        if (this.from_fluid) {
            return texMap.func_110572_b(this.fluid.getStill().toString());
        }
        if (this.sprite == null) {
            this.sprite = texMap.func_110572_b(this.getIcon().toString());
        }
        return this.sprite;
    }

    TextureAtlasSprite getSpriteRaw() {
        return this.sprite;
    }

    public Gas registerIcon(TextureMap map) {
        map.func_174942_a(this.iconLocation);
        this.from_fluid = false;
        return this;
    }

    public Gas updateIcon(TextureMap map) {
        TextureAtlasSprite tex = map.getTextureExtry(this.iconLocation.toString());
        if (tex != null) {
            this.sprite = tex;
        }
        return this;
    }

    public int getID() {
        return GasRegistry.getGasID(this);
    }

    public NBTTagCompound write(NBTTagCompound nbtTags) {
        nbtTags.func_74778_a("gasName", this.getName());
        return nbtTags;
    }

    public boolean hasFluid() {
        return this.fluid != null;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public Gas registerFluid(String name) {
        if (this.fluid == null) {
            if (FluidRegistry.getFluid((String)name) == null) {
                this.fluid = new Fluid(name, this.getIcon(), this.getIcon(), this.getTint());
                FluidRegistry.registerFluid((Fluid)this.fluid);
            } else {
                this.fluid = FluidRegistry.getFluid((String)name);
            }
        }
        return this;
    }

    public Gas registerFluid() {
        return this.registerFluid(this.getName());
    }

    public String toString() {
        return this.name;
    }

    public int getTint() {
        return this.tint;
    }

    public void setTint(int tint) {
        this.tint = tint;
    }
}

