/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import mekanism.common.MekanismSounds;
import mekanism.common.config.MekanismConfig;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SparkleAnimation {
    public TileEntity pointer;
    public Random random = new Random();
    public Set<BlockPos> iteratedNodes = new HashSet<BlockPos>();
    public INodeChecker nodeChecker;

    public SparkleAnimation(TileEntity tileEntity, INodeChecker checker) {
        this.pointer = tileEntity;
        this.nodeChecker = checker;
    }

    public void run() {
        try {
            if (MekanismConfig.current().general.dynamicTankEasterEgg.val()) {
                this.pointer.func_145831_w().func_184148_a(null, (double)this.pointer.func_174877_v().func_177958_n(), (double)this.pointer.func_174877_v().func_177956_o(), (double)this.pointer.func_174877_v().func_177952_p(), MekanismSounds.CJ_EASTER_EGG, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            this.loop(this.pointer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new Thread(() -> {
                World world = this.pointer.func_145831_w();
                int count = MekanismConfig.current().client.multiblockSparkleIntensity.val();
                for (BlockPos coord : this.iteratedNodes) {
                    for (int i = 0; i < count; ++i) {
                        world.func_175688_a(EnumParticleTypes.REDSTONE, (double)coord.func_177958_n() + this.random.nextDouble(), (double)coord.func_177956_o() + -0.01, (double)coord.func_177952_p() + this.random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.REDSTONE, (double)coord.func_177958_n() + this.random.nextDouble(), (double)coord.func_177956_o() + 1.01, (double)coord.func_177952_p() + this.random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.REDSTONE, (double)coord.func_177958_n() + this.random.nextDouble(), (double)coord.func_177956_o() + this.random.nextDouble(), (double)coord.func_177952_p() + -0.01, 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.REDSTONE, (double)coord.func_177958_n() + this.random.nextDouble(), (double)coord.func_177956_o() + this.random.nextDouble(), (double)coord.func_177952_p() + 1.01, 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.REDSTONE, (double)coord.func_177958_n() + -0.01, (double)coord.func_177956_o() + this.random.nextDouble(), (double)coord.func_177952_p() + this.random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.REDSTONE, (double)coord.func_177958_n() + 1.01, (double)coord.func_177956_o() + this.random.nextDouble(), (double)coord.func_177952_p() + this.random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }).start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loop(TileEntity tileEntity) {
        World world = this.pointer.func_145831_w();
        LinkedList<BlockPos> toIterate = new LinkedList<BlockPos>();
        toIterate.add(tileEntity.func_174877_v());
        while (toIterate.peekFirst() != null) {
            BlockPos testPos = (BlockPos)toIterate.pop();
            if (this.iteratedNodes.contains(testPos)) continue;
            this.iteratedNodes.add(testPos);
            for (EnumFacing side : EnumFacing.field_82609_l) {
                TileEntity tile;
                BlockPos coord = testPos.func_177972_a(side);
                if (this.iteratedNodes.contains(coord) || !world.func_175667_e(coord) || (tile = world.func_175625_s(coord)) == null || !this.isNode(tile)) continue;
                toIterate.addLast(coord);
            }
        }
    }

    public boolean isNode(TileEntity tile) {
        return this.nodeChecker.isNode(tile);
    }

    public static interface INodeChecker {
        public boolean isNode(TileEntity var1);
    }
}

