/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine.other;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.machine.other.MetallurgicInfuserRecipeWrapper;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.util.MekanismUtils;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class MetallurgicInfuserRecipeCategory
extends BaseRecipeCategory {
    private final IDrawable background;
    @Nullable
    private MetallurgicInfuserRecipe tempRecipe;

    public MetallurgicInfuserRecipeCategory(IGuiHelper helper) {
        super(helper, "mekanism:gui/GuiMetallurgicInfuser.png", RecipeHandler.Recipe.METALLURGIC_INFUSER.jeiRecipeUid, "tile.MachineBlock.MetallurgicInfuser.name", GuiProgress.ProgressBar.MEDIUM);
        this.xOffset = 5;
        this.yOffset = 16;
        this.background = this.guiHelper.createDrawable(new ResourceLocation(this.guiTexture), this.xOffset, this.yOffset, 166, 54);
    }

    public static List<ItemStack> getInfuseStacks(InfuseType type) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, InfuseObject> obj : InfuseRegistry.getObjectMap().entrySet()) {
            if (obj.getValue().type != type) continue;
            ret.add(obj.getKey());
        }
        return ret;
    }

    @Override
    public void addGuiElements() {
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.EXTRA, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 16, 34));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.INPUT, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 50, 42));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.POWER, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 142, 34).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.OUTPUT, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 108, 42));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public double getLevel() {
                return 1.0;
            }
        }, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 164, 15));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return (double)MetallurgicInfuserRecipeCategory.this.timer.getValue() / 20.0;
            }
        }, GuiProgress.ProgressBar.MEDIUM, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 70, 46));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        if (!(recipeWrapper instanceof MetallurgicInfuserRecipeWrapper)) {
            return;
        }
        this.tempRecipe = ((MetallurgicInfuserRecipeWrapper)recipeWrapper).getRecipe();
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 45, 26);
        itemStacks.init(1, false, 103, 26);
        itemStacks.init(2, true, 11, 18);
        itemStacks.set(0, ((InfusionInput)this.tempRecipe.getInput()).inputStack);
        itemStacks.set(1, ((ItemStackOutput)this.tempRecipe.getOutput()).output);
        itemStacks.set(2, MetallurgicInfuserRecipeCategory.getInfuseStacks(((InfusionInput)this.tempRecipe.getInput()).infuse.type));
    }
}

