/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.EnumColor;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.FluidRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.obj.TransmitterModel;
import mekanism.client.render.tileentity.RenderConfigurableMachine;
import mekanism.client.render.tileentity.RenderFluidTank;
import mekanism.client.render.tileentity.RenderThermalEvaporationController;
import mekanism.client.render.transmitter.RenderLogisticalTransporter;
import mekanism.client.render.transmitter.RenderMechanicalPipe;
import mekanism.common.base.IMetaItem;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class MekanismRenderer {
    public static TextureAtlasSprite[] colors = new TextureAtlasSprite[256];
    public static TextureAtlasSprite energyIcon;
    public static TextureAtlasSprite heatIcon;
    public static TextureAtlasSprite laserIcon;
    public static float GAS_RENDER_BASE;
    public static Map<TransmissionType, TextureAtlasSprite> overlays;
    public static int[] directionMap;
    public static RenderConfigurableMachine machineRenderer;
    public static TextureAtlasSprite missingIcon;
    private static float lightmapLastX;
    private static float lightmapLastY;
    private static boolean optifineBreak;
    private static String[] simpleSides;
    private static TextureMap texMap;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new MekanismRenderer());
    }

    public static void registerItemRender(String domain, Item item) {
        if (item instanceof IMetaItem) {
            IMetaItem metaItem = (IMetaItem)item;
            ArrayList<ModelResourceLocation> variants = new ArrayList<ModelResourceLocation>();
            for (int i = 0; i < metaItem.getVariants(); ++i) {
                if (metaItem.getTexture(i) == null) continue;
                ModelResourceLocation loc = new ModelResourceLocation(domain + ":" + metaItem.getTexture(i), "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)loc);
                variants.add(loc);
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(domain + ":" + metaItem.getTexture(i))});
            }
            return;
        }
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    public static void initFluidTextures(TextureMap map) {
        missingIcon = map.func_174944_f();
        texMap = map;
    }

    public static TextureAtlasSprite getBaseFluidTexture(Fluid fluid, FluidType type) {
        if (fluid == null || type == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getStill() : fluid.getFlowing();
        TextureAtlasSprite sprite = texMap.getTextureExtry(spriteLocation.toString());
        return sprite != null ? sprite : missingIcon;
    }

    public static TextureAtlasSprite getFluidTexture(FluidStack fluidStack, FluidType type) {
        if (fluidStack == null || fluidStack.getFluid() == null || type == null) {
            return missingIcon;
        }
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getStill(fluidStack) : fluid.getFlowing(fluidStack);
        TextureAtlasSprite sprite = texMap.getTextureExtry(spriteLocation.toString());
        return sprite != null ? sprite : missingIcon;
    }

    public static RenderState pauseRenderer(Tessellator tess) {
        if (MekanismRenderer.isDrawing(tess)) {
            RenderState renderState = new RenderState(tess.func_178180_c().func_178973_g(), tess.func_178180_c().func_178979_i());
            tess.func_78381_a();
            return renderState;
        }
        return null;
    }

    public static void resumeRenderer(Tessellator tess, RenderState renderState) {
        if (renderState != null) {
            tess.func_178180_c().func_181668_a(renderState.prevMode, renderState.prevFormat);
        }
    }

    public static boolean isDrawing(Tessellator tess) {
        return tess.func_178180_c().field_179010_r;
    }

    public static boolean isDrawing(BufferBuilder buffer) {
        return buffer.field_179010_r;
    }

    public static BakedQuad iconTransform(BakedQuad quad, TextureAtlasSprite sprite) {
        int[] vertices = new int[quad.func_178209_a().length];
        System.arraycopy(quad.func_178209_a(), 0, vertices, 0, vertices.length);
        for (int i = 0; i < 4; ++i) {
            int uvIndex;
            int j = quad.getFormat().func_181719_f() * i;
            if (j + (uvIndex = quad.getFormat().func_177344_b(0) / 4) + 1 >= vertices.length) continue;
            vertices[j + uvIndex] = Float.floatToRawIntBits(sprite.func_94214_a((double)quad.func_187508_a().func_188537_a(Float.intBitsToFloat(vertices[j + uvIndex]))));
            vertices[j + uvIndex + 1] = Float.floatToRawIntBits(sprite.func_94207_b((double)quad.func_187508_a().func_188536_b(Float.intBitsToFloat(vertices[j + uvIndex + 1]))));
        }
        return new BakedQuad(vertices, quad.func_178211_c(), quad.func_178210_d(), sprite, quad.shouldApplyDiffuseLighting(), quad.getFormat());
    }

    public static BakedQuad rotate(BakedQuad quad, int amount) {
        int[] vertices = new int[quad.func_178209_a().length];
        System.arraycopy(quad.func_178209_a(), 0, vertices, 0, vertices.length);
        for (int i = 0; i < 4; ++i) {
            int nextIndex = (i + amount) % 4;
            int quadSize = quad.getFormat().func_181719_f();
            int uvIndex = quad.getFormat().func_177344_b(0) / 4;
            if (i + uvIndex + 1 >= vertices.length) continue;
            vertices[quadSize * i + uvIndex] = quad.func_178209_a()[quadSize * nextIndex + uvIndex];
            vertices[quadSize * i + uvIndex + 1] = quad.func_178209_a()[quadSize * nextIndex + uvIndex + 1];
        }
        return new BakedQuad(vertices, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
    }

    public static void prepFlowing(Model3D model, FluidStack fluid) {
        TextureAtlasSprite still = MekanismRenderer.getFluidTexture(fluid, FluidType.STILL);
        TextureAtlasSprite flowing = MekanismRenderer.getFluidTexture(fluid, FluidType.FLOWING);
        model.setTextures(still, still, flowing, flowing, flowing, flowing);
    }

    public static void renderObject(Model3D object) {
        if (object == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)object.minX, (double)object.minY, (double)object.minZ);
        RenderResizableCuboid.INSTANCE.renderCube(object);
        GlStateManager.func_179121_F();
    }

    public static void color(EnumColor color) {
        MekanismRenderer.color(color, 1.0f);
    }

    public static void color(EnumColor color, float alpha) {
        MekanismRenderer.color(color, alpha, 1.0f);
    }

    public static void color(EnumColor color, float alpha, float multiplier) {
        GL11.glColor4f((float)(color.getColor(0) * multiplier), (float)(color.getColor(1) * multiplier), (float)(color.getColor(2) * multiplier), (float)alpha);
    }

    public static void resetColor() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static TextureAtlasSprite getColorIcon(EnumColor color) {
        return colors[color.ordinal()];
    }

    public static void glowOn() {
        MekanismRenderer.glowOn(15);
    }

    public static void glowOn(int glow) {
        GL11.glPushAttrib((int)64);
        try {
            lightmapLastX = OpenGlHelper.lastBrightnessX;
            lightmapLastY = OpenGlHelper.lastBrightnessY;
        }
        catch (NoSuchFieldError e) {
            optifineBreak = true;
        }
        float glowRatioX = Math.min((float)glow / 15.0f * 240.0f + lightmapLastX, 240.0f);
        float glowRatioY = Math.min((float)glow / 15.0f * 240.0f + lightmapLastY, 240.0f);
        if (!optifineBreak) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)glowRatioX, (float)glowRatioY);
        }
    }

    public static void glowOff() {
        if (!optifineBreak) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapLastX, (float)lightmapLastY);
        }
        GL11.glPopAttrib();
    }

    public static void blendOn() {
        GL11.glPushAttrib((int)16448);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    public static void blendOff() {
        GL11.glPopAttrib();
    }

    public static void cullFrontFace() {
        GL11.glEnable((int)2884);
        GL11.glCullFace((int)1028);
    }

    public static void disableCullFace() {
        GL11.glCullFace((int)1029);
        GL11.glDisable((int)2884);
    }

    public static void colorFluid(FluidStack fluid) {
        MekanismRenderer.color(fluid.getFluid().getColor(fluid));
    }

    public static void color(int color) {
        float cR = (float)(color >> 16 & 0xFF) / 255.0f;
        float cG = (float)(color >> 8 & 0xFF) / 255.0f;
        float cB = (float)(color & 0xFF) / 255.0f;
        GL11.glColor3f((float)cR, (float)cG, (float)cB);
    }

    public static float getPartialTick() {
        return Minecraft.func_71410_x().func_184121_ak();
    }

    public static ResourceLocation getBlocksTexture() {
        return TextureMap.field_110575_b;
    }

    @SubscribeEvent
    public void onStitch(TextureStitchEvent.Pre event) {
        for (EnumColor enumColor : EnumColor.values()) {
            MekanismRenderer.colors[enumColor.ordinal()] = event.getMap().func_174942_a(new ResourceLocation("mekanism:blocks/overlay/overlay_" + enumColor.unlocalizedName));
        }
        for (Enum enum_ : TransmissionType.values()) {
            overlays.put((TransmissionType)enum_, event.getMap().func_174942_a(new ResourceLocation("mekanism:blocks/overlay/" + ((TransmissionType)enum_).getTransmission() + "Overlay")));
        }
        energyIcon = event.getMap().func_174942_a(new ResourceLocation("mekanism:blocks/liquid/LiquidEnergy"));
        heatIcon = event.getMap().func_174942_a(new ResourceLocation("mekanism:blocks/liquid/LiquidHeat"));
        laserIcon = event.getMap().func_174942_a(new ResourceLocation("mekanism:blocks/Laser"));
        event.getMap().func_174942_a(new ResourceLocation("mekanism:blocks/liquid/LiquidHeavyWater"));
        TransmitterModel.registerIcons(event.getMap());
        for (Gas gas : GasRegistry.getRegisteredGasses()) {
            gas.registerIcon(event.getMap());
        }
        for (InfuseType type : InfuseRegistry.getInfuseMap().values()) {
            type.setIcon(event.getMap().func_174942_a(type.iconResource));
        }
        FluidRenderer.resetDisplayInts();
        RenderThermalEvaporationController.resetDisplayInts();
        RenderFluidTank.resetDisplayInts();
    }

    @SubscribeEvent
    public void onStitch(TextureStitchEvent.Post event) {
        MekanismRenderer.initFluidTextures(event.getMap());
        RenderLogisticalTransporter.onStitch(event.getMap());
        RenderMechanicalPipe.onStitch();
        for (Gas gas : GasRegistry.getRegisteredGasses()) {
            gas.updateIcon(event.getMap());
        }
    }

    static {
        GAS_RENDER_BASE = 0.2f;
        overlays = new HashMap<TransmissionType, TextureAtlasSprite>();
        directionMap = new int[]{3, 0, 1, 2};
        machineRenderer = new RenderConfigurableMachine();
        optifineBreak = false;
        simpleSides = new String[]{"Bottom", "Top", "Front", "Back", "Left", "Right"};
        texMap = null;
    }

    public static class DisplayInteger {
        public int display;

        public static DisplayInteger createAndStart() {
            DisplayInteger newInteger = new DisplayInteger();
            newInteger.display = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)newInteger.display, (int)4864);
            return newInteger;
        }

        public static void endList() {
            GL11.glEndList();
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.display;
            return code;
        }

        public boolean equals(Object obj) {
            return obj instanceof DisplayInteger && ((DisplayInteger)obj).display == this.display;
        }

        public void render() {
            GL11.glCallList((int)this.display);
        }
    }

    public static class Model3D {
        public double posX;
        public double posY;
        public double posZ;
        public double minX;
        public double minY;
        public double minZ;
        public double maxX;
        public double maxY;
        public double maxZ;
        public double textureStartX = 0.0;
        public double textureStartY = 0.0;
        public double textureStartZ = 0.0;
        public double textureSizeX = 16.0;
        public double textureSizeY = 16.0;
        public double textureSizeZ = 16.0;
        public double textureOffsetX = 0.0;
        public double textureOffsetY = 0.0;
        public double textureOffsetZ = 0.0;
        public int[] textureFlips = new int[]{2, 2, 2, 2, 2, 2};
        public TextureAtlasSprite[] textures = new TextureAtlasSprite[6];
        public boolean[] renderSides = new boolean[]{true, true, true, true, true, true, false};
        public Block baseBlock = Blocks.field_150354_m;

        public final void setBlockBounds(double xNeg, double yNeg, double zNeg, double xPos, double yPos, double zPos) {
            this.minX = xNeg;
            this.minY = yNeg;
            this.minZ = zNeg;
            this.maxX = xPos;
            this.maxY = yPos;
            this.maxZ = zPos;
        }

        public double sizeX() {
            return this.maxX - this.minX;
        }

        public double sizeY() {
            return this.maxY - this.minY;
        }

        public double sizeZ() {
            return this.maxZ - this.minZ;
        }

        public void setSideRender(EnumFacing side, boolean value) {
            this.renderSides[side.ordinal()] = value;
        }

        public boolean shouldSideRender(EnumFacing side) {
            return this.renderSides[side.ordinal()];
        }

        public TextureAtlasSprite getBlockTextureFromSide(int i) {
            return this.textures[i];
        }

        public void setTexture(TextureAtlasSprite tex) {
            Arrays.fill(this.textures, tex);
        }

        public void setTextures(TextureAtlasSprite down, TextureAtlasSprite up, TextureAtlasSprite north, TextureAtlasSprite south, TextureAtlasSprite west, TextureAtlasSprite east) {
            this.textures[0] = down;
            this.textures[1] = up;
            this.textures[2] = north;
            this.textures[3] = south;
            this.textures[4] = west;
            this.textures[5] = east;
        }
    }

    public static class RenderState {
        protected final VertexFormat prevFormat;
        protected final int prevMode;

        public RenderState(VertexFormat prevFormat, int prevMode) {
            this.prevFormat = prevFormat;
            this.prevMode = prevMode;
        }
    }

    public static interface ICustomBlockIcon {
        public ResourceLocation getIcon(ItemStack var1, int var2);
    }

    public static enum FluidType {
        STILL,
        FLOWING;

    }
}

