/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.client.render.obj.GlowPanelModel;
import mekanism.client.render.obj.TransmitterModel;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MekanismOBJModel
extends OBJModel {
    public OBJModelType modelType;
    public ResourceLocation location;

    public MekanismOBJModel(OBJModelType type, OBJModel.MaterialLibrary matLib, ResourceLocation modelLocation) {
        super(matLib, modelLocation);
        this.modelType = type;
        this.location = modelLocation;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel preBaked = super.bake(state, format, bakedTextureGetter);
        if (this.modelType == OBJModelType.GLOW_PANEL) {
            return new GlowPanelModel(preBaked, this, state, format, GlowPanelModel.getTexturesForOBJModel(preBaked), null);
        }
        if (this.modelType == OBJModelType.TRANSMITTER) {
            return new TransmitterModel(preBaked, this, state, format, TransmitterModel.getTexturesForOBJModel(preBaked), null);
        }
        return null;
    }

    public IModel process(ImmutableMap<String, String> customData) {
        return new MekanismOBJModel(this.modelType, this.getMatLib(), this.location);
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        return new MekanismOBJModel(this.modelType, this.getMatLib().makeLibWithReplacements(textures), this.location);
    }

    public Collection<ResourceLocation> getTextures() {
        ArrayList<ResourceLocation> superlist = new ArrayList<ResourceLocation>();
        for (ResourceLocation r : super.getTextures()) {
            if (r.func_110623_a().startsWith("#")) continue;
            superlist.add(r);
        }
        return superlist;
    }

    public static enum OBJModelType {
        GLOW_PANEL,
        TRANSMITTER;

    }
}

