/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import java.util.Random;
import mekanism.api.IMekWrench;
import mekanism.api.gas.IGasItem;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ITierItem;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.block.states.BlockStateGasTank;
import mekanism.common.integration.wrenches.Wrenches;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGasTank
extends BlockContainer {
    private static final AxisAlignedBB TANK_BOUNDS = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);

    public BlockGasTank() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(8.0f);
        this.func_149647_a(Mekanism.tabMekanism);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateGasTank(this);
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = MekanismUtils.getTileEntitySafe(worldIn, pos);
        if (tile instanceof TileEntityGasTank) {
            TileEntityGasTank tank = (TileEntityGasTank)tile;
            if (tank.facing != null) {
                state = state.func_177226_a((IProperty)BlockStateFacing.facingProperty, (Comparable)tank.facing);
            }
            if (tank.tier != null) {
                state = state.func_177226_a(BlockStateGasTank.typeProperty, (Comparable)((Object)tank.tier));
            }
        }
        return state;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        int side = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 3;
        switch (side) {
            case 0: {
                change = 2;
                break;
            }
            case 1: {
                change = 5;
                break;
            }
            case 2: {
                change = 3;
                break;
            }
            case 3: {
                change = 4;
            }
        }
        tileEntity.setFacing((short)change);
        tileEntity.redstone = world.func_175687_A(pos) > 0;
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityBasicBlock) {
            ((TileEntityBasicBlock)tileEntity).onNeighborChange(neighborBlock);
        }
    }

    @Deprecated
    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return SecurityUtils.canAccess(player, tile) ? super.func_180647_a(state, player, world, pos) : 0.0f;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        RayTraceResult raytrace;
        IMekWrench wrenchHandler;
        if (world.field_72995_K) {
            return true;
        }
        TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_175625_s(pos);
        ItemStack stack = entityplayer.func_184586_b(hand);
        if (!stack.func_190926_b() && (wrenchHandler = Wrenches.getHandler(stack)) != null && wrenchHandler.canUseWrench(entityplayer, hand, stack, raytrace = new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos))) {
            if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                wrenchHandler.wrenchUsed(entityplayer, hand, stack, raytrace);
                if (entityplayer.func_70093_af()) {
                    this.dismantleBlock(state, world, pos, false);
                    return true;
                }
                if (tileEntity != null) {
                    int change = tileEntity.facing.func_176746_e().ordinal();
                    tileEntity.setFacing((short)change);
                    world.func_175685_c(pos, (Block)this, true);
                }
            } else {
                SecurityUtils.displayNoAccess(entityplayer);
            }
            return true;
        }
        if (tileEntity != null && !entityplayer.func_70093_af()) {
            if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                entityplayer.openGui((Object)Mekanism.instance, 10, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                SecurityUtils.displayNoAccess(entityplayer);
            }
            return true;
        }
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && willHarvest) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, this.getPickBlock(state, null, world, pos, player));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_175698_g(pos);
    }

    public ItemStack dismantleBlock(IBlockState state, World world, BlockPos pos, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(state, null, world, pos, null);
        world.func_175698_g(pos);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return null;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return TANK_BOUNDS;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityGasTank();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ISecurityItem securityItem;
        TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_175625_s(pos);
        ItemStack itemStack = new ItemStack(MekanismBlocks.GasTank);
        if (itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (tileEntity instanceof ISecurityTile && (securityItem = (ISecurityItem)itemStack.func_77973_b()).hasSecurity(itemStack)) {
            securityItem.setOwnerUUID(itemStack, tileEntity.getSecurity().getOwnerUUID());
            securityItem.setSecurity(itemStack, tileEntity.getSecurity().getMode());
        }
        if (tileEntity instanceof ISideConfiguration) {
            TileEntityGasTank config = tileEntity;
            config.getConfig().write(ItemDataUtils.getDataMap(itemStack));
            config.getEjector().write(ItemDataUtils.getDataMap(itemStack));
        }
        ITierItem tierItem = (ITierItem)itemStack.func_77973_b();
        tierItem.setBaseTier(itemStack, tileEntity.tier.getBaseTier());
        IGasItem storageTank = (IGasItem)itemStack.func_77973_b();
        storageTank.setGas(itemStack, tileEntity.gasTank.getGas());
        ISustainedInventory inventory = (ISustainedInventory)itemStack.func_77973_b();
        inventory.setInventory(tileEntity.getInventory(new Object[0]), itemStack);
        return itemStack;
    }

    @Deprecated
    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @Deprecated
    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_175625_s(pos);
        return tileEntity.getRedstoneLevel();
    }

    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        EnumFacing[] valid = new EnumFacing[6];
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock basicTile = (TileEntityBasicBlock)tile;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!basicTile.canSetFacing(dir.ordinal())) continue;
                valid[dir.ordinal()] = dir;
            }
        }
        return valid;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntityBasicBlock basicTile;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBasicBlock && (basicTile = (TileEntityBasicBlock)tile).canSetFacing(axis.ordinal())) {
            basicTile.setFacing((short)axis.ordinal());
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

