/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import io.netty.buffer.ByteBuf;
import mekanism.api.TileNetworkList;
import mekanism.common.content.miner.MItemStackFilter;
import mekanism.common.content.miner.MMaterialFilter;
import mekanism.common.content.miner.MModIDFilter;
import mekanism.common.content.miner.MOreDictFilter;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class MinerFilter {
    public ItemStack replaceStack = ItemStack.field_190927_a;
    public boolean requireStack;

    public static MinerFilter readFromNBT(NBTTagCompound nbtTags) {
        int type = nbtTags.func_74762_e("type");
        MinerFilter filter = null;
        if (type == 0) {
            filter = new MItemStackFilter();
        } else if (type == 1) {
            filter = new MOreDictFilter();
        } else if (type == 2) {
            filter = new MMaterialFilter();
        } else if (type == 3) {
            filter = new MModIDFilter();
        }
        ((MinerFilter)filter).read(nbtTags);
        return filter;
    }

    public static MinerFilter readFromPacket(ByteBuf dataStream) {
        int type = dataStream.readInt();
        MinerFilter filter = null;
        if (type == 0) {
            filter = new MItemStackFilter();
        } else if (type == 1) {
            filter = new MOreDictFilter();
        } else if (type == 2) {
            filter = new MMaterialFilter();
        } else if (type == 3) {
            filter = new MModIDFilter();
        }
        ((MinerFilter)filter).read(dataStream);
        return filter;
    }

    public abstract boolean canFilter(ItemStack var1);

    public NBTTagCompound write(NBTTagCompound nbtTags) {
        nbtTags.func_74757_a("requireStack", this.requireStack);
        if (!this.replaceStack.func_190926_b()) {
            nbtTags.func_74782_a("replaceStack", (NBTBase)this.replaceStack.func_77955_b(new NBTTagCompound()));
        }
        return nbtTags;
    }

    protected void read(NBTTagCompound nbtTags) {
        this.requireStack = nbtTags.func_74767_n("requireStack");
        if (nbtTags.func_74764_b("replaceStack")) {
            this.replaceStack = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("replaceStack"));
        }
    }

    public void write(TileNetworkList data) {
        data.add(this.requireStack);
        if (!this.replaceStack.func_190926_b()) {
            data.add(true);
            data.add(MekanismUtils.getID(this.replaceStack));
            data.add(this.replaceStack.func_77952_i());
        } else {
            data.add(false);
        }
    }

    protected void read(ByteBuf dataStream) {
        this.requireStack = dataStream.readBoolean();
        this.replaceStack = dataStream.readBoolean() ? new ItemStack(Item.func_150899_d((int)dataStream.readInt()), 1, dataStream.readInt()) : ItemStack.field_190927_a;
    }

    public boolean equals(Object filter) {
        return filter instanceof MinerFilter;
    }
}

