/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.util;

import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseMapRemoval;
import java.util.Map;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.ChanceOutput;
import mekanism.common.recipe.outputs.ChemicalPairOutput;
import mekanism.common.recipe.outputs.FluidOutput;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.recipe.outputs.PressurizedOutput;
import net.minecraftforge.fluids.FluidStack;

public abstract class RemoveMekanismRecipe<INPUT extends MachineInput<INPUT>, RECIPE extends MachineRecipe<INPUT, ?, RECIPE>>
extends BaseMapRemoval<INPUT, RECIPE> {
    private boolean hasAddedRecipes = false;

    public RemoveMekanismRecipe(String name, Map<INPUT, RECIPE> map) {
        super(name, map);
    }

    public abstract void addRecipes();

    public String describe() {
        if (!this.hasAddedRecipes) {
            this.addRecipes();
            this.hasAddedRecipes = true;
        }
        return super.describe();
    }

    public void apply() {
        if (!this.hasAddedRecipes) {
            this.addRecipes();
            this.hasAddedRecipes = true;
        }
        super.apply();
    }

    protected String getRecipeInfo(Map.Entry<INPUT, RECIPE> recipe) {
        Object output = ((MachineRecipe)recipe.getValue()).recipeOutput;
        if (output instanceof ItemStackOutput) {
            return LogHelper.getStackDescription((Object)((ItemStackOutput)output).output);
        }
        if (output instanceof GasOutput) {
            return LogHelper.getStackDescription((Object)((GasOutput)output).output);
        }
        if (output instanceof FluidOutput) {
            return LogHelper.getStackDescription((FluidStack)((FluidOutput)output).output);
        }
        if (output instanceof ChemicalPairOutput) {
            return "[" + LogHelper.getStackDescription((Object)((ChemicalPairOutput)output).leftGas) + ", " + LogHelper.getStackDescription((Object)((ChemicalPairOutput)output).rightGas) + "]";
        }
        if (output instanceof ChanceOutput) {
            return LogHelper.getStackDescription((Object)((ChanceOutput)output).primaryOutput);
        }
        if (output instanceof PressurizedOutput) {
            return "[" + LogHelper.getStackDescription((Object)((PressurizedOutput)output).getItemOutput()) + ", " + LogHelper.getStackDescription((Object)((PressurizedOutput)output).getGasOutput()) + "]";
        }
        return null;
    }
}

