/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.multipart;

import java.util.Random;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.slot.EnumFaceSlot;
import mcmultipart.api.slot.IPartSlot;
import mekanism.api.EnumColor;
import mekanism.common.MekanismBlocks;
import mekanism.common.block.BlockGlowPanel;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.tile.TileEntityGlowPanel;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultipartGlowPanel
implements IMultipart {
    private static Random rand = new Random();

    public IPartSlot getSlotForPlacement(World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, EntityLivingBase placer) {
        return EnumFaceSlot.values()[facing.ordinal()];
    }

    public IPartSlot getSlotFromWorld(IBlockAccess world, BlockPos pos, IBlockState state) {
        return EnumFaceSlot.values()[((EnumFacing)state.func_177229_b((IProperty)BlockStateFacing.facingProperty)).ordinal()];
    }

    public void onPartPlacedBy(IPartInfo part, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = part.getTile().getTileEntity();
        if (tile instanceof TileEntityGlowPanel) {
            EnumFacing facing = EnumFacing.values()[((EnumFaceSlot)part.getSlot()).ordinal()];
            EnumColor col = EnumColor.DYES[stack.func_77952_i()];
            TileEntityGlowPanel glowPanel = (TileEntityGlowPanel)tile;
            glowPanel.setOrientation(facing);
            glowPanel.setColour(col);
        }
    }

    public void onPartRemoved(IPartInfo part, IPartInfo otherPart) {
        TileEntity tile = part.getTile().getTileEntity();
        if (tile instanceof TileEntityGlowPanel && !BlockGlowPanel.canStay((IBlockAccess)part.getPartWorld(), part.getPartPos())) {
            float motion = 0.7f;
            double motionX = (double)(rand.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(rand.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(rand.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            BlockPos pos = part.getPartPos();
            TileEntityGlowPanel glowPanel = (TileEntityGlowPanel)tile;
            ItemStack stack = new ItemStack(MekanismBlocks.GlowPanel, 1, glowPanel.colour.getMetaValue());
            EntityItem entityItem = new EntityItem(glowPanel.func_145831_w(), (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, stack);
            part.getActualWorld().func_72838_d((Entity)entityItem);
            part.remove();
        }
    }

    public void onPartHarvested(IPartInfo part, EntityPlayer player) {
        TileEntity tile = part.getTile().getTileEntity();
        if (tile instanceof TileEntityGlowPanel) {
            IBlockState partState = part.getState();
            partState.func_177230_c().removedByPlayer(partState, part.getPartWorld(), part.getContainer().getPartPos(), player, true);
        }
        super.onPartHarvested(part, player);
    }

    public Block getBlock() {
        return MekanismBlocks.GlowPanel;
    }
}

