/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.common.Mekanism;
import mekanism.common.item.ItemMekanism;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGaugeDropper
extends ItemMekanism
implements IGasItem {
    public static final int TRANSFER_RATE = 16;
    public static int CAPACITY = 1000;

    public ItemGaugeDropper() {
        this.func_77625_d(1);
        this.func_77637_a(Mekanism.tabMekanism);
    }

    public ItemStack getEmptyItem() {
        ItemStack empty = new ItemStack((Item)this);
        this.setGas(empty, null);
        return empty;
    }

    public void func_150895_a(CreativeTabs tabs, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tabs)) {
            return;
        }
        list.add((Object)this.getEmptyItem());
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double gasRatio = (this.getGas(stack) != null ? (double)this.getGas((ItemStack)stack).amount : 0.0) / (double)CAPACITY;
        double fluidRatio = (FluidUtil.getFluidContained((ItemStack)stack) != null ? (double)FluidUtil.getFluidContained((ItemStack)stack).amount : 0.0) / (double)CAPACITY;
        return 1.0 - Math.max(gasRatio, fluidRatio);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && !world.field_72995_K) {
            this.setGas(stack, null);
            FluidUtil.getFluidHandler((ItemStack)stack).drain(CAPACITY, true);
            ((EntityPlayerMP)player).func_71120_a(player.field_71070_bA);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        GasStack gasStack = this.getGas(itemstack);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemstack);
        if (gasStack == null && fluidStack == null) {
            list.add(LangUtils.localize("gui.empty") + ".");
        } else if (gasStack != null) {
            list.add(LangUtils.localize("tooltip.stored") + " " + gasStack.getGas().getLocalizedName() + ": " + gasStack.amount);
        } else if (fluidStack != null) {
            list.add(LangUtils.localize("tooltip.stored") + " " + fluidStack.getFluid().getLocalizedName(fluidStack) + ": " + fluidStack.amount);
        }
    }

    @Override
    public int getRate(ItemStack itemstack) {
        return 16;
    }

    @Override
    public int addGas(ItemStack itemstack, GasStack stack) {
        if (this.getGas(itemstack) != null && this.getGas(itemstack).getGas() != stack.getGas()) {
            return 0;
        }
        int toUse = Math.min(this.getMaxGas(itemstack) - this.getStored(itemstack), Math.min(this.getRate(itemstack), stack.amount));
        this.setGas(itemstack, new GasStack(stack.getGas(), this.getStored(itemstack) + toUse));
        return toUse;
    }

    @Override
    public GasStack removeGas(ItemStack itemstack, int amount) {
        if (this.getGas(itemstack) == null) {
            return null;
        }
        Gas type = this.getGas(itemstack).getGas();
        int gasToUse = Math.min(this.getStored(itemstack), Math.min(this.getRate(itemstack), amount));
        this.setGas(itemstack, new GasStack(type, this.getStored(itemstack) - gasToUse));
        return new GasStack(type, gasToUse);
    }

    private int getStored(ItemStack itemstack) {
        return this.getGas(itemstack) != null ? this.getGas((ItemStack)itemstack).amount : 0;
    }

    @Override
    public boolean canReceiveGas(ItemStack itemstack, Gas type) {
        return this.getGas(itemstack) == null || this.getGas(itemstack).getGas() == type;
    }

    @Override
    public boolean canProvideGas(ItemStack itemstack, Gas type) {
        return this.getGas(itemstack) != null && (type == null || this.getGas(itemstack).getGas() == type);
    }

    private GasStack getGas_do(ItemStack itemstack) {
        return GasStack.readFromNBT(ItemDataUtils.getCompound(itemstack, "gasStack"));
    }

    @Override
    public GasStack getGas(ItemStack itemstack) {
        return this.getGas_do(itemstack);
    }

    @Override
    public void setGas(ItemStack itemstack, GasStack stack) {
        if (stack == null || stack.amount == 0) {
            ItemDataUtils.removeData(itemstack, "gasStack");
        } else {
            int amount = Math.max(0, Math.min(stack.amount, this.getMaxGas(itemstack)));
            GasStack gasStack = new GasStack(stack.getGas(), amount);
            ItemDataUtils.setCompound(itemstack, "gasStack", gasStack.write(new NBTTagCompound()));
        }
    }

    @Override
    public int getMaxGas(ItemStack itemstack) {
        return CAPACITY;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerItemStack(stack, CAPACITY);
    }
}

