/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.Set;
import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.item.ItemFreeRunners;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketFreeRunnerData
implements IMessageHandler<FreeRunnerDataMessage, IMessage> {
    public IMessage onMessage(FreeRunnerDataMessage message, MessageContext ctx) {
        EntityPlayer entityPlayer = PacketHandler.getPlayer(ctx);
        PacketHandler.handlePacket(() -> {
            ItemStack stack;
            if (message.packetType == FreeRunnerPacket.UPDATE) {
                if (message.value) {
                    Mekanism.freeRunnerOn.add(message.userId);
                } else {
                    Mekanism.freeRunnerOn.remove(message.userId);
                }
                if (!entityPlayer.field_70170_p.field_72995_K) {
                    Mekanism.packetHandler.sendToDimension(new FreeRunnerDataMessage(FreeRunnerPacket.UPDATE, message.userId, message.value), entityPlayer.field_70170_p.field_73011_w.getDimension());
                }
            } else if (message.packetType == FreeRunnerPacket.MODE && !(stack = entityPlayer.func_184582_a(EntityEquipmentSlot.FEET)).func_190926_b() && stack.func_77973_b() instanceof ItemFreeRunners) {
                if (!message.value) {
                    ((ItemFreeRunners)stack.func_77973_b()).incrementMode(stack);
                } else {
                    ((ItemFreeRunners)stack.func_77973_b()).setMode(stack, ItemFreeRunners.FreeRunnerMode.DISABLED);
                }
            }
        }, entityPlayer);
        return null;
    }

    public static class FreeRunnerDataMessage
    implements IMessage {
        public FreeRunnerPacket packetType;
        public UUID userId;
        public boolean value;

        public FreeRunnerDataMessage() {
        }

        public FreeRunnerDataMessage(FreeRunnerPacket packetType, UUID username, boolean value) {
            this.packetType = packetType;
            this.value = value;
            if (packetType == FreeRunnerPacket.UPDATE) {
                this.userId = username;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.packetType.ordinal());
            if (this.packetType == FreeRunnerPacket.MODE) {
                buf.writeBoolean(this.value);
            } else if (this.packetType == FreeRunnerPacket.UPDATE) {
                PacketHandler.writeUUID(buf, this.userId);
                buf.writeBoolean(this.value);
            } else if (this.packetType == FreeRunnerPacket.FULL) {
                buf.writeInt(Mekanism.freeRunnerOn.size());
                Set<UUID> set = Mekanism.freeRunnerOn;
                synchronized (set) {
                    for (UUID usernameToSend : Mekanism.freeRunnerOn) {
                        PacketHandler.writeUUID(buf, usernameToSend);
                    }
                }
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.packetType = FreeRunnerPacket.values()[buf.readInt()];
            if (this.packetType == FreeRunnerPacket.MODE) {
                this.value = buf.readBoolean();
            } else if (this.packetType == FreeRunnerPacket.UPDATE) {
                this.userId = PacketHandler.readUUID(buf);
                this.value = buf.readBoolean();
            } else if (this.packetType == FreeRunnerPacket.FULL) {
                Mekanism.freeRunnerOn.clear();
                int amount = buf.readInt();
                for (int i = 0; i < amount; ++i) {
                    Mekanism.freeRunnerOn.add(PacketHandler.readUUID(buf));
                }
            }
        }
    }

    public static enum FreeRunnerPacket {
        UPDATE,
        FULL,
        MODE;

    }
}

