/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.outputs;

import java.util.Random;
import mekanism.common.recipe.outputs.MachineOutput;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class ChanceOutput
extends MachineOutput<ChanceOutput> {
    private static Random rand = new Random();
    public ItemStack primaryOutput = ItemStack.field_190927_a;
    public ItemStack secondaryOutput = ItemStack.field_190927_a;
    public double secondaryChance;

    public ChanceOutput(ItemStack primary, ItemStack secondary, double chance) {
        this.primaryOutput = primary;
        this.secondaryOutput = secondary;
        this.secondaryChance = chance;
    }

    public ChanceOutput() {
    }

    public ChanceOutput(ItemStack primary) {
        this.primaryOutput = primary;
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.primaryOutput = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("primaryOutput"));
        this.secondaryOutput = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("secondaryOutput"));
        this.secondaryChance = nbtTags.func_74769_h("secondaryChance");
    }

    public boolean checkSecondary() {
        return rand.nextDouble() <= this.secondaryChance;
    }

    public boolean hasPrimary() {
        return !this.primaryOutput.func_190926_b();
    }

    public boolean hasSecondary() {
        return !this.secondaryOutput.func_190926_b();
    }

    public boolean applyOutputs(NonNullList<ItemStack> inventory, int primaryIndex, int secondaryIndex, boolean doEmit) {
        if (this.hasPrimary()) {
            if (((ItemStack)inventory.get(primaryIndex)).func_190926_b()) {
                if (doEmit) {
                    inventory.set(primaryIndex, (Object)this.primaryOutput.func_77946_l());
                }
            } else if (((ItemStack)inventory.get(primaryIndex)).func_77969_a(this.primaryOutput) && ((ItemStack)inventory.get(primaryIndex)).func_190916_E() + this.primaryOutput.func_190916_E() <= ((ItemStack)inventory.get(primaryIndex)).func_77976_d()) {
                if (doEmit) {
                    ((ItemStack)inventory.get(primaryIndex)).func_190917_f(this.primaryOutput.func_190916_E());
                }
            } else {
                return false;
            }
        }
        if (this.hasSecondary() && (!doEmit || this.checkSecondary())) {
            if (((ItemStack)inventory.get(secondaryIndex)).func_190926_b()) {
                if (doEmit) {
                    inventory.set(secondaryIndex, (Object)this.secondaryOutput.func_77946_l());
                }
                return true;
            }
            if (((ItemStack)inventory.get(secondaryIndex)).func_77969_a(this.secondaryOutput) && ((ItemStack)inventory.get(secondaryIndex)).func_190916_E() + this.primaryOutput.func_190916_E() <= ((ItemStack)inventory.get(secondaryIndex)).func_77976_d()) {
                if (doEmit) {
                    ((ItemStack)inventory.get(secondaryIndex)).func_190917_f(this.secondaryOutput.func_190916_E());
                }
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public ChanceOutput copy() {
        return new ChanceOutput(StackUtils.copy(this.primaryOutput), StackUtils.copy(this.secondaryOutput), this.secondaryChance);
    }
}

