/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import javax.annotation.Nonnull;
import mekanism.common.Upgrade;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ItemHandlerWrapper;
import mekanism.common.capabilities.CapabilityWrapperManager;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class TileEntityContainerBlock
extends TileEntityBasicBlock
implements ISidedInventory,
ISustainedInventory,
ITickable {
    public NonNullList<ItemStack> inventory;
    public String fullName;
    private CapabilityWrapperManager<ISidedInventory, ItemHandlerWrapper> itemManager = new CapabilityWrapperManager<ISidedInventory, ItemHandlerWrapper>(ISidedInventory.class, ItemHandlerWrapper.class);
    private IItemHandler nullHandler = new InvWrapper((IInventory)this){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        }
    };

    public TileEntityContainerBlock(String name) {
        this.fullName = name;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.getInventory()) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (this.handleInventory()) {
            NBTTagList tagList = nbtTags.func_150295_c("Items", 10);
            this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (int tagCount = 0; tagCount < tagList.func_74745_c(); ++tagCount) {
                NBTTagCompound tagCompound = tagList.func_150305_b(tagCount);
                byte slotID = tagCompound.func_74771_c("Slot");
                if (slotID < 0 || slotID >= this.func_70302_i_()) continue;
                this.func_70299_a(slotID, InventoryUtils.loadFromNBT(tagCompound));
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.handleInventory()) {
            NBTTagList tagList = new NBTTagList();
            for (int slotCount = 0; slotCount < this.func_70302_i_(); ++slotCount) {
                ItemStack stackInSlot = this.func_70301_a(slotCount);
                if (stackInSlot.func_190926_b()) continue;
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)slotCount);
                stackInSlot.func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            nbtTags.func_74782_a("Items", (NBTBase)tagList);
        }
        return nbtTags;
    }

    protected NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public int func_70302_i_() {
        return this.getInventory() != null ? this.getInventory().size() : 0;
    }

    public ItemStack func_70301_a(int slotID) {
        return this.getInventory() != null ? (ItemStack)this.getInventory().get(slotID) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int slotID, int amount) {
        if (this.getInventory() == null) {
            return ItemStack.field_190927_a;
        }
        return ItemStackHelper.func_188382_a(this.getInventory(), (int)slotID, (int)amount);
    }

    public ItemStack func_70304_b(int slotID) {
        if (this.getInventory() == null) {
            return ItemStack.field_190927_a;
        }
        return ItemStackHelper.func_188383_a(this.getInventory(), (int)slotID);
    }

    public void func_70299_a(int slotID, ItemStack itemstack) {
        this.getInventory().set(slotID, (Object)itemstack);
        if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
            itemstack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return !this.func_145837_r() && this.field_145850_b.func_175667_e(this.field_174879_c);
    }

    public String func_70005_c_() {
        return LangUtils.localize(this.func_145838_q().func_149739_a() + "." + this.fullName + ".name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return true;
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public abstract int[] func_180463_a(EnumFacing var1);

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return true;
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (nbtTags == null || nbtTags.func_74745_c() == 0 || !this.handleInventory()) {
            return;
        }
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int slots = 0; slots < nbtTags.func_74745_c(); ++slots) {
            NBTTagCompound tagCompound = nbtTags.func_150305_b(slots);
            byte slotID = tagCompound.func_74771_c("Slot");
            if (slotID < 0 || slotID >= this.inventory.size()) continue;
            this.inventory.set((int)slotID, (Object)InventoryUtils.loadFromNBT(tagCompound));
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        NBTTagList tagList = new NBTTagList();
        if (this.handleInventory()) {
            for (int slots = 0; slots < this.inventory.size(); ++slots) {
                if (((ItemStack)this.inventory.get(slots)).func_190926_b()) continue;
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)slots);
                ((ItemStack)this.inventory.get(slots)).func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
        }
        return tagList;
    }

    public boolean handleInventory() {
        return true;
    }

    public void recalculateUpgradables(Upgrade upgradeType) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.nullHandler);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemManager.getWrapper(this, facing));
        }
        return super.getCapability(capability, facing);
    }
}

