/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.matching.matcher;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import wanion.lib.common.NBTUtils;
import wanion.lib.common.matching.Matching;
import wanion.lib.common.matching.matcher.AbstractMatcher;
import wanion.lib.common.matching.matcher.ItemStackMatcher;
import wanion.lib.common.matching.matcher.MatcherEnum;
import wanion.lib.common.matching.matcher.OreDictMatcher;

public class NbtMatcher
extends AbstractMatcher {
    public NbtMatcher(@Nonnull Matching matching) {
        super(matching);
    }

    @Override
    @Nonnull
    public MatcherEnum getMatcherEnum() {
        return MatcherEnum.NBT;
    }

    @Override
    @Nonnull
    public AbstractMatcher validate() {
        return this.getStack().func_77942_o() ? this : new ItemStackMatcher(this.matching);
    }

    @Override
    @Nonnull
    public AbstractMatcher next() {
        return OreDictionary.getOreIDs((ItemStack)this.getStack()).length > 0 ? new OreDictMatcher(this.matching) : new ItemStackMatcher(this.matching);
    }

    @Override
    public boolean matches(@Nonnull ItemStack otherItemStack) {
        ItemStack itemStack = this.getStack();
        return otherItemStack.func_77942_o() && itemStack.func_77969_a(otherItemStack) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)otherItemStack);
    }

    @Override
    @Nonnull
    public String format() {
        ItemStack itemStack = this.getStack();
        boolean greaterThanOne = itemStack.func_190916_E() > 1;
        StringBuilder formatBuilder = new StringBuilder();
        if (greaterThanOne) {
            formatBuilder.append('(');
        }
        formatBuilder.append('<').append(itemStack.func_77973_b().getRegistryName());
        if (itemStack.func_77952_i() > 0) {
            formatBuilder.append(':').append(itemStack.func_77952_i());
        }
        formatBuilder.append('>');
        if (greaterThanOne) {
            formatBuilder.append(" * ").append(itemStack.func_190916_E()).append(')');
        }
        NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
        formatBuilder.append(".withTag(");
        if (nbtTagCompound != null) {
            formatBuilder.append(NBTUtils.formatNbt(nbtTagCompound));
        }
        formatBuilder.append(')');
        return formatBuilder.toString();
    }
}

