/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shaper;

import java.util.HashMap;
import java.util.Map;
import mcjty.rftools.blocks.shaper.ProjectorSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ProjectorSounds {
    private static final Map<BlockPos, MovingSound> sounds = new HashMap<BlockPos, MovingSound>();
    public static SoundEvent scanSound;

    public static void init(IForgeRegistry<SoundEvent> registry) {
        scanSound = ProjectorSounds.registerSound(registry, new ResourceLocation("rftools", "scan"));
    }

    private static SoundEvent registerSound(IForgeRegistry<SoundEvent> registry, ResourceLocation sound) {
        SoundEvent event = (SoundEvent)new SoundEvent(sound).setRegistryName(sound);
        registry.register((IForgeRegistryEntry)event);
        return event;
    }

    public static void stopSound(BlockPos pos) {
        if (sounds.containsKey(pos)) {
            MovingSound movingSound = sounds.get(pos);
            ((ProjectorSound)movingSound).stop();
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)movingSound);
            sounds.remove(pos);
        }
    }

    private static void playSound(BlockPos pos, MovingSound sound) {
        ProjectorSounds.stopSound(pos);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        sounds.put(pos, sound);
    }

    public static void playScan(World worldObj, BlockPos pos) {
        ProjectorSound sound = new ProjectorSound(worldObj, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        ProjectorSounds.playSound(pos, sound);
    }

    public static boolean isScanPlaying(BlockPos pos) {
        MovingSound movingSound = sounds.get(pos);
        return movingSound instanceof ProjectorSound;
    }
}

