/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.energyFluid;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.tile.energy.TileEnergy;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankSorption;
import nc.util.GasHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public abstract class TileEnergyFluid
extends TileEnergy
implements ITileFluid {
    @Nonnull
    private final List<Tank> tanks;
    @Nonnull
    private FluidConnection[] fluidConnections;
    @Nonnull
    private FluidTileWrapper[] fluidSides;
    @Nonnull
    private GasTileWrapper gasWrapper;
    private boolean areTanksShared = false;
    private boolean emptyUnusableTankInputs = false;
    private boolean voidExcessFluidOutputs = false;

    public TileEnergyFluid(int capacity, @Nonnull EnergyConnection[] energyConnections, int fluidCapacity, @Nonnull TankSorption tankSorption, List<String> allowedFluidsList, @Nonnull FluidConnection[] fluidConnections) {
        this(capacity, capacity, energyConnections, Lists.newArrayList((Object[])new Integer[]{fluidCapacity}), Lists.newArrayList((Object[])new Integer[]{fluidCapacity}), Lists.newArrayList((Object[])new TankSorption[]{tankSorption}), Lists.newArrayList((Object[])new List[]{allowedFluidsList}), fluidConnections);
    }

    public TileEnergyFluid(int capacity, @Nonnull EnergyConnection[] energyConnections, @Nonnull List<Integer> fluidCapacity, @Nonnull List<TankSorption> tankSorptions, List<List<String>> allowedFluidsLists, @Nonnull FluidConnection[] fluidConnections) {
        this(capacity, capacity, energyConnections, fluidCapacity, fluidCapacity, tankSorptions, allowedFluidsLists, fluidConnections);
    }

    public TileEnergyFluid(int capacity, @Nonnull EnergyConnection[] energyConnections, int fluidCapacity, int maxFluidTransfer, @Nonnull TankSorption tankSorption, List<String> allowedFluidsList, @Nonnull FluidConnection[] fluidConnections) {
        this(capacity, capacity, energyConnections, Lists.newArrayList((Object[])new Integer[]{fluidCapacity}), Lists.newArrayList((Object[])new Integer[]{maxFluidTransfer}), Lists.newArrayList((Object[])new TankSorption[]{tankSorption}), Lists.newArrayList((Object[])new List[]{allowedFluidsList}), fluidConnections);
    }

    public TileEnergyFluid(int capacity, @Nonnull EnergyConnection[] energyConnections, @Nonnull List<Integer> fluidCapacity, @Nonnull List<Integer> maxFluidTransfer, @Nonnull List<TankSorption> tankSorptions, List<List<String>> allowedFluidsLists, @Nonnull FluidConnection[] fluidConnections) {
        this(capacity, capacity, energyConnections, fluidCapacity, maxFluidTransfer, tankSorptions, allowedFluidsLists, fluidConnections);
    }

    public TileEnergyFluid(int capacity, int maxTransfer, @Nonnull EnergyConnection[] energyConnections, int fluidCapacity, @Nonnull TankSorption tankSorption, List<String> allowedFluidsList, @Nonnull FluidConnection[] fluidConnections) {
        this(capacity, maxTransfer, energyConnections, Lists.newArrayList((Object[])new Integer[]{fluidCapacity}), Lists.newArrayList((Object[])new Integer[]{fluidCapacity}), Lists.newArrayList((Object[])new TankSorption[]{tankSorption}), Lists.newArrayList((Object[])new List[]{allowedFluidsList}), fluidConnections);
    }

    public TileEnergyFluid(int capacity, int maxTransfer, @Nonnull EnergyConnection[] energyConnections, @Nonnull List<Integer> fluidCapacity, @Nonnull List<TankSorption> tankSorptions, List<List<String>> allowedFluidsLists, @Nonnull FluidConnection[] fluidConnections) {
        this(capacity, maxTransfer, energyConnections, fluidCapacity, fluidCapacity, tankSorptions, allowedFluidsLists, fluidConnections);
    }

    public TileEnergyFluid(int capacity, int maxTransfer, @Nonnull EnergyConnection[] energyConnections, int fluidCapacity, int maxFluidTransfer, @Nonnull TankSorption tankSorption, List<String> allowedFluidsList, @Nonnull FluidConnection[] fluidConnections) {
        this(capacity, maxTransfer, energyConnections, Lists.newArrayList((Object[])new Integer[]{fluidCapacity}), Lists.newArrayList((Object[])new Integer[]{maxFluidTransfer}), Lists.newArrayList((Object[])new TankSorption[]{tankSorption}), Lists.newArrayList((Object[])new List[]{allowedFluidsList}), fluidConnections);
    }

    public TileEnergyFluid(int capacity, int maxTransfer, @Nonnull EnergyConnection[] energyConnections, @Nonnull List<Integer> fluidCapacity, @Nonnull List<Integer> maxFluidTransfer, @Nonnull List<TankSorption> tankSorptions, List<List<String>> allowedFluidsLists, @Nonnull FluidConnection[] fluidConnections) {
        super(capacity, maxTransfer, energyConnections);
        if (fluidCapacity.isEmpty()) {
            this.tanks = new ArrayList<Tank>();
        } else {
            ArrayList<Tank> tankList = new ArrayList<Tank>();
            for (int i = 0; i < fluidCapacity.size(); ++i) {
                List<String> allowedFluidsList = allowedFluidsLists == null || allowedFluidsLists.size() <= i ? null : allowedFluidsLists.get(i);
                tankList.add(new Tank(fluidCapacity.get(i), tankSorptions.get(i), allowedFluidsList));
            }
            this.tanks = tankList;
        }
        this.fluidConnections = fluidConnections;
        this.fluidSides = ITileFluid.getDefaultFluidSides(this);
        this.gasWrapper = new GasTileWrapper(this);
    }

    @Override
    @Nonnull
    public List<Tank> getTanks() {
        return this.tanks;
    }

    @Override
    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    @Override
    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Override
    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return this.fluidSides;
    }

    @Override
    @Nonnull
    public GasTileWrapper getGasWrapper() {
        return this.gasWrapper;
    }

    @Override
    public boolean getTanksShared() {
        return this.areTanksShared;
    }

    @Override
    public void setTanksShared(boolean shared) {
        this.areTanksShared = shared;
    }

    @Override
    public boolean getEmptyUnusableTankInputs() {
        return this.emptyUnusableTankInputs;
    }

    @Override
    public void setEmptyUnusableTankInputs(boolean emptyUnusableTankInputs) {
        this.emptyUnusableTankInputs = emptyUnusableTankInputs;
    }

    @Override
    public boolean getVoidExcessFluidOutputs() {
        return this.voidExcessFluidOutputs;
    }

    @Override
    public void setVoidExcessFluidOutputs(boolean voidExcessFluidOutputs) {
        this.voidExcessFluidOutputs = voidExcessFluidOutputs;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeTanks(nbt);
        this.writeFluidConnections(nbt);
        nbt.func_74757_a("areTanksShared", this.areTanksShared);
        nbt.func_74757_a("emptyUnusable", this.emptyUnusableTankInputs);
        nbt.func_74757_a("voidExcessOutputs", this.voidExcessFluidOutputs);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readTanks(nbt);
        this.readFluidConnections(nbt);
        this.setTanksShared(nbt.func_74767_n("areTanksShared"));
        this.setEmptyUnusableTankInputs(nbt.func_74767_n("emptyUnusable"));
        this.setVoidExcessFluidOutputs(nbt.func_74767_n("voidExcessOutputs"));
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
            side = this.nonNullSide(side);
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return this.getFluidSide(side) != null;
            }
            if (ModCheck.mekanismLoaded() && GasHelper.isGasCapability(capability)) {
                return this.getGasWrapper() != null;
            }
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
            side = this.nonNullSide(side);
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)this.getFluidSide(side);
            }
            if (ModCheck.mekanismLoaded() && GasHelper.isGasCapability(capability)) {
                return (T)this.getGasWrapper();
            }
        }
        return super.getCapability(capability, side);
    }
}

