/*
 * Decompiled with CFR 0.152.
 */
package nc.worldgen.ore;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Random;
import nc.block.BlockMeta;
import nc.config.NCConfig;
import nc.init.NCBlocks;
import nc.worldgen.ore.UniversalOrePredicate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGenerator
implements IWorldGenerator {
    private final WorldGenerator copper = new WorldGenOre(0);
    private final WorldGenerator tin = new WorldGenOre(1);
    private final WorldGenerator lead = new WorldGenOre(2);
    private final WorldGenerator thorium = new WorldGenOre(3);
    private final WorldGenerator uranium = new WorldGenOre(4);
    private final WorldGenerator boron = new WorldGenOre(5);
    private final WorldGenerator lithium = new WorldGenOre(6);
    private final WorldGenerator magnesium = new WorldGenOre(7);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        ArrayList<Integer> dimList = new ArrayList<Integer>();
        for (int i = 0; i < NCConfig.ore_dims.length; ++i) {
            dimList.add(NCConfig.ore_dims[i]);
        }
        if (dimList.contains(world.field_73011_w.getDimension()) != NCConfig.ore_dims_list_type) {
            this.generateOres(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    private void generateOre(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal height arguments for WorldGenerator!");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z * 16 + rand.nextInt(16);
            generator.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }

    private void generateOres(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (NCConfig.ore_gen[0]) {
            this.generateOre(this.copper, world, random, chunkX, chunkZ, NCConfig.ore_rate[0], NCConfig.ore_min_height[0], NCConfig.ore_max_height[0]);
        }
        if (NCConfig.ore_gen[1]) {
            this.generateOre(this.tin, world, random, chunkX, chunkZ, NCConfig.ore_rate[1], NCConfig.ore_min_height[1], NCConfig.ore_max_height[1]);
        }
        if (NCConfig.ore_gen[2]) {
            this.generateOre(this.lead, world, random, chunkX, chunkZ, NCConfig.ore_rate[2], NCConfig.ore_min_height[2], NCConfig.ore_max_height[2]);
        }
        if (NCConfig.ore_gen[3]) {
            this.generateOre(this.thorium, world, random, chunkX, chunkZ, NCConfig.ore_rate[3], NCConfig.ore_min_height[3], NCConfig.ore_max_height[3]);
        }
        if (NCConfig.ore_gen[4]) {
            this.generateOre(this.uranium, world, random, chunkX, chunkZ, NCConfig.ore_rate[4], NCConfig.ore_min_height[4], NCConfig.ore_max_height[4]);
        }
        if (NCConfig.ore_gen[5]) {
            this.generateOre(this.boron, world, random, chunkX, chunkZ, NCConfig.ore_rate[5], NCConfig.ore_min_height[5], NCConfig.ore_max_height[5]);
        }
        if (NCConfig.ore_gen[6]) {
            this.generateOre(this.lithium, world, random, chunkX, chunkZ, NCConfig.ore_rate[6], NCConfig.ore_min_height[6], NCConfig.ore_max_height[6]);
        }
        if (NCConfig.ore_gen[7]) {
            this.generateOre(this.magnesium, world, random, chunkX, chunkZ, NCConfig.ore_rate[7], NCConfig.ore_min_height[7], NCConfig.ore_max_height[7]);
        }
    }

    public static boolean showOre(int i) {
        return NCConfig.ore_gen[i] || !NCConfig.hide_disabled_ores;
    }

    private static class WorldGenOre
    extends WorldGenMinable {
        public WorldGenOre(int meta) {
            super(((BlockMeta)NCBlocks.ore).func_176203_a(meta), NCConfig.ore_size[meta] + 2, (Predicate)new UniversalOrePredicate());
        }
    }
}

