/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.api.entity.IPixelmon;
import noppes.npcs.api.wrapper.AnimalWrapper;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.util.ValueUtil;

public class PixelmonWrapper<T extends EntityTameable>
extends AnimalWrapper<T>
implements IPixelmon {
    public PixelmonWrapper(T pixelmon) {
        super(pixelmon);
    }

    private NBTTagCompound getCompound() {
        NBTTagCompound compound = new NBTTagCompound();
        ((EntityTameable)this.entity).func_70014_b(compound);
        return compound;
    }

    @Override
    public boolean getIsShiny() {
        return this.getCompound().func_74767_n("IsShiny");
    }

    @Override
    public void setIsShiny(boolean bo) {
        NBTTagCompound compound = this.getCompound();
        compound.func_74757_a("IsShiny", bo);
        ((EntityTameable)this.entity).func_70037_a(compound);
    }

    @Override
    public int getLevel() {
        return this.getCompound().func_74762_e("Level");
    }

    @Override
    public void setLevel(int level) {
        NBTTagCompound compound = this.getCompound();
        compound.func_74768_a("Level", level);
        ((EntityTameable)this.entity).func_70037_a(compound);
    }

    @Override
    public int getIV(int type) {
        NBTTagCompound compound = this.getCompound();
        if (type == 0) {
            return compound.func_74762_e("IVHP");
        }
        if (type == 1) {
            return compound.func_74762_e("IVAttack");
        }
        if (type == 2) {
            return compound.func_74762_e("IVDefence");
        }
        if (type == 3) {
            return compound.func_74762_e("IVSpAtt");
        }
        if (type == 4) {
            return compound.func_74762_e("IVSpDef");
        }
        if (type == 5) {
            return compound.func_74762_e("IVSpeed");
        }
        return -1;
    }

    @Override
    public void setIV(int type, int value) {
        NBTTagCompound compound = this.getCompound();
        if (type == 0) {
            compound.func_74768_a("IVHP", value);
        } else if (type == 1) {
            compound.func_74768_a("IVAttack", value);
        } else if (type == 2) {
            compound.func_74768_a("IVDefence", value);
        } else if (type == 3) {
            compound.func_74768_a("IVSpAtt", value);
        } else if (type == 4) {
            compound.func_74768_a("IVSpDef", value);
        } else if (type == 5) {
            compound.func_74768_a("IVSpeed", value);
        }
        ((EntityTameable)this.entity).func_70037_a(compound);
    }

    @Override
    public int getEV(int type) {
        NBTTagCompound compound = this.getCompound();
        if (type == 0) {
            return compound.func_74762_e("EVHP");
        }
        if (type == 1) {
            return compound.func_74762_e("EVAttack");
        }
        if (type == 2) {
            return compound.func_74762_e("EVDefence");
        }
        if (type == 3) {
            return compound.func_74762_e("EVSpecialAttack");
        }
        if (type == 4) {
            return compound.func_74762_e("EVSpecialDefence");
        }
        if (type == 5) {
            return compound.func_74762_e("EVSpeed");
        }
        return -1;
    }

    @Override
    public void setEV(int type, int value) {
        NBTTagCompound compound = this.getCompound();
        if (type == 0) {
            compound.func_74768_a("EVHP", value);
        } else if (type == 1) {
            compound.func_74768_a("EVAttack", value);
        } else if (type == 2) {
            compound.func_74768_a("EVDefence", value);
        } else if (type == 3) {
            compound.func_74768_a("EVSpecialAttack", value);
        } else if (type == 4) {
            compound.func_74768_a("EVSpecialDefence", value);
        } else if (type == 5) {
            compound.func_74768_a("EVSpeed", value);
        }
        ((EntityTameable)this.entity).func_70037_a(compound);
    }

    @Override
    public int getStat(int type) {
        NBTTagCompound compound = this.getCompound();
        if (type == 0) {
            return compound.func_74762_e("StatsHP");
        }
        if (type == 1) {
            return compound.func_74762_e("StatsAttack");
        }
        if (type == 2) {
            return compound.func_74762_e("StatsDefence");
        }
        if (type == 3) {
            return compound.func_74762_e("StatsSpecialAttack");
        }
        if (type == 4) {
            return compound.func_74762_e("StatsSpecialDefence");
        }
        if (type == 5) {
            return compound.func_74762_e("StatsSpeed");
        }
        return -1;
    }

    @Override
    public void setStat(int type, int value) {
        NBTTagCompound compound = this.getCompound();
        if (type == 0) {
            compound.func_74768_a("StatsHP", value);
        } else if (type == 1) {
            compound.func_74768_a("StatsAttack", value);
        } else if (type == 2) {
            compound.func_74768_a("StatsDefence", value);
        } else if (type == 3) {
            compound.func_74768_a("StatsSpecialAttack", value);
        } else if (type == 4) {
            compound.func_74768_a("StatsSpecialDefence", value);
        } else if (type == 5) {
            compound.func_74768_a("StatsSpeed", value);
        }
        ((EntityTameable)this.entity).func_70037_a(compound);
    }

    @Override
    public int getSize() {
        NBTTagCompound compound = this.getCompound();
        return compound.func_74765_d("Growth");
    }

    @Override
    public void setSize(int type) {
        NBTTagCompound compound = this.getCompound();
        compound.func_74777_a("Growth", (short)type);
        ((EntityTameable)this.entity).func_70037_a(compound);
    }

    @Override
    public int getHapiness() {
        NBTTagCompound compound = this.getCompound();
        return compound.func_74762_e("Friendship");
    }

    @Override
    public void setHapiness(int value) {
        NBTTagCompound compound = this.getCompound();
        value = ValueUtil.CorrectInt(value, 0, 255);
        compound.func_74768_a("Friendship", value);
        ((EntityTameable)this.entity).func_70037_a(compound);
    }

    @Override
    public int getNature() {
        NBTTagCompound compound = this.getCompound();
        return compound.func_74765_d("Nature");
    }

    @Override
    public void setNature(int type) {
        NBTTagCompound compound = this.getCompound();
        compound.func_74777_a("Nature", (short)type);
        ((EntityTameable)this.entity).func_70037_a(compound);
    }

    @Override
    public int getPokeball() {
        NBTTagCompound compound = this.getCompound();
        if (compound.func_74764_b("CaughtBall")) {
            return -1;
        }
        return compound.func_74762_e("CaughtBall");
    }

    @Override
    public void setPokeball(int type) {
        NBTTagCompound compound = this.getCompound();
        compound.func_74768_a("CaughtBall", type);
        ((EntityTameable)this.entity).func_70037_a(compound);
    }

    @Override
    public String getNickname() {
        NBTTagCompound compound = this.getCompound();
        return compound.func_74779_i("Nickname");
    }

    @Override
    public boolean hasNickname() {
        return !this.getNickname().isEmpty();
    }

    @Override
    public void setNickname(String name) {
        NBTTagCompound compound = this.getCompound();
        compound.func_74778_a("Nickname", name);
        ((EntityTameable)this.entity).func_70037_a(compound);
    }

    @Override
    public String getMove(int slot) {
        NBTTagCompound compound = this.getCompound();
        if (!compound.func_74764_b("PixelmonMoveID" + slot)) {
            return null;
        }
        return PixelmonHelper.getAttackName(compound.func_74762_e("PixelmonMoveID" + slot));
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public void setMove(int slot, String move) {
        NBTTagCompound compound = this.getCompound();
        slot = ValueUtil.CorrectInt(slot, 0, 3);
        int id = PixelmonHelper.getAttackID(move);
        compound.func_82580_o("PixelmonMovePP" + slot);
        compound.func_82580_o("PixelmonMovePPBase" + slot);
        if (id < 0) {
            compound.func_82580_o("PixelmonMoveID" + slot);
        } else {
            compound.func_74768_a("PixelmonMoveID" + slot, id);
        }
        int size = 0;
        for (int i = 0; i < 4; ++i) {
            if (!compound.func_74764_b("PixelmonMoveID" + i)) continue;
            ++size;
        }
        compound.func_74768_a("PixelmonNumberMoves", size);
        ((EntityTameable)this.entity).func_70037_a(compound);
    }
}

