/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.events;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_WorldProvider;
import galaxyspace.GalaxySpace;
import galaxyspace.api.item.IJetpackArmor;
import galaxyspace.core.client.gui.GSGuiMainMenu;
import galaxyspace.core.client.gui.GSGuiUpdate;
import galaxyspace.core.client.gui.overlay.OverlaySpaceSuit;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.network.packet.GSPacketSimple;
import galaxyspace.core.util.GSThreadVersionCheck;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class GSClientTickHandler {
    public Minecraft mc = FMLClientHandler.instance().getClient();
    public Random rand;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiMainMenu && GSConfigCore.enableNewMenu) {
            event.setGui((GuiScreen)new GSGuiMainMenu());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = this.mc.field_71441_e;
        if (event.phase == TickEvent.Phase.START) {
            if (!this.mc.func_147113_T()) {
                // empty if block
            }
            if (player != null) {
                // empty if block
            }
        }
        if (event.phase == TickEvent.Phase.END && Side.CLIENT != null && player != null && world != null && GSThreadVersionCheck.newversion && this.mc.field_71415_G && GSConfigCore.enableCheckVersion) {
            GSThreadVersionCheck.newversion = false;
            Minecraft.func_71410_x().func_152344_a(() -> FMLClientHandler.instance().showGuiScreen((Object)new GSGuiUpdate()));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRender(RenderPlayerEvent.Post event) {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    @SideOnly(value=Side.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, (boolean)false);
        if (event.phase == TickEvent.Phase.END && player != null) {
            if (minecraft.field_71415_G && !minecraft.field_71474_y.field_74319_N && GalaxySpace.debug) {
                long t1 = player.field_70170_p.field_73011_w instanceof WorldProviderSpace ? ((WorldProviderSpace)player.field_70170_p.field_73011_w).getDayLength() : 24000L;
                long time = player.field_70170_p.func_72820_D() % (t1 > 0L ? t1 : 1L);
                float temp = player.field_70170_p.field_73011_w instanceof WorldProviderSpace ? ((WorldProviderSpace)player.field_70170_p.field_73011_w).getThermalLevelModifier() : 1.0f;
                String[] s = new String[]{"GalaxySpace 2.0.6 DEBUG Mode", "MC Version: 1.12.2", "Celestial Body: " + (player.func_130014_f_().field_73011_w instanceof IGalacticraftWorldProvider ? ((IGalacticraftWorldProvider)player.func_130014_f_().field_73011_w).getCelestialBody().getLocalizedName() : "Unnamed"), "", "Player Data:", "X: " + (int)player.field_70165_t, "Y: " + (int)player.field_70163_u, "Z: " + (int)player.field_70161_v, "Current Item: " + (player.field_71071_by.func_70448_g() != null ? Item.field_150901_e.func_177774_c((Object)player.field_71071_by.func_70448_g().func_77973_b()) + ":" + player.field_71071_by.func_70448_g().func_77952_i() : "None"), "", "World Data:", "Dimension: " + player.field_70170_p.field_73011_w.func_186058_p().func_186065_b() + " (ID: " + player.field_70170_p.field_73011_w.func_186058_p().func_186068_a() + ")", "Temperature: " + temp + "F", "Biome: " + player.field_70170_p.getBiomeForCoordsBody(new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v)).func_185359_l(), "Current Time: " + time + " | Day Length: " + (player.field_70170_p.field_73011_w instanceof WorldProviderSpace ? Long.valueOf(((WorldProviderSpace)player.field_70170_p.field_73011_w).getDayLength()) : "24000") + " | Total Time: " + player.field_70170_p.func_72820_D(), "Moon Phase: " + player.field_70170_p.func_72853_d(), "", "Is Galacticraft Provider: " + (player.func_130014_f_().field_73011_w instanceof IGalacticraftWorldProvider ? "Yes" : "No"), "Is Advance Space Provider: " + (player.func_130014_f_().field_73011_w instanceof IAdvancedSpace ? "Yes" : "No"), "Is Enable Oregen: " + (GSConfigCore.enableOresGeneration ? "Yes" : "No"), "Is World Engine Provider: " + (player.func_130014_f_().field_73011_w instanceof WE_WorldProvider ? "Yes" : "No")};
                int k = 3;
                GameSettings cfr_ignored_0 = this.mc.field_71474_y;
                if (GameSettings.func_100015_a((KeyBinding)this.mc.field_71474_y.field_74311_E)) {
                    k = s.length;
                }
                GL11.glPushMatrix();
                for (int i = 0; i < k; ++i) {
                    minecraft.field_71466_p.func_175063_a(s[i], 10.0f, (float)(28 + i * 10), ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                }
                GL11.glPopMatrix();
            }
            if (minecraft.field_71415_G && !minecraft.field_71474_y.field_74319_N && GSConfigCore.enableSpaceSuitHUD) {
                OverlaySpaceSuit.renderSpaceSuitOverlay((EntityPlayer)playerBaseClient);
            }
            GlStateManager.func_179140_f();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        ItemStack chest;
        if (e.phase == TickEvent.Phase.START && e.side == Side.CLIENT && (chest = e.player.func_184582_a(EntityEquipmentSlot.CHEST)) != null && chest.func_77973_b() instanceof IJetpackArmor && ((IJetpackArmor)chest.func_77973_b()).canFly(chest, e.player)) {
            this.parseKeybindings(e.player);
        }
    }

    private void parseKeybindings(EntityPlayer player) {
        float power = 1.0f;
        double y = player.field_70163_u;
        int worldHeight1 = player.func_130014_f_().func_72800_K();
        int maxFlightHeight1 = (int)((float)worldHeight1 / 1.28f);
        if (y > (double)(maxFlightHeight1 - 25)) {
            if (y > (double)maxFlightHeight1) {
                y = maxFlightHeight1;
            }
            power = (float)((double)power * (((double)maxFlightHeight1 - y) / 25.0));
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d()) {
            player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.15f), (double)0.6f);
            GalaxySpace.packetPipeline.sendToServer((IPacket)new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.S_CHANGE_FLIGHT_STATE, player.field_70170_p, new Object[]{true}));
        } else {
            GalaxySpace.packetPipeline.sendToServer((IPacket)new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.S_CHANGE_FLIGHT_STATE, player.field_70170_p, new Object[]{false}));
        }
    }
}

