/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.device;

import cofh.core.inventory.ComparableItemStackValidated;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalfoundation.block.BlockStorage;
import cofh.thermalfoundation.block.BlockStorageAlloy;
import cofh.thermalfoundation.item.ItemMaterial;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.OreDictionary;

public class FactorizerManager {
    private static Map<ComparableItemStackValidated, FactorizerRecipe> recipeMap = new Object2ObjectOpenHashMap();
    private static Map<ComparableItemStackValidated, FactorizerRecipe> recipeMapReverse = new Object2ObjectOpenHashMap();

    public static FactorizerRecipe getRecipe(ItemStack input, boolean reverse) {
        FactorizerRecipe recipe;
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackValidated query = new ComparableItemStackValidated(input);
        if (reverse) {
            recipe = recipeMapReverse.get(query);
            if (recipe == null) {
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapReverse.get(query);
            }
        } else {
            recipe = recipeMap.get(query);
            if (recipe == null) {
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMap.get(query);
            }
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input, boolean reverse) {
        return FactorizerManager.getRecipe(input, reverse) != null;
    }

    public static FactorizerRecipe[] getRecipeList(boolean reverse) {
        if (reverse) {
            return recipeMapReverse.values().toArray(new FactorizerRecipe[0]);
        }
        return recipeMap.values().toArray(new FactorizerRecipe[0]);
    }

    public static void initialize() {
        FactorizerManager.addRecipe(new ItemStack((Block)Blocks.field_150354_m, 4, 0), new ItemStack(Blocks.field_150322_A), false);
        FactorizerManager.addRecipe(new ItemStack((Block)Blocks.field_150354_m, 4, 1), new ItemStack(Blocks.field_180395_cM), false);
        FactorizerManager.addRecipe(new ItemStack(Items.field_151114_aO, 4, 0), new ItemStack(Blocks.field_150426_aN), false);
        FactorizerManager.addDefaultRecipe(new ItemStack(Items.field_151128_bU), new ItemStack(Blocks.field_150371_ca), 4);
        FactorizerManager.addDefaultRecipe(new ItemStack(Items.field_151137_ax), new ItemStack(Blocks.field_150451_bX));
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotIron, new ItemStack(Blocks.field_150339_S));
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotGold, new ItemStack(Blocks.field_150340_R));
        FactorizerManager.addDefaultRecipe(ItemMaterial.gemDiamond, new ItemStack(Blocks.field_150484_ah));
        FactorizerManager.addDefaultRecipe(ItemMaterial.gemEmerald, new ItemStack(Blocks.field_150475_bE));
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotCopper, BlockStorage.blockCopper);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotTin, BlockStorage.blockTin);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotSilver, BlockStorage.blockSilver);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotLead, BlockStorage.blockLead);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotAluminum, BlockStorage.blockAluminum);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotNickel, BlockStorage.blockNickel);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotPlatinum, BlockStorage.blockPlatinum);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotIridium, BlockStorage.blockIridium);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotMithril, BlockStorage.blockMithril);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotSteel, BlockStorageAlloy.blockSteel);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotElectrum, BlockStorageAlloy.blockElectrum);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotInvar, BlockStorageAlloy.blockInvar);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotBronze, BlockStorageAlloy.blockBronze);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotConstantan, BlockStorageAlloy.blockConstantan);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotSignalum, BlockStorageAlloy.blockSignalum);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotLumium, BlockStorageAlloy.blockLumium);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotEnderium, BlockStorageAlloy.blockEnderium);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetIron, ItemMaterial.ingotIron);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetGold, ItemMaterial.ingotGold);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetDiamond, ItemMaterial.gemDiamond);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetEmerald, ItemMaterial.gemEmerald);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetCopper, ItemMaterial.ingotCopper);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetTin, ItemMaterial.ingotTin);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetSilver, ItemMaterial.ingotSilver);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetLead, ItemMaterial.ingotLead);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetAluminum, ItemMaterial.ingotAluminum);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetNickel, ItemMaterial.ingotNickel);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetPlatinum, ItemMaterial.ingotPlatinum);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetIridium, ItemMaterial.ingotIridium);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetMithril, ItemMaterial.ingotMithril);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetSteel, ItemMaterial.ingotSteel);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetElectrum, ItemMaterial.ingotElectrum);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetInvar, ItemMaterial.ingotInvar);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetBronze, ItemMaterial.ingotBronze);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetConstantan, ItemMaterial.ingotConstantan);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetSignalum, ItemMaterial.ingotSignalum);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetLumium, ItemMaterial.ingotLumium);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetEnderium, ItemMaterial.ingotEnderium);
        FactorizerManager.loadRecipes();
    }

    public static void loadRecipes() {
        for (String oreName : OreDictionary.getOreNames()) {
            if (!oreName.startsWith("ingot")) continue;
            String oreType = oreName.substring(5, oreName.length());
            FactorizerManager.addDefaultRecipe(ItemHelper.getOre((String)("ingot" + oreType)), ItemHelper.getOre((String)("block" + oreType)));
            FactorizerManager.addDefaultRecipe(ItemHelper.getOre((String)("nugget" + oreType)), ItemHelper.getOre((String)("ingot" + oreType)));
        }
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            int i;
            boolean match;
            if (recipe instanceof ShapedRecipes) {
                ShapedRecipes target = (ShapedRecipes)recipe;
                if (target.field_77574_d.size() != 9 || ((Ingredient)target.field_77574_d.get(0)).func_193365_a().length <= 0) continue;
                match = true;
                for (i = 1; i < target.field_77574_d.size(); ++i) {
                    match &= ((Ingredient)target.field_77574_d.get(i)).func_193365_a().length > 0 && ItemHelper.itemsIdentical((ItemStack)((Ingredient)target.field_77574_d.get(0)).func_193365_a()[0], (ItemStack)((Ingredient)target.field_77574_d.get(i)).func_193365_a()[0]);
                }
                if (!match) continue;
                FactorizerManager.addDefaultRecipe(((Ingredient)target.field_77574_d.get(0)).func_193365_a()[0], target.func_77571_b(), target.field_77574_d.size());
                continue;
            }
            if (!(recipe instanceof ShapelessRecipes)) continue;
            ShapelessRecipes target = (ShapelessRecipes)recipe;
            if (target.field_77579_b.size() != 9 || ((Ingredient)target.field_77579_b.get(0)).func_193365_a().length <= 0) continue;
            match = true;
            for (i = 1; i < target.field_77579_b.size(); ++i) {
                match &= ((Ingredient)target.field_77579_b.get(i)).func_193365_a().length > 0 && ItemHelper.itemsIdentical((ItemStack)((Ingredient)target.field_77579_b.get(0)).func_193365_a()[0], (ItemStack)((Ingredient)target.field_77579_b.get(i)).func_193365_a()[0]);
            }
            if (!match) continue;
            FactorizerManager.addDefaultRecipe(((Ingredient)target.field_77579_b.get(0)).func_193365_a()[0], target.func_77571_b(), target.field_77579_b.size());
        }
    }

    public static void refresh() {
        ComparableItemStackValidated input;
        FactorizerRecipe tempRecipe;
        Object2ObjectOpenHashMap tempMap = new Object2ObjectOpenHashMap(recipeMap.size());
        Object2ObjectOpenHashMap tempMapReverse = new Object2ObjectOpenHashMap(recipeMapReverse.size());
        for (Map.Entry<ComparableItemStackValidated, FactorizerRecipe> entry : recipeMap.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackValidated(tempRecipe.input);
            tempMap.put(input, tempRecipe);
        }
        for (Map.Entry<ComparableItemStackValidated, FactorizerRecipe> entry : recipeMapReverse.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackValidated(tempRecipe.input);
            tempMapReverse.put(input, tempRecipe);
        }
        recipeMap.clear();
        recipeMapReverse.clear();
        recipeMap = tempMap;
        recipeMapReverse = tempMapReverse;
    }

    public static FactorizerRecipe addRecipe(ItemStack input, ItemStack output, boolean reverse) {
        if (input.func_190926_b() || output.func_190926_b() || FactorizerManager.recipeExists(input, reverse)) {
            return null;
        }
        FactorizerRecipe recipe = new FactorizerRecipe(input, output);
        if (reverse) {
            recipeMapReverse.put(new ComparableItemStackValidated(input), recipe);
        } else {
            recipeMap.put(new ComparableItemStackValidated(input), recipe);
        }
        return recipe;
    }

    public static FactorizerRecipe removeRecipe(ItemStack input, boolean reverse) {
        if (reverse) {
            return recipeMapReverse.remove(new ComparableItemStackValidated(input));
        }
        return recipeMap.remove(new ComparableItemStackValidated(input));
    }

    public static void addDefaultRecipe(ItemStack input, ItemStack output) {
        FactorizerManager.addDefaultRecipe(input, output, 9);
    }

    public static void addDefaultRecipe(ItemStack input, ItemStack output, int count) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        ItemStack inputStack = ItemHelper.cloneStack((ItemStack)input, (int)count);
        if (!FactorizerManager.recipeExists(inputStack, false)) {
            FactorizerManager.addRecipe(inputStack, output, false);
        }
        if (!FactorizerManager.recipeExists(output, true)) {
            FactorizerManager.addRecipe(output, inputStack, true);
        }
    }

    public static class FactorizerRecipe {
        final ItemStack input;
        final ItemStack output;

        FactorizerRecipe(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }
    }
}

