/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.modelspec;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.machinemuse.numina.utils.MuseLogger;
import net.machinemuse.numina.utils.map.MuseRegistry;
import net.machinemuse.powersuits.client.model.obj.OBJModelPlus;
import net.machinemuse.powersuits.client.model.obj.OBJPlusLoader;
import net.machinemuse.powersuits.client.render.modelspec.ModelSpec;
import net.machinemuse.powersuits.client.render.modelspec.PartSpecBase;
import net.machinemuse.powersuits.client.render.modelspec.SpecBase;
import net.machinemuse.powersuits.utils.MuseStringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class ModelRegistry
extends MuseRegistry<SpecBase> {
    private static volatile ModelRegistry INSTANCE;

    private ModelRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ModelRegistry getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ModelRegistry> clazz = ModelRegistry.class;
        synchronized (ModelRegistry.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ModelRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static OBJModelPlus getIModel(ResourceLocation location, int attempt) {
        IModel model;
        String domain = location.func_110624_b();
        String resourePath = location.func_110623_a().replaceFirst("^models/models", "models");
        location = new ResourceLocation(domain, resourePath);
        try {
            model = OBJPlusLoader.INSTANCE.loadModel(location);
            model = ((OBJModelPlus)model).process((ImmutableMap<String, String>)ImmutableMap.of((Object)"flip-v", (Object)"true"));
        }
        catch (Exception e) {
            model = ModelLoaderRegistry.getMissingModel();
            if (attempt >= 6) {
                return (OBJModelPlus)model;
            }
            ModelRegistry.getIModel(location, attempt + 1);
            MuseLogger.logError("Model loading failed on attempt #" + attempt + "  :( " + location.toString());
            MuseLogger.logError("Failed to loadButton model. " + e);
        }
        return (OBJModelPlus)model;
    }

    @Nullable
    public static OBJModelPlus.OBJBakedModelPus wrap(ResourceLocation modellocation, IModelState modelState) {
        OBJModelPlus model = ModelRegistry.getIModel(modellocation, 0);
        try {
            return (OBJModelPlus.OBJBakedModelPus)model.bake(modelState, DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
        }
        catch (Exception e) {
            MuseLogger.logError("Failed to bake model. " + e);
            return null;
        }
    }

    public OBJModelPlus.OBJBakedModelPus loadBakedModel(ResourceLocation resource, IModelState modelState) {
        String name = MuseStringUtils.extractName(resource);
        SpecBase spec = (SpecBase)this.get(name);
        if (spec == null) {
            return ModelRegistry.wrap(resource, modelState);
        }
        return ((ModelSpec)spec).getModel();
    }

    public Iterable<SpecBase> getSpecs() {
        return this.elems();
    }

    public Iterable<String> getNames() {
        return this.names();
    }

    public SpecBase getModel(NBTTagCompound nbt) {
        return (SpecBase)this.get(nbt.func_74779_i("model"));
    }

    public PartSpecBase getPart(NBTTagCompound nbt, SpecBase model) {
        return (PartSpecBase)model.get(nbt.func_74779_i("part"));
    }

    public PartSpecBase getPart(NBTTagCompound nbt) {
        return this.getPart(nbt, this.getModel(nbt));
    }

    public NBTTagCompound getSpecTag(NBTTagCompound museRenderTag, PartSpecBase spec) {
        String name = this.makeName(spec);
        return museRenderTag.func_74764_b(name) ? museRenderTag.func_74775_l(name) : null;
    }

    public String makeName(PartSpecBase spec) {
        return spec.spec.getOwnName() + "." + spec.partName;
    }
}

