/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.network.packets;

import io.netty.buffer.ByteBuf;
import net.machinemuse.numina.item.IModeChangingItem;
import net.machinemuse.numina.module.IEnchantmentModule;
import net.machinemuse.numina.module.IPowerModule;
import net.machinemuse.numina.module.IRightClickModule;
import net.machinemuse.numina.network.MuseByteBufferUtils;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.numina.utils.nbt.MuseNBTUtils;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MusePacketSalvageModuleRequest
implements IMessage {
    EntityPlayer player;
    int itemSlot;
    String moduleName;

    public MusePacketSalvageModuleRequest() {
    }

    public MusePacketSalvageModuleRequest(EntityPlayer player, int itemSlot, String moduleName) {
        this.player = player;
        this.itemSlot = itemSlot;
        this.moduleName = moduleName;
    }

    public void fromBytes(ByteBuf buf) {
        this.itemSlot = buf.readInt();
        this.moduleName = MuseByteBufferUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.itemSlot);
        MuseByteBufferUtils.writeUTF8String((ByteBuf)buf, (String)this.moduleName);
    }

    public static class Handler
    implements IMessageHandler<MusePacketSalvageModuleRequest, IMessage> {
        public IMessage onMessage(MusePacketSalvageModuleRequest message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                player.func_71121_q().func_152344_a(() -> {
                    int itemSlot = message.itemSlot;
                    String moduleName = message.moduleName;
                    if (moduleName != null) {
                        ItemStack stack = player.field_71071_by.func_70301_a(itemSlot);
                        NonNullList<ItemStack> refund = ModuleManager.INSTANCE.getInstallCost(moduleName);
                        if (ModuleManager.INSTANCE.itemHasModule(stack, moduleName)) {
                            MuseNBTUtils.removeMuseValuesTag(stack);
                            ModuleManager.INSTANCE.removeModule(stack, moduleName);
                            for (ItemStack refundItem : refund) {
                                MuseItemUtils.giveOrDropItemWithChance((EntityPlayer)player, refundItem.func_77946_l(), MPSConfig.INSTANCE.getSalvageChance());
                            }
                            IPowerModule module = ModuleManager.INSTANCE.getModule(moduleName);
                            if (stack.func_77973_b() instanceof IModeChangingItem && module instanceof IRightClickModule) {
                                if (module instanceof IEnchantmentModule) {
                                    ((IEnchantmentModule)module).removeEnchantment(stack);
                                }
                                ((IModeChangingItem)stack.func_77973_b()).setActiveMode(stack, "");
                            }
                        }
                    }
                });
            }
            return null;
        }
    }
}

