/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.energy_generation;

import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.numina.module.EnumModuleTarget;
import net.machinemuse.numina.module.IPlayerTickModule;
import net.machinemuse.numina.utils.energy.ElectricItemUtils;
import net.machinemuse.numina.utils.heat.MuseHeatUtils;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ThermalGeneratorModule
extends PowerModuleBase
implements IPlayerTickModule {
    public ThermalGeneratorModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 2));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.ironPlating, 1));
        this.addBasePropertyDouble("thermalEnergyGen", 250.0);
        this.addTradeoffPropertyDouble("energyGenerated", "thermalEnergyGen", 250.0, "RF");
    }

    @Override
    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_ENERGY_GENERATION;
    }

    @Override
    public String getDataName() {
        return "thermalGenerator";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        double currentHeat = MuseHeatUtils.getPlayerHeat(player);
        double maxHeat = MuseHeatUtils.getPlayerMaxHeat(player);
        if (player.field_70170_p.func_82737_E() % 20L == 0L) {
            if (player.func_70027_ad()) {
                ElectricItemUtils.givePlayerEnergy(player, (int)(4.0 * ModuleManager.INSTANCE.getOrSetModularPropertyDouble(item, "thermalEnergyGen")));
            } else if (currentHeat >= 200.0) {
                ElectricItemUtils.givePlayerEnergy(player, (int)(2.0 * ModuleManager.INSTANCE.getOrSetModularPropertyDouble(item, "thermalEnergyGen")));
            } else if (currentHeat / maxHeat >= 0.5) {
                ElectricItemUtils.givePlayerEnergy(player, (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(item, "thermalEnergyGen"));
            }
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.thermalGenerator;
    }
}

