/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.weapon;

import javax.annotation.Nonnull;
import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.numina.module.EnumModuleTarget;
import net.machinemuse.numina.module.IPlayerTickModule;
import net.machinemuse.numina.module.IRightClickModule;
import net.machinemuse.numina.utils.energy.ElectricItemUtils;
import net.machinemuse.numina.utils.heat.MuseHeatUtils;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.utils.MusePlayerUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RailgunModule
extends PowerModuleBase
implements IRightClickModule,
IPlayerTickModule {
    public RailgunModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.solenoid, 6));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.hvcapacitor, 1));
        this.addBasePropertyDouble("railgunTotalImpulse", 500.0, "Ns");
        this.addBasePropertyDouble("railgunEnergyCost;", 5000.0, "RF");
        this.addBasePropertyDouble("railgunHeatEm", 2.0, "");
        this.addTradeoffPropertyDouble("voltage", "railgunTotalImpulse", 2500.0);
        this.addTradeoffPropertyDouble("voltage", "railgunEnergyCost;", 25000.0);
        this.addTradeoffPropertyDouble("voltage", "railgunHeatEm", 10.0);
    }

    @Override
    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_WEAPON;
    }

    @Override
    public String getDataName() {
        return "railgun";
    }

    public void drawParticleStreamTo(EntityPlayer source, World world, double x, double y, double z) {
        Vec3d direction = source.func_70040_Z().func_72432_b();
        double xoffset = 1.3f;
        double yoffset = -0.2;
        double zoffset = 0.3f;
        Vec3d horzdir = direction.func_72432_b();
        horzdir = new Vec3d(horzdir.field_72450_a, 0.0, horzdir.field_72449_c);
        horzdir = horzdir.func_72432_b();
        double cx = source.field_70165_t + direction.field_72450_a * xoffset - direction.field_72448_b * horzdir.field_72450_a * yoffset - horzdir.field_72449_c * zoffset;
        double cy = source.field_70163_u + (double)source.func_70047_e() + direction.field_72448_b * xoffset + (1.0 - Math.abs(direction.field_72448_b)) * yoffset;
        double cz = source.field_70161_v + direction.field_72449_c * xoffset - direction.field_72448_b * horzdir.field_72449_c * yoffset + horzdir.field_72450_a * zoffset;
        double dx = x - cx;
        double dy = y - cy;
        double dz = z - cz;
        double ratio = Math.sqrt(dx * dx + dy * dy + dz * dz);
        while (Math.abs(cx - x) > Math.abs(dx / ratio)) {
            world.func_175688_a(EnumParticleTypes.TOWN_AURA, cx, cy, cz, 0.0, 0.0, 0.0, new int[0]);
            cx += dx * 0.1 / ratio;
            cy += dy * 0.1 / ratio;
            cz += dz * 0.1 / ratio;
        }
    }

    @Override
    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            double range = 64.0;
            double timer = MuseItemUtils.getDoubleOrZero(itemStackIn, "cooldown");
            double energyConsumption = this.getEnergyUsage(itemStackIn);
            if ((double)ElectricItemUtils.getPlayerEnergy(playerIn) > energyConsumption && timer == 0.0) {
                ElectricItemUtils.drainPlayerEnergy(playerIn, (int)energyConsumption);
                MuseItemUtils.setDoubleOrRemove(itemStackIn, "cooldown", 10.0);
                MuseHeatUtils.heatPlayer(playerIn, ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStackIn, "railgunHeatEm"));
                RayTraceResult hitMOP = MusePlayerUtils.doCustomRayTrace(playerIn.field_70170_p, playerIn, true, range);
                worldIn.func_184133_a(playerIn, playerIn.func_180425_c(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
                double damage = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStackIn, "railgunTotalImpulse") / 100.0;
                double knockback = damage / 20.0;
                Vec3d lookVec = playerIn.func_70040_Z();
                if (hitMOP != null) {
                    switch (hitMOP.field_72313_a) {
                        case ENTITY: {
                            this.drawParticleStreamTo(playerIn, worldIn, hitMOP.field_72307_f.field_72450_a, hitMOP.field_72307_f.field_72448_b, hitMOP.field_72307_f.field_72449_c);
                            DamageSource damageSource = DamageSource.func_76365_a((EntityPlayer)playerIn);
                            if (!hitMOP.field_72308_g.func_70097_a(damageSource, (float)((int)damage))) break;
                            hitMOP.field_72308_g.func_70024_g(lookVec.field_72450_a * knockback, Math.abs(lookVec.field_72448_b + (double)0.2f) * knockback, lookVec.field_72449_c * knockback);
                            break;
                        }
                        case BLOCK: {
                            this.drawParticleStreamTo(playerIn, worldIn, hitMOP.field_72307_f.field_72450_a, hitMOP.field_72307_f.field_72448_b, hitMOP.field_72307_f.field_72449_c);
                            break;
                        }
                    }
                    playerIn.func_70024_g(-lookVec.field_72450_a * knockback, Math.abs(-lookVec.field_72448_b + (double)0.2f) * knockback, -lookVec.field_72449_c * knockback);
                    worldIn.func_184133_a(playerIn, playerIn.func_180425_c(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
                }
                playerIn.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    @Override
    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    @Override
    public int getEnergyUsage(@Nonnull ItemStack itemStack) {
        return (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "railgunEnergyCost;");
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack stack) {
        double timer = MuseItemUtils.getDoubleOrZero(stack, "cooldown");
        if (timer > 0.0) {
            MuseItemUtils.setDoubleOrRemove(stack, "cooldown", timer - 1.0 > 0.0 ? timer - 1.0 : 0.0);
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.railgun;
    }
}

